/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.interceptors;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.IpUtil;
import com.biz.eisp.base.common.util.JsonUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TokenUtil;
import com.biz.eisp.base.common.util.json.Head;
import com.biz.eisp.base.common.util.json.ResponseBean;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.utils.AppcenterUtil;
import com.biz.eisp.base.utils.CookiesUtil;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.login.service.AuthExtendInterceptor;
import com.biz.eisp.login.service.LoginService;
import com.biz.eisp.login.utils.Snippet;
import com.biz.eisp.mdm.function.service.MenuPermissionService;
import com.biz.eisp.mdm.position.service.PositionService;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.vo.TmRoleFunctionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.web.Oauth2Vo;
import com.biz.eisp.mdm.web.pojo.Client;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuthInterceptor
implements HandlerInterceptor {
    private List<String> excludeUrls;
    @Autowired
    private MenuPermissionService menuPermissionService;
    @Autowired
    private TmUserService tmUserService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private TmPositionService tmPositionService;
    @Autowired(required=false)
    private AuthExtendInterceptor authExtendInterceptor;

    public List<String> getExcludeUrls() {
        return this.excludeUrls;
    }

    public void setExcludeUrls(List<String> excludeUrls) {
        this.excludeUrls = excludeUrls;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object object, Exception exception) throws Exception {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object object, ModelAndView modelAndView) throws Exception {
        String accessEntry = request.getParameter("clickFunctionId");
        if (StringUtil.isEmpty(accessEntry)) {
            accessEntry = request.getParameter("accessEntry");
        }
        request.setAttribute("accessEntry", (Object)accessEntry);
        String pub_version = ResourceUtil.getSysConfigProperty("pub_version");
        request.setAttribute("pubVersion", (Object)pub_version);
    }

    private boolean doCas(HttpServletRequest request, HttpServletResponse response) {
        Principal principalTemp = request.getUserPrincipal();
        if (principalTemp == null) {
            return false;
        }
        AttributePrincipal principal = (AttributePrincipal)principalTemp;
        String usename = principal.getName();
        if (StringUtil.isEmpty(usename)) {
            return false;
        }
        String hql = "from TmUserEntity where userName = ? ";
        List list = this.tmUserService.findByHql(hql, usename);
        if (CollectionUtil.listEmpty(list)) {
            return false;
        }
        TmUserEntity userEntity = (TmUserEntity)list.get(0);
        List<TmPositionVo> positions = this.positionService.getPositinByUserId(userEntity, Globals.Main_Position_Type);
        if (CollectionUtil.listEmpty(positions)) {
            return false;
        }
        TmPositionVo tmPositionVo = positions.get(0);
        try {
            String key = Snippet.aesEncrypt(CookiesUtil.getKeyFlag(userEntity.getUserName()), "1oR8uIM2O5qv65l2");
            CookiesUtil.doCoke(request, response, key);
            UserRedis userRedis = this.loginService.createUserRedis(userEntity, null, tmPositionVo, Globals.LOGIN_SOURCE_ZT);
            String ip = IpUtil.getIpAddr(request);
            userRedis.setIp(ip);
            String value = JsonUtil.bean2json(userRedis);
            this.redisService.setSeconds("LOGIN_SUCCESS_" + key, value, 86400L);
            request.getSession().setAttribute("loginUserToken", (Object)key);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        String reqUrl = ResourceUtil.getRequestPath(request);
        String phoneSend = request.getParameter("phoneSend");
        String posId = request.getParameter("posId");
        String userId = request.getParameter("userId");
        String subFlag = request.getParameter("subFlag");
        String isLogin = request.getParameter("isLogin");
        String tokenStr = request.getParameter("TOKEN_STRING_NAME");
        String wxtag = request.getParameter("wx");
        String wxopenid = request.getParameter("wxopenid");
        HttpSession session = ContextHolderUtils.getSession();
        Client client = ResourceUtil.getClient();
        if (client == null) {
            client = ResourceUtil.getClient();
        }
        if (StringUtil.isNotEmpty((String)phoneSend) && phoneSend.equals("1")) {
            String need_token = ResourceUtil.getSysConfigProperty("need_token");
            if (StringUtils.isBlank((String)need_token) || "0".equals(need_token)) {
                if (StringUtil.isNotEmpty((String)userId) && StringUtil.isNotEmpty((String)posId) && !"offline".equalsIgnoreCase(subFlag) && !Globals.phoneNoIntecepter.containsKey(reqUrl) && this.tmPositionService.isMainPosition(posId) == 0L) {
                    this.tmPositionService.updatePositionIsMain(userId, posId);
                }
                return true;
            }
            session.setAttribute("TOKEN_STRING_NAME", (Object)tokenStr);
            if ("offline".equalsIgnoreCase(subFlag)) {
                return true;
            }
            if (StringUtil.isNotEmpty((String)isLogin) && isLogin.equals("1")) {
                return true;
            }
            if (StringUtils.isBlank((String)tokenStr)) {
                this.valid(response);
                return false;
            }
            if (!TokenUtil.isTokenStringValid(this.redisService, tokenStr)) {
                this.valid(response);
                return false;
            }
            return true;
        }
        if (StringUtils.isNotBlank((String)wxtag) && wxtag.equals("1")) {
            if (client == null) {
                String code = request.getParameter("code");
                response.sendRedirect("memberController.do?gologin&_requestPath=" + reqUrl + "&code=" + code + "&wxopenid=" + wxopenid);
                return false;
            }
            Oauth2Vo oau = client.getOau();
            if (oau == null) {
                String code = request.getParameter("code");
                response.sendRedirect("memberController.do?gologin&_requestPath=" + reqUrl + "&code=" + code + "&wxopenid=" + wxopenid);
                return false;
            }
            if (oau != null && StringUtils.isNotBlank((String)oau.getSapid()) && !this.checksap(oau.getSapid())) {
                response.sendRedirect("memberController.do?gologin&_requestPath=" + reqUrl + "&opbind=1&bindid=" + oau.getSapid() + "&wxopenid=" + wxopenid);
                return false;
            }
            if (oau != null && StringUtils.isBlank((String)oau.getSapid())) {
                String code = request.getParameter("code");
                response.sendRedirect("memberController.do?gologin&_requestPath=" + reqUrl + "&code=" + code + "&wxopenid=" + wxopenid);
                return false;
            }
            return true;
        }
        if (this.excludeUrls.contains(reqUrl)) {
            return true;
        }
        if (client != null && client.getUser() == null && this.doCas(request, response)) {
            return true;
        }
        if (Objects.nonNull(this.authExtendInterceptor)) {
            return this.authExtendInterceptor.interceptor(request, response, client);
        }
        if (client == null) {
            this.forward(request, response);
            return false;
        }
        if (client.getUser() == null) {
            this.forward(request, response);
            return false;
        }
        TmUserEntity tmUserEntity = client.getUser();
        String key = AppcenterUtil.getUserKey();
        if (StringUtil.isNotBlank((String)key)) {
            request.getSession().setAttribute("loginUserToken", (Object)key);
        }
        List<TmRoleFunctionVo> roleFunctionVos = this.menuPermissionService.getOperationsByRequest(request, tmUserEntity);
        String dataBase = ResourceUtil.getSysConfigProperty("dataBase");
        if (!"mysql".equals(dataBase)) {
            this.menuPermissionService.getDataRuleByRequest(request, roleFunctionVos);
        }
        return true;
    }

    private void valid(HttpServletResponse response) throws Exception {
        ResponseBean bean = new ResponseBean();
        Head head = new Head();
        head.setCode(106);
        head.setMessage("token\u5931\u6548!");
        bean.setHead(head);
        response.setContentType("application/json");
        PrintWriter out = response.getWriter();
        out.print(JsonUtil.bean2json(bean));
        out.flush();
    }

    public void noPermisson(HttpServletResponse response) throws IOException {
        response.sendRedirect("loginController.do?noPermisson");
    }

    @RequestMapping(params={"forword"})
    public ModelAndView forword(HttpServletRequest request) {
        return new ModelAndView("redirect:/loginController.do?login");
    }

    private void forward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.getRequestDispatcher("pages/login/timeout.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public boolean checksap(String sapcode) {
        boolean b = false;
        TmUserEntity user = this.tmUserService.findUniqueByProperty(TmUserEntity.class, "userName", sapcode);
        if (user != null && user.getEnableStatus() != null && Globals.ZERO.equals(user.getEnableStatus())) {
            b = true;
        }
        return b;
    }
}

