/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer;

import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.JsonUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.dao.HibernatePersister;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.importer.ImpConfigurator;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.ImpInfo;
import com.biz.eisp.base.importer.ImportEnum;
import com.biz.eisp.base.importer.Importer;
import com.biz.eisp.base.importer.NoCatchImportException;
import com.biz.eisp.base.importer.PersisterHolder;
import com.biz.eisp.base.importer.iterator.DataIterator;
import com.biz.eisp.base.importer.validator.DataValidator;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddressList;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.hibernate.CacheMode;

public abstract class AbstractHibernateImporter
implements Importer {
    public static final Pattern PATTERN = Pattern.compile("(?<=\\$\\{)[\\w|\\.]*(?=\\})");
    public static final int MAX_ERROR_NUM = 200;
    public static final int MAX_MESSAGE_NUM = 200;
    protected ImpConfigurator conf;
    protected Map<String, Object> params;
    protected HibernatePersister persister;
    protected Map<String, DataValidator> validator;
    protected DataIterator iterator;
    protected Map<String, Object> objcache = new HashMap();
    protected StringBuilder errors;
    protected int errNum = 0;
    protected int succNum = 0;
    protected int setNullNum = 0;
    protected int skipRowNum = 0;
    protected int skipColNum = 0;
    protected StringBuilder messages;
    protected Date currTime = new Date();
    protected ImpEventHandler event;
    protected boolean isTest;
    private int commited = 0;
    private ImpInfo impInfo;
    private String batchCode;
    private boolean isDistributed;
    private String key;
    private RedisService redisService;
    private BaseService baseService;
    protected Map<String, String> deleted = new HashMap();

    public AbstractHibernateImporter(ImpConfigurator conf, Map<String, Object> params) {
        Object isd = params.get(ImportEnum.isDistributed.getValue());
        Object kname = params.get(ImportEnum.keyName.getValue());
        this.isDistributed = isd != null ? Boolean.valueOf(isd.toString()) : false;
        this.key = kname != null ? kname.toString() : "";
        this.conf = conf;
        this.params = params;
        List cols = conf.getFields();
        this.validator = new HashMap();
        for (DataField f : cols) {
            if (!StringUtils.isNotBlank((String)f.getCode())) continue;
            this.validator.put(f.getCode(), ValidatorFactory.createValidator((DataField)f));
        }
    }

    public void init() {
        this.errors = new StringBuilder();
        this.errNum = 0;
        this.succNum = 0;
        this.setNullNum = 0;
        this.skipRowNum = 0;
        this.skipColNum = 0;
        this.messages = new StringBuilder();
        Object base = ApplicationContextUtils.getContext().getBean("baseService");
        this.baseService = base != null ? (BaseService)base : null;
    }

    protected void setIterator(DataIterator iterator) {
        this.iterator = iterator;
    }

    public DataIterator getIterator() {
        return this.iterator;
    }

    protected void setPersister(HttpSession session) {
        this.persister = new HibernatePersister(session);
    }

    protected void setEventHandler() throws InstantiationException, IllegalAccessException {
        if (this.conf.getEventHandler() != null) {
            this.event = (ImpEventHandler)this.conf.getEventHandler().newInstance();
            this.event.init(this.conf, this.persister, this.params, this.conf.getTableName());
            this.event.setImporter(this);
        }
    }

    public ImpInfo imp(DataIterator iterator, HttpSession session) throws Exception {
        if (this.isDistributed) {
            Object redis = ApplicationContextUtils.getContext().getBean("redisService");
            this.redisService = redis != null ? (RedisService)redis : null;
        }
        this.isTest = false;
        this.init();
        this.setIterator(iterator);
        if (this.isDistributed) {
            this.redisService.hset(this.key, ImportEnum.Size.getValue(), (Object)iterator.getSize(), 1800L);
        }
        try {
            this.setPersister(session);
            PersisterHolder.setHibernatePersister((HibernatePersister)this.persister);
            this.setEventHandler();
            this.persister.beginTransaction();
            if (this.conf.isDeleteByKey() && this.conf.getKeyField() == null) {
                this.deleteByKey(null);
            }
            if (this.errNum == 0 && this.event != null) {
                this.event.start();
            }
            ImpInfo info = this.impData(this.redisService);
            if (this.errNum == 0) {
                this.persister.flush();
                if (this.event != null) {
                    try {
                        this.event.end();
                    }
                    catch (Exception e) {
                        if (e instanceof NoCatchImportException) {
                            info.setMessages(e.getMessage());
                        }
                        throw e;
                    }
                }
            }
            this.persister.commit();
            if (this.isDistributed) {
                this.redisService.hset(this.key, ImportEnum.ImpInfo.getValue(), (Object)JsonUtil.bean2json((Object)info), 1800L);
            }
            ImpInfo impInfo = info;
            return impInfo;
        }
        catch (Exception e) {
            this.persister.rollback();
            if (this.event != null) {
                this.event.fatalError(e);
            }
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                this.persister.close();
                this.persister = null;
                PersisterHolder.clearHibernatePersister();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ImpInfo test(DataIterator iterator) throws Exception {
        this.isTest = true;
        RedisService redisService = null;
        if (this.isDistributed) {
            Object redis = ApplicationContextUtils.getContext().getBean("redisService");
            redisService = redis != null ? (RedisService)redis : null;
        }
        this.init();
        this.setIterator(iterator);
        try {
            this.setPersister(ContextHolderUtils.getSession());
            this.setEventHandler();
            log.info((Object)"test imp start ...");
            if (this.errNum == 0 && this.event != null) {
                this.event.start();
            }
            ImpInfo info = this.impData(redisService);
            if (this.errNum == 0 && this.event != null) {
                this.event.end();
            }
            log.info((Object)"test imp end ...");
            ImpInfo impInfo = info;
            return impInfo;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.persister.close();
            this.persister = null;
        }
    }

    protected ImpInfo impData(RedisService redisService) throws ValidateException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.persister.getSession().setCacheMode(CacheMode.GET);
        while (this.iterator.hasNext()) {
            Map row = (Map)this.iterator.next();
            try {
                if (this.iterator.getIndex() >= this.conf.getStartRow()) {
                    if (this.event != null) {
                        this.event.setIndex(this.iterator.getIndex());
                        if (this.isDistributed) {
                            redisService.hset(this.key, ImportEnum.Index.getValue(), (Object)(this.iterator.getIndex() + ""), 1800L);
                        }
                        this.event.setRowNumber(this.iterator.getRowNumber());
                        if (this.errNum == 0 && !this.isTest) {
                            this.event.startRow(row);
                        }
                        this.event.validate(row);
                    }
                    Object bean = this.saveRow(row);
                    if (this.errNum == 0 && !this.isTest && this.event != null) {
                        this.event.endRow(row, bean);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage() + " (" + "\u884c" + ":" + this.iterator.getRowNumber() + ")", e);
            }
            if (this.iterator.getIndex() % 15 == 0) {
                if (this.errNum == 0 && !this.isTest) {
                    this.persister.flush();
                }
                this.persister.clear();
            }
            if (this.iterator.getIndex() % this.conf.getBatches() != 0) continue;
            if (this.errNum == 0 && !this.isTest) {
                if (this.event != null) {
                    this.event.end();
                }
                this.persister.commit();
                this.commited += this.conf.getBatches();
                this.persister.beginTransaction();
            }
            log.info((Object)(this.iterator.getIndex() + " submitted ..."));
        }
        if (this.errNum > 0) {
            if (this.commited > 0) {
                this.addError("<font color='red'>\u6ce8\u610f: \u524d " + this.commited + " \u6570\u636e\u5df2\u7ecf\u6210\u529f\u5bfc\u5165.</font>");
            }
            throw new ValidateException(this.errors.toString());
        }
        ImpInfo info = new ImpInfo();
        info.setSuccNum(this.succNum);
        info.setNullNum(this.setNullNum);
        info.setSkipRowNum(this.skipRowNum);
        info.setSkipColNum(this.skipColNum);
        info.setMessages(this.messages.toString());
        return info;
    }

    protected Object saveRow(Map<String, Object> row) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ValidateException {
        Object bean = null;
        DataField[] keyField = this.conf.getKeyField();
        if (keyField != null && this.conf.isAutoSave()) {
            if (this.conf.isDeleteByKey()) {
                if (!this.isTest) {
                    this.deleteByKey(row);
                }
            } else {
                bean = this.getKeyObject(keyField, bean, row);
            }
        }
        boolean ignoreNull = this.conf.isIgnoreNull();
        boolean isSkip = false;
        for (DataField field : this.conf.getFields()) {
            if (ignoreNull) {
                String value = (String)row.get(field.getName());
                if (value != null && value.length() != 0) continue;
            }
            String prop = field.getCode();
            try {
                Object v = this.getValue(field, bean, row);
                if (!field.isAvailable() || prop.indexOf(".") == -1) continue;
                String[] props = prop.split("\\.");
                if (v != null) {
                    v = this.getRefObject(field, bean, props, v, field.getFilter());
                }
                prop = props[0];
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.errNum == 0 && this.event != null) {
                    this.event.error(field, row, e);
                }
                if ("skipRow".equals(field.getOnError()) || field.isAllowSkip()) {
                    if (isSkip) continue;
                    isSkip = true;
                    this.addMessage(e.getMessage(), "skipRow", row, field);
                    continue;
                }
                if ("skipCol".equals(field.getOnError())) {
                    this.addMessage(e.getMessage(), "skipCol", row, field);
                    continue;
                }
                if ("setNull".equals(field.getOnError())) {
                    PropertyUtils.setSimpleProperty((Object)bean, (String)prop, null);
                    this.addMessage(e.getMessage(), "setNull", row, field);
                    continue;
                }
                this.addError(e.getMessage(), row, field);
            }
        }
        if (this.conf.isAutoSave()) {
            this.event.persisterBean(bean, isSkip);
        } else {
            bean = this.conf.getEntityClass().newInstance();
            if (StringUtil.isNotEmpty((Object)bean)) {
                try {
                    MyBeanUtils.copyMap2Bean((Object)bean, row);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return bean;
    }

    protected void save(Object object) {
        if (this.isTest) {
            return;
        }
        this.persister.save(object);
    }

    protected Object getBean(Class clazz, String[] key, Object[] value, String[] filter) {
        StringBuilder sb = new StringBuilder("from ").append(clazz.getSimpleName()).append(" where 1=1");
        for (String k : key) {
            sb.append(" and ").append(k).append("=?");
        }
        for (String f : filter) {
            if (!StringUtils.isNotBlank((String)f)) continue;
            sb.append(" and ").append(f);
        }
        return this.persister.findUnique(sb.toString(), value);
    }

    protected Object getKeyObject(DataField[] keyField, Object bean, Map<String, Object> row) {
        if (this.isTest) {
            return null;
        }
        try {
            String[] c = new String[keyField.length];
            Object[] v = new Object[keyField.length];
            for (int j = 0; j < keyField.length; ++j) {
                DataField df = keyField[j];
                if (df == null) continue;
                c[j] = df.getCode();
                v[j] = this.getValue(df, bean, row);
            }
            bean = this.getBean(this.conf.getEntityClass(), c, v, new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bean;
    }

    protected Object getRefObject(DataField keyField, Object bean, String[] prop, Object value, String filter) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ValidateException {
        String objKey = keyField.getCode() + "." + value;
        Object obj = this.objcache.get(objKey);
        if (obj == null) {
            Class propClass = PropertyUtils.getPropertyType((Object)bean, (String)prop[0]);
            int i = keyField.getCode().indexOf(".") + 1;
            obj = this.getBean(propClass, new String[]{keyField.getCode().substring(i)}, new Object[]{value}, new String[]{filter});
            if (obj != null) {
                this.objcache.put(objKey, obj);
            }
        }
        if (obj == null) {
            throw new ValidateException(keyField.getTitle() + "\u5173\u8054\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
        }
        return obj;
    }

    protected Object getValue(DataField field, Object bean, Map<String, Object> row) throws ValidateException {
        if (StringUtil.isNotEmpty((String)field.getFormat())) {
            return row.get(field.getCode());
        }
        String value = (String)row.get(field.getCode());
        if (StringUtils.isNotBlank((String)field.getValue())) {
            value = this.eval(new Object[]{row, bean, this.params}, field.getValue());
        }
        DataValidator dv = (DataValidator)this.validator.get(field.getCode());
        Object v = null;
        if (dv != null) {
            v = dv.validate(value);
        }
        if ("".equals(v)) {
            v = null;
        }
        if (v instanceof Integer) {
            v = Integer.parseInt(String.valueOf(v));
        }
        if (v instanceof Double) {
            v = BigDecimal.valueOf((Double)v);
        }
        if (StringUtils.isNotBlank((String)field.getIdBySql())) {
            // empty if block
        }
        return v;
    }

    protected void deleteByKey(Map<String, Object> row) throws ValidateException {
        String className = this.conf.getEntityClass().getSimpleName();
        String idName = this.persister.getIdName(this.conf.getEntityClass());
        DataField[] keyField = this.conf.getKeyField();
        String key = "_";
        Object[] value = new Object[keyField.length];
        StringBuilder sb = new StringBuilder("delete from ").append(className);
        sb.append(" where ").append(idName).append(" in (");
        sb.append(" select ").append(idName);
        sb.append(" from ").append(className).append(" where 1=1");
        for (int j = 0; j < keyField.length; ++j) {
            value[j] = this.getValue(keyField[j], null, row);
            key = key + value[j] + "_";
            sb.append(" and ").append(keyField[j].getCode()).append("=?");
        }
        sb.append(")");
        if (!this.deleted.containsKey(key)) {
            this.persister.createQuery(sb.toString(), value).executeUpdate();
            this.deleted.put(key, "");
        }
    }

    protected String eval(Object[] objects, String exp) {
        if (StringUtils.isBlank((String)exp)) {
            return "";
        }
        Matcher matcher = PATTERN.matcher(exp);
        while (matcher.find()) {
            String name = matcher.group();
            Object result = null;
            for (Object obj : objects) {
                try {
                    result = PropertyUtils.getProperty((Object)obj, (String)name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (result != null) break;
            }
            exp = StringUtils.replace((String)exp, (String)("${" + name + "}"), (String)(result == null ? "" : result.toString()));
        }
        return exp == null ? "" : exp;
    }

    protected void addMessage(String message, String onError) {
        this.messages.append(message).append("<br/>");
        if ("skipRow".equals(onError)) {
            ++this.skipRowNum;
        } else if ("skipCol".equals(onError)) {
            ++this.skipColNum;
        } else if ("setNull".equals(onError)) {
            ++this.setNullNum;
        }
    }

    protected void addMessage(String message, String onError, Map<String, Object> row, DataField field) {
        message = message + " (" + "\u884c" + ":" + this.iterator.getRowNumber() + ", " + "\u5217" + ":" + field.getName() + ", " + "\u503c" + ":" + (String)row.get(field.getName()) + ")";
        this.addMessage(message, onError);
    }

    protected void addError(String error) throws ValidateException {
        this.errors.append(error).append("<br/>");
        ++this.errNum;
        if (this.errNum > 200) {
            throw new ValidateException(this.errors.toString());
        }
    }

    protected void addError(String error, Map<String, Object> row, DataField field) throws ValidateException {
        error = error + " (" + "\u884c" + ":" + this.iterator.getRowNumber() + ", " + "\u5217" + ":" + field.getName() + ", " + "\u503c" + ":" + (String)row.get(field.getName()) + ")";
        this.addError(error);
    }

    public void template(HttpServletResponse response) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        HSSFRow row = sheet.createRow(this.conf.getStartRow() - 2);
        HSSFFont font = wb.createFont();
        int[] rgb = new int[]{127, 127, 127};
        HSSFPalette palette = wb.getCustomPalette();
        palette.setColorAtIndex((short)8, (byte)rgb[0], (byte)rgb[1], (byte)rgb[2]);
        this.setFont(font, (short)8);
        HSSFCellStyle headerStyle = wb.createCellStyle();
        this.setCellStyle(font, headerStyle);
        HSSFFont reqFont = wb.createFont();
        this.setFont(reqFont, (short)10);
        HSSFCellStyle reqHeaderStyle = wb.createCellStyle();
        this.setCellStyle(reqFont, reqHeaderStyle);
        HSSFFont blueFont = wb.createFont();
        this.setFont(blueFont, (short)12);
        HSSFCellStyle blueHeaderStyle = wb.createCellStyle();
        this.setCellStyle(blueFont, blueHeaderStyle);
        List fields = this.conf.getFields();
        for (int i = 0; i < fields.size(); i = (int)((short)(i + 1))) {
            DataField field = (DataField)fields.get(i);
            if (!StringUtils.isNotBlank((String)field.getName())) continue;
            HSSFCell cell = row.createCell(Integer.parseInt(field.getName()) - 1);
            if (field.isRequired()) {
                cell.setCellStyle(reqHeaderStyle);
            } else if (StringUtils.isNotBlank((String)field.getCode())) {
                cell.setCellStyle(blueHeaderStyle);
            } else {
                cell.setCellStyle(headerStyle);
            }
            if (field.getList() != null && field.getList().length > 0) {
                DataValidationHelper helper = sheet.getDataValidationHelper();
                CellRangeAddressList regions = new CellRangeAddressList(1, 1, i, i);
                DVConstraint constraint = DVConstraint.createExplicitListConstraint((String[])field.getList());
                DataValidation data_validation = helper.createValidation((DataValidationConstraint)constraint, (org.apache.poi.ss.util.CellRangeAddressList)regions);
                sheet.addValidationData(data_validation);
            }
            String columnName = field.getTitle();
            cell.setCellValue(columnName);
            sheet.setColumnWidth(Short.parseShort(field.getName()) - 1, columnName.getBytes().length * 280);
        }
        String fileName = this.conf.getTemplateName();
        if (StringUtils.isBlank((String)fileName)) {
            fileName = "template.xls";
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(), "ISO-8859-1") + ".xls");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setDateHeader("Expires", System.currentTimeMillis() + 1000L);
        wb.write((OutputStream)response.getOutputStream());
    }

    private void setFont(HSSFFont reqFont, short color) {
        reqFont.setBoldweight((short)400);
        reqFont.setColor(color);
        reqFont.setFontName("Arial");
        reqFont.setFontHeightInPoints((short)8);
    }

    private void setCellStyle(HSSFFont reqFont, HSSFCellStyle reqHeaderStyle) {
        reqHeaderStyle.setFont(reqFont);
        reqHeaderStyle.setFillForegroundColor((short)22);
        reqHeaderStyle.setFillPattern((short)1);
        reqHeaderStyle.setBorderBottom((short)1);
        reqHeaderStyle.setBottomBorderColor((short)8);
        reqHeaderStyle.setBorderLeft((short)1);
        reqHeaderStyle.setLeftBorderColor((short)8);
        reqHeaderStyle.setBorderRight((short)1);
        reqHeaderStyle.setRightBorderColor((short)8);
        reqHeaderStyle.setBorderTop((short)1);
        reqHeaderStyle.setTopBorderColor((short)8);
        reqHeaderStyle.setAlignment((short)2);
        reqHeaderStyle.setVerticalAlignment((short)1);
    }

    public ImpInfo getImpInfo() {
        return this.impInfo;
    }

    public void setImpInfo(ImpInfo impInfo) {
        this.impInfo = impInfo;
    }

    public String getBatchCode() {
        return this.batchCode;
    }
}

