/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer.validator;

import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.importer.validator.DataValidator;
import com.biz.eisp.base.importer.validator.ValidateException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

abstract class AbstractValidator
implements DataValidator {
    protected String name;
    protected int length;
    protected boolean required;
    protected Pattern mask;
    protected String value;
    protected Object result;
    protected boolean valueIsBlank;

    public AbstractValidator(DataField field) {
        this.name = field.getTitle();
        this.length = field.getLength();
        this.required = field.isRequired();
        if (StringUtils.isNotBlank((String)field.getMask())) {
            this.mask = Pattern.compile(field.getMask());
        }
    }

    protected boolean validateRequired() {
        return !this.required || !this.valueIsBlank;
    }

    protected boolean validateLength() {
        return this.valueIsBlank || this.value.length() <= this.length;
    }

    protected boolean validateMask() {
        return this.valueIsBlank || this.mask == null || this.mask.matcher(this.value).matches();
    }

    public Object validate(String value) throws ValidateException {
        this.result = null;
        this.value = value;
        this.valueIsBlank = StringUtils.isBlank((String)value);
        if (!this.validateRequired()) {
            throw new ValidateException("\u6570\u636e\u9a8c\u8bc1\u9519\u8bef : " + this.name + " \u5fc5\u586b");
        }
        if (!this.validateLength()) {
            throw new ValidateException("\u6570\u636e\u9a8c\u8bc1\u9519\u8bef : " + this.name + " \u6700\u5927\u957f\u5ea6\u662f " + this.length);
        }
        if (!this.validateMask()) {
            throw new ValidateException("\u6570\u636e\u9a8c\u8bc1\u9519\u8bef : " + this.name + " \u683c\u5f0f\u9519\u8bef\uff08\u4e0d\u80fd\u901a\u8fc7\u6b63\u5219\u8868\u8fbe\u5f0f\uff09");
        }
        if (!this.validateFormat()) {
            throw new ValidateException("\u6570\u636e\u9a8c\u8bc1\u9519\u8bef : " + this.name + " \u975e\u6cd5\u683c\u5f0f");
        }
        return this.result == null ? value : this.result;
    }

    protected abstract boolean validateFormat();
}

