/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.customer.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.customer.service.TmCustPostService;
import com.biz.eisp.mdm.customer.vo.TmCustPostVo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmCustPostController"})
public class TmCustPostController
extends BaseController {
    @Autowired
    private TmCustPostService tmCustPostService;

    @RequestMapping(params={"goTmCustPostMain"})
    public ModelAndView goTmCustPostMain(TmCustPostVo custPostVo, HttpServletRequest request) {
        String customerId = request.getParameter("customerId");
        String businessGroup = request.getParameter("businessGroup");
        String terminalId = request.getParameter("terminalId");
        request.setAttribute("terminalId", (Object)terminalId);
        request.setAttribute("customerId", (Object)customerId);
        request.setAttribute("businessGroup", (Object)businessGroup);
        return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerPosition");
    }

    @RequestMapping(params={"deleteCustPost"})
    @ResponseBody
    public JSONObject deleteCustPost(TmCustPostVo custPostVo, HttpServletRequest request, HttpServletResponse response) {
        this.tmCustPostService.deleteTmCustPost(custPostVo);
        return this.returnJson();
    }

    @RequestMapping(params={"businessGroupCombox"})
    public void businessGroupCombox(HttpServletRequest request, HttpServletResponse response) {
        List dictDataList = this.tmCustPostService.comboBoxByDict("business_group");
        this.sendResponseObj(response, (Object)dictDataList);
    }

    @RequestMapping(params={"findTmCustPostList"})
    @ResponseBody
    public DataGrid findTmCustPostList(TmCustPostVo customerVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List custPostList = this.tmCustPostService.findPostList(customerVo, (Page)page);
        return new DataGrid(custPostList, (Page)page);
    }

    @RequestMapping(params={"goCustomerBindPosMain"})
    public ModelAndView goCustomerBindPosMain(HttpServletRequest request, TmCustPostVo tmCustPostVo) throws UnsupportedEncodingException {
        request.setAttribute("positionId", (Object)URLEncoder.encode(tmCustPostVo.getPositionId(), "utf-8"));
        request.setAttribute("businessGroup", (Object)tmCustPostVo.getBusinessGroup());
        request.setAttribute("custUser", (Object)tmCustPostVo.getCustUser());
        return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerBindPosMain");
    }

    @RequestMapping(params={"goCustomerByPosMain"})
    public ModelAndView goCustomerByPosMain(HttpServletRequest request, TmCustPostVo tmCustPostVo) throws UnsupportedEncodingException {
        request.setAttribute("positionId", (Object)URLEncoder.encode(tmCustPostVo.getPositionId(), "utf-8"));
        return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerByPosMain");
    }

    @RequestMapping(params={"goCustomerBinUserMain"})
    public ModelAndView goCustomerBinUserMain(HttpServletRequest request, TmCustPostVo tmCustPostVo) {
        request.setAttribute("businessGroup", (Object)tmCustPostVo.getBusinessGroup());
        request.setAttribute("custUser", (Object)tmCustPostVo.getCustUser());
        return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerUser");
    }

    @RequestMapping(params={"findNotAnyPostCustomerList"})
    @ResponseBody
    public DataGrid findNotAnyPostCustomerList(TmCustPostVo tmCustPostVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List terminalList = this.tmCustPostService.findNotAnyPostCustomerList(tmCustPostVo, (Page)page);
        return new DataGrid(terminalList, (Page)page);
    }

    @RequestMapping(params={"findNotCurrPostCustomerList"})
    @ResponseBody
    public DataGrid findNotCurrPostCustomerList(TmCustPostVo tmCustPostVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List terminalList = this.tmCustPostService.findNotCurrPostCustomerList(tmCustPostVo, (Page)page);
        return new DataGrid(terminalList, (Page)page);
    }

    @RequestMapping(params={"addRelotaionForPositionId"})
    @ResponseBody
    public AjaxJson addRelotaionForPositionId(String customerIds, String positionId, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.tmCustPostService.addRelotaionForPositionId(customerIds, positionId);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg(e.getMessage());
        }
        return ajaxJson;
    }

    @RequestMapping(params={"updatePostTerminalRelation"})
    @ResponseBody
    public AjaxJson updatePostCustomerRelation(String relationIds, String positionId, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.tmCustPostService.updatePostCustomerRelation(relationIds, positionId);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg(e.getMessage());
        }
        return ajaxJson;
    }

    @RequestMapping(params={"deleteRelotaion"})
    @ResponseBody
    public AjaxJson deleteRelotaion(String ids, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.tmCustPostService.deleteRelotaionForCustomerId(ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg(e.getMessage());
        }
        return ajaxJson;
    }
}

