/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.function.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.bean.TreeGridModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.service.TmFunAuthService;
import com.biz.eisp.mdm.authobj.transform.TmFuncAuthTransForm;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.function.dao.TmFuncionDao;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.function.transformer.TmFunctionVoToTmFunctionEntity;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity;
import com.biz.eisp.mdm.role.service.TmRoleService;
import com.biz.eisp.mdm.role.vo.TmRoleVo;
import com.biz.eisp.mdm.user.vo.MenuVo;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmFunctionService")
@Transactional
public class TmFunctionServiceImpl
extends BaseServiceImpl
implements TmFunctionService {
    @Autowired
    private TmFunAuthService tmFunAuthService;
    @Autowired
    private TmFuncionDao tmFuncionDao;
    @Autowired
    private TmRoleService tmRoleService;

    public List<TreeGrid> getFunctionsList(HttpServletRequest request, TreeGrid treeGrid) {
        String selfId = request.getParameter("selfId");
        List functionList = new ArrayList();
        if (StringUtil.isNotEmpty((String)selfId)) {
            functionList = this.findByPropertyisOrder(TmFunctionEntity.class, "id", (Object)selfId, true, "functionOrder");
        }
        if (StringUtil.isNotEmpty((String)treeGrid.getId())) {
            functionList = this.findByPropertyisOrder(TmFunctionEntity.class, "tmFunction.id", (Object)treeGrid.getId(), true, "functionOrder");
        } else {
            Criterion cr = Restrictions.isNull((String)"tmFunction.id");
            functionList = this.findByCriteria(TmFunctionEntity.class, true, "functionOrder", new Criterion[]{cr});
        }
        return this.treeGridModel(functionList);
    }

    private List<TreeGrid> treeGridModel(List<TmFunctionEntity> functionList) {
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("functionName");
        treeGridModel.setParentText("tmFunction_functionName");
        treeGridModel.setParentId("tmFunction_id");
        treeGridModel.setSrc("functionUrl");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("tmFunctionList");
        treeGridModel.setIcon("tmIcon_iconPath");
        treeGridModel.setOrder("functionOrder");
        treeGrids = this.treegrid(functionList, treeGridModel);
        return treeGrids;
    }

    public List<ComboTree> getFunctionForComboTree(HttpServletRequest request, ComboTree comboTree) {
        List functionList = new ArrayList();
        if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            functionList = this.findByProperty(TmFunctionEntity.class, "tmFunction.id", (Object)comboTree.getId());
        } else {
            Criterion cr = Restrictions.isNull((String)"tmFunction.id");
            functionList = this.findByCriteria(TmFunctionEntity.class, true, "functionOrder", new Criterion[]{cr});
        }
        ArrayList<ComboTree> comboTrees = new ArrayList();
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "functionName", "tmFunctionList");
        comboTrees = this.comboTree(functionList, comboTreeModel, null, false);
        return comboTrees;
    }

    public void deleteFunction(String functionId) throws Exception {
        try {
            TmFunctionEntity function = (TmFunctionEntity)this.get(TmFunctionEntity.class, (Serializable)((Object)functionId));
            List funAuthList = this.findByProperty(TmFunAuthEntity.class, "tmFunction.id", (Object)functionId);
            this.deleteAllEntity((Collection)funAuthList);
            List roleFunList = this.findByProperty(TmRoleFunctionEntity.class, "tmFunction.id", (Object)functionId);
            this.deleteAllEntity((Collection)roleFunList);
            this.delete((Object)function);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void saveFunction(TmFunctionVo tmFunctionVo) {
        TmFunctionEntity tmFunction = new TmFunctionVoToTmFunctionEntity((TmFunctionService)this).apply(tmFunctionVo);
        if (StringUtil.isNotEmpty((String)tmFunctionVo.getIconId())) {
            TmIconEntity iconEntity = (TmIconEntity)this.get(TmIconEntity.class, (Serializable)((Object)tmFunctionVo.getIconId()));
            tmFunction.setTmIcon(iconEntity);
        }
        this.saveOrUpdate((Object)tmFunction);
    }

    public List<ComboTree> getAllFuncAndHandleCheck(HttpServletRequest request, ComboTree comboTree, String roleId) {
        List functionList = new ArrayList();
        ArrayList<TmFunctionEntity> inFunctionList = new ArrayList<TmFunctionEntity>();
        if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            functionList = this.findByProperty(TmFunctionEntity.class, "tmFunction.id", (Object)comboTree.getId());
        } else {
            Criterion cr = Restrictions.isNull((String)"tmFunction.id");
            functionList = this.findByCriteria(TmFunctionEntity.class, new Criterion[]{cr});
        }
        List list = super.findByProperty(TmRoleFunctionEntity.class, "tmRole.id", (Object)roleId);
        if (list != null && list.size() > 0) {
            for (TmRoleFunctionEntity tmRoleFunctionEntity : list) {
                inFunctionList.add(tmRoleFunctionEntity.getTmFunction());
            }
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "functionName", "tmFunctionList");
        List comboTrees = super.comboTree(functionList, comboTreeModel, inFunctionList, true);
        return comboTrees;
    }

    public List<TmOperationEntity> getOptByRoleFunc(String roleId, String funcId) {
        SimpleExpression roleCrt;
        List allOptByFuncs = this.findByProperty(TmOperationEntity.class, "tmFunction.id", (Object)funcId);
        SimpleExpression funcCrt = Restrictions.eq((String)"tmFunction.id", (Object)funcId);
        List tmRoleFunctions = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{funcCrt, roleCrt = Restrictions.eq((String)"tmRole.id", (Object)roleId)});
        if (tmRoleFunctions != null && tmRoleFunctions.size() > 0) {
            String operations = ((TmRoleFunctionEntity)tmRoleFunctions.get(0)).getOperation();
            if (allOptByFuncs.size() > 0) {
                for (TmOperationEntity tmOperationEntity : allOptByFuncs) {
                    if (StringUtil.isNotEmpty((String)operations) && operations.contains(tmOperationEntity.getId())) {
                        tmOperationEntity.setStatus(String.valueOf(Globals.User_Normal));
                        continue;
                    }
                    tmOperationEntity.setStatus(String.valueOf(Globals.User_Forbidden));
                }
            }
        }
        return allOptByFuncs;
    }

    public void delExistFuncRole(String roleId, String funcIds) {
        List functions = null;
        SimpleExpression cr1 = Restrictions.eq((String)"tmRole.id", (Object)roleId);
        if (StringUtils.isNotBlank((CharSequence)funcIds)) {
            Criterion cr2 = Restrictions.not((Criterion)Restrictions.in((String)"tmFunction.id", (Object[])funcIds.split(",")));
            functions = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{cr1, cr2});
        } else {
            functions = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{cr1});
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)functions)) {
            this.deleteAllEntity((Collection)functions);
        }
    }

    public void setFuncRole(String roleId, String funcIds) {
        String alredyExistsFuncId = "";
        List functions = null;
        SimpleExpression cr1 = Restrictions.eq((String)"tmRole.id", (Object)roleId);
        if (StringUtils.isNotBlank((CharSequence)funcIds)) {
            Criterion cr2 = Restrictions.in((String)"tmFunction.id", (Object[])funcIds.split(","));
            functions = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{cr1, cr2});
        } else {
            functions = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{cr1});
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)functions)) {
            for (TmRoleFunctionEntity tmRoleFunctionEntity : functions) {
                if (StringUtil.isNotEmpty((String)alredyExistsFuncId)) {
                    alredyExistsFuncId = alredyExistsFuncId + ",";
                }
                alredyExistsFuncId = alredyExistsFuncId + tmRoleFunctionEntity.getTmFunction().getId();
            }
        }
        if (StringUtil.isNotEmpty((String)funcIds)) {
            String[] alredyExistsFuncIds = alredyExistsFuncId.split(",");
            HashSet<String> set = new HashSet<String>(Arrays.asList(alredyExistsFuncIds));
            for (String funcId : funcIds.split(",")) {
                if (set.contains(funcId)) continue;
                TmRoleFunctionEntity roleFunctionEntity = new TmRoleFunctionEntity();
                TmFunctionEntity tmFunction = new TmFunctionEntity();
                tmFunction.setId(funcId);
                roleFunctionEntity.setTmFunction(tmFunction);
                TmRoleEntity roleEntity = new TmRoleEntity();
                roleEntity.setId(roleId);
                roleFunctionEntity.setTmRole(roleEntity);
                this.save((Object)roleFunctionEntity);
            }
        }
    }

    public void setOperateByFuncRole(String opretionIds, String roleId, String funcId) {
        SimpleExpression funcCrt;
        SimpleExpression roleCrt = Restrictions.eq((String)"tmRole.id", (Object)roleId);
        List roleFuncs = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{roleCrt, funcCrt = Restrictions.eq((String)"tmFunction.id", (Object)funcId)});
        if (roleFuncs.size() == 0) {
            TmRoleFunctionEntity tmRoleFunctionEntity = new TmRoleFunctionEntity();
            TmFunctionEntity tmFunctionEntity = new TmFunctionEntity();
            tmFunctionEntity.setId(funcId);
            tmRoleFunctionEntity.setTmFunction(tmFunctionEntity);
            TmRoleEntity tmRoleEntity = new TmRoleEntity();
            tmRoleEntity.setId(roleId);
            tmRoleFunctionEntity.setTmRole(tmRoleEntity);
            tmRoleFunctionEntity.setOperation(opretionIds);
            this.save((Object)tmRoleFunctionEntity);
        } else if (StringUtil.isNotEmpty((Object)roleFuncs) && roleFuncs.size() > 0) {
            TmRoleFunctionEntity roleFunctionEntity = (TmRoleFunctionEntity)roleFuncs.get(0);
            roleFunctionEntity.setOperation(opretionIds);
            this.updateEntity((Object)roleFunctionEntity);
        }
    }

    public List<TmFunctionAuthVo> getAuthObjByFunc(String roleId, String funcId) {
        List allAuthByFunc = this.tmFunAuthService.getTmFunAuthList(funcId);
        List partAuthByFunc = this.tmFunAuthService.getTmFunAuthListByRoleFunc(roleId, funcId);
        List allAuthByFuncVos = Lists.transform((List)allAuthByFunc, (Function)new TmFuncAuthTransForm(partAuthByFunc));
        return allAuthByFuncVos;
    }

    public List<MenuVo> findMobileTerminalMenuList(int functionType, String username) {
        ArrayList<MenuVo> result = new ArrayList<MenuVo>();
        if (StringUtil.isNotEmpty((String)username)) {
            List tmRoleByUsername = this.tmRoleService.findTmRoleByUsername(username);
            StringBuilder sb = new StringBuilder();
            for (TmRoleVo item : tmRoleByUsername) {
                sb.append("'").append(item.getId()).append("'").append(",");
            }
            String roleIds = "''";
            if (sb.length() > 0) {
                roleIds = sb.substring(0, sb.length() - 1);
            }
            List menuByTypeAndRoleIds = this.tmFuncionDao.findMenuByTypeAndRoleIds(Integer.valueOf(functionType), roleIds);
            for (TmFunctionEntity item : menuByTypeAndRoleIds) {
                MenuVo menu = new MenuVo();
                menu.setName(item.getFunctionName());
                menu.setLink(item.getFunctionUrl());
                result.add(menu);
            }
        }
        return result;
    }

    public void updateFuntionLevel() {
        String sql = "MERGE INTO TM_FUNCTION T1 USING ( SELECT  T.ID, LEVEL-1 AS LV FROM TM_FUNCTION T WHERE 1=1 AND T.FUNCTION_LEVEL<>LEVEL-1 START WITH T.PARENT_ID IS NULL CONNECT BY PRIOR T.ID = T.PARENT_ID) T2 ON (T1.ID=T2.ID) WHEN MATCHED THEN UPDATE SET T1.FUNCTION_LEVEL = T2.LV";
        this.executeSql(sql, new Object[0]);
    }

    public String getTmFunctionName(String clickFunctionId) {
        if (StringUtil.isEmpty((String)clickFunctionId)) {
            return null;
        }
        TmFunctionEntity entity = (TmFunctionEntity)this.get(TmFunctionEntity.class, (Serializable)((Object)clickFunctionId));
        if (entity != null) {
            return entity.getFunctionName();
        }
        return null;
    }
}

