/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.operation.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
import com.biz.eisp.mdm.operation.service.OperationService;
import com.biz.eisp.mdm.operation.transformer.TmOperationEntityToTmOperationVo;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/operationController"})
public class OperationController
extends BaseController {
    @Autowired
    private OperationService operationService;

    @RequestMapping(params={"operationList"})
    public ModelAndView operationList(HttpServletRequest request, String functionId) {
        request.setAttribute("functionId", (Object)functionId);
        return new ModelAndView("com/biz/eisp/mdm/operation/operationList");
    }

    @RequestMapping(params={"operation"})
    public ModelAndView operation(HttpServletRequest request, String functionId, TmOperationEntity operation) {
        if (StringUtil.isNotEmpty((String)operation.getId())) {
            operation = (TmOperationEntity)this.operationService.get(TmOperationEntity.class, (Serializable)((Object)operation.getId()));
        }
        request.setAttribute("operation", (Object)operation);
        List iconlist = this.operationService.findByProperty(TmIconEntity.class, "iconType", (Object)20);
        request.setAttribute("iconlist", (Object)iconlist);
        request.setAttribute("functionId", (Object)functionId);
        return new ModelAndView("com/biz/eisp/mdm/operation/operation");
    }

    @RequestMapping(params={"operationGrid"})
    public void operationGrid(String functionId, HttpServletRequest request, HttpServletResponse response) {
        List result = this.operationService.getOperationList(functionId);
        List voList = Lists.transform((List)result, (Function)new TmOperationEntityToTmOperationVo());
        super.datagridReturn(response, voList);
    }

    @RequestMapping(params={"saveOperation"})
    @ResponseBody
    public AjaxJson saveFunction(TmOperationEntity operation) {
        AjaxJson json = new AjaxJson();
        String msg = this.operationService.saveOperation(operation);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            json.setErrorMsg(msg);
        }
        return json;
    }

    @RequestMapping(params={"deleteOperation"})
    @ResponseBody
    public JSONObject deleteOperation(HttpServletRequest request, HttpServletResponse response, String id) {
        try {
            TmOperationEntity operation = (TmOperationEntity)this.operationService.get(TmOperationEntity.class, (Serializable)((Object)id));
            this.operationService.delete((Object)operation);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01";
        }
        return this.returnJson();
    }
}

