/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.terminal.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.terminal.dao.TmTermCustPostDao;
import com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGEntity;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.service.TmTermCustPostService;
import com.biz.eisp.mdm.terminal.vo.TmTermCustPostVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmTermCustPostService")
@Transactional
public class TmTermCustPostServiceImpl
extends BaseServiceImpl
implements TmTermCustPostService {
    @Autowired
    private TmTermCustPostDao tmTermCustPostDao;

    public List<TmTermCustPostVo> findTmTermCustPostList(TmTermCustPostVo tmTermCustPostVo, Page page) {
        if (page == null) {
            return this.tmTermCustPostDao.findTermCustPostList(tmTermCustPostVo);
        }
        return this.tmTermCustPostDao.findTermListByCustomerId(tmTermCustPostVo, page);
    }

    public void deleteTmTermCustPost(TmTermCustPostVo tmTermCustPostVo) {
        if (StringUtil.isEmpty((String)tmTermCustPostVo.getId())) {
            throw new BusinessException("\u5220\u9664\u7ec8\u7aef\u4e0e\u7ecf\u9500\u5546\u5c97\u4f4d\u5bf9\u5e94\u5173\u7cfb\u65f6\uff0c\u4e3b\u952eID\u627e\u4e0d\u5230:" + tmTermCustPostVo.getId());
        }
        TmRTermCustPosBGEntity tmTermCustPostEntity = (TmRTermCustPosBGEntity)this.get(TmRTermCustPosBGEntity.class, (Serializable)((Object)tmTermCustPostVo.getId()));
        this.delete((Object)tmTermCustPostEntity);
    }

    public List<TmTerminalVo> findNotAnyCustTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page) {
        return this.tmTermCustPostDao.findNotAnyCustTerminalList(tmTermCustPostVo, page);
    }

    public List<TmTerminalVo> findNotCurrCustTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page) {
        return this.tmTermCustPostDao.findNotCurrCustTerminalList(tmTermCustPostVo, page);
    }

    public void addRelotaionForCustomerId(String terminalIds, String customerId) {
        if (StringUtil.isEmpty((String)terminalIds) && StringUtil.isEmpty((String)customerId)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String[] ids = terminalIds.split(",");
        TmCustomerEntity tmCustomerEntity = (TmCustomerEntity)this.get(TmCustomerEntity.class, (Serializable)((Object)customerId));
        TmTerminalEntity tmTerminalEntity = null;
        String hql = "from TmRTermCustPosBGEntity where tmTerminal.id=? and tmCustomer.id=?";
        for (String terminalId : ids) {
            tmTerminalEntity = (TmTerminalEntity)this.get(TmTerminalEntity.class, (Serializable)((Object)terminalId));
            List tmRTermCustPosBGEntities = this.findByHql(hql, new Object[]{terminalId, customerId});
            if (CollectionUtil.listNotEmptyNotSizeZero((List)tmRTermCustPosBGEntities)) continue;
            TmRTermCustPosBGEntity tmRTermCustPosBGEntity = new TmRTermCustPosBGEntity();
            tmRTermCustPosBGEntity.setTmCustomer(tmCustomerEntity);
            tmRTermCustPosBGEntity.setTmTerminal(tmTerminalEntity);
            this.save((Object)tmRTermCustPosBGEntity);
            String content = "\u4e0a\u7ea7\u5ba2\u6237\u6279\u91cf\u8c03\u6574,\u5173\u8054\u4e0a\u7ea7\u5ba2\u6237:<b>" + tmCustomerEntity.getCustomerName() + "</b>";
            this.addLog(OperationType.INSERT, "\u7ec8\u7aef\u4e0e\u5ba2\u6237\u5bf9\u5e94\u5173\u7cfb", terminalId, content);
        }
    }

    public void deleteRelotaionForCustomerId(String ids, Integer flag) {
        String[] idArray;
        if (StringUtil.isEmpty((String)ids)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        for (String id : idArray = ids.split(",")) {
            TmRTermCustPosBGEntity tmRTermCustPosBGEntity = (TmRTermCustPosBGEntity)this.get(TmRTermCustPosBGEntity.class, (Serializable)((Object)id));
            String content = "";
            if (flag != null && flag == 1) {
                content = "\u7ec8\u7aef\u4e0a\u7ea7\u5ba2\u6237\u6279\u91cf\u8c03\u6574,\u53d6\u6d88\u5173\u8054\u4e0a\u7ea7\u5ba2\u6237:<b>" + tmRTermCustPosBGEntity.getTmCustomer().getCustomerName() + "</b>";
                if (tmRTermCustPosBGEntity.getTmPosition() == null) {
                    this.delete((Object)tmRTermCustPosBGEntity);
                } else {
                    tmRTermCustPosBGEntity.setTmCustomer(null);
                    this.updateEntity((Object)tmRTermCustPosBGEntity);
                }
            } else {
                content = "\u7ec8\u7aef\u5bf9\u63a5\u4eba\u804c\u4f4d\u6279\u91cf\u8c03\u6574,\u53d6\u6d88\u5173\u8054\u5bf9\u63a5\u4eba\u804c\u4f4d:<b>" + tmRTermCustPosBGEntity.getTmPosition().getPositionName() + "</b>";
                if (tmRTermCustPosBGEntity.getTmCustomer() == null) {
                    this.delete((Object)tmRTermCustPosBGEntity);
                } else {
                    tmRTermCustPosBGEntity.setTmPosition(null);
                    this.updateEntity((Object)tmRTermCustPosBGEntity);
                }
            }
            this.addLog(OperationType.DELETE, "\u7ec8\u7aef\u4e0e\u5ba2\u6237\u5bf9\u5e94\u5173\u7cfb", tmRTermCustPosBGEntity.getTmTerminal().getId(), content);
        }
    }

    public void deleteTmRCustTermPost(String ids) {
        String[] idArray;
        if (StringUtil.isEmpty((String)ids) && StringUtil.isEmpty((String)ids)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        for (String id : idArray = ids.split(",")) {
            TmRTermCustPosBGEntity tmRTermCustPosBGEntity = (TmRTermCustPosBGEntity)this.get(TmRTermCustPosBGEntity.class, (Serializable)((Object)id));
            this.delete((Object)tmRTermCustPosBGEntity);
        }
    }

    public void updateCustTerminalRelation(String relationIds, String customerId) {
        if (StringUtil.isEmpty((String)relationIds) && StringUtil.isEmpty((String)customerId)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String[] ids = relationIds.split(",");
        String hql = "from TmRTermCustPosBGEntity where tmTerminal.id=? and tmCustomer.id=?";
        TmCustomerEntity tmCustomerEntity = (TmCustomerEntity)this.get(TmCustomerEntity.class, (Serializable)((Object)customerId));
        TmRTermCustPosBGEntity tmRTermCustPosBGEntity = null;
        for (String id : ids) {
            tmRTermCustPosBGEntity = (TmRTermCustPosBGEntity)this.get(TmRTermCustPosBGEntity.class, (Serializable)((Object)id));
            List tmRTermCustPosBGEntities = this.findByHql(hql, new Object[]{tmRTermCustPosBGEntity.getTmTerminal().getId(), customerId});
            if (CollectionUtil.listNotEmptyNotSizeZero((List)tmRTermCustPosBGEntities)) continue;
            String content = "\u4e0a\u7ea7\u5ba2\u6237\u6279\u91cf\u8c03\u6574,\u5173\u8054\u4e0a\u7ea7\u5ba2\u6237:<b>" + tmCustomerEntity.getCustomerName() + "</b>";
            if (tmRTermCustPosBGEntity.getTmCustomer() != null) {
                content = "\u4e0a\u7ea7\u5ba2\u6237\u66ff\u6362,\u539f\u4e0a\u7ea7\u5ba2\u6237:<b>" + tmRTermCustPosBGEntity.getTmCustomer().getCustomerName() + "</b>\u66ff\u6362\u4e3a<b>" + tmCustomerEntity.getCustomerName() + "<b>";
            }
            this.addLog(OperationType.UPDATE, "\u7ec8\u7aef\u4e0e\u5ba2\u6237\u5bf9\u5e94\u5173\u7cfb", tmRTermCustPosBGEntity.getTmTerminal().getId(), content);
            tmRTermCustPosBGEntity.setTmCustomer(tmCustomerEntity);
            this.updateEntity((Object)tmRTermCustPosBGEntity);
        }
    }

    public List<TmCustomerVo> findCustomerBySelect(TmTermCustPostVo tmTermCustPostVo, String selectedCustIds, Page page) {
        if (StringUtils.isNotBlank((CharSequence)selectedCustIds)) {
            selectedCustIds = selectedCustIds.replaceAll(",", "','");
        }
        return this.tmTermCustPostDao.findCustomerBySelect(tmTermCustPostVo, selectedCustIds, page);
    }

    public List<TmCustomerVo> findSelectedUserTmCustomers(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Lists.newArrayList();
        }
        return this.tmTermCustPostDao.findSelectedUserTmCustomers(userId);
    }

    public List<TmTerminalVo> findNotAnyPostTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page) {
        return this.tmTermCustPostDao.findNotAnyPostTerminalList(tmTermCustPostVo, page);
    }

    public List<TmTerminalVo> findNotCurrPostTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page) {
        return this.tmTermCustPostDao.findNotCurrPostTerminalList(tmTermCustPostVo, page);
    }

    public List<TmPositionVo> findPostionBySelect(TmTermCustPostVo tmTermCustPostVo, Page page) {
        return this.tmTermCustPostDao.findPositionBySelect(tmTermCustPostVo, page);
    }

    public void addRelotaionForPositionId(String terminalIds, String positionId) {
        if (StringUtil.isEmpty((String)terminalIds) && StringUtil.isEmpty((String)positionId)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String[] ids = terminalIds.split(",");
        TmPositionEntity tmPositionEntity = (TmPositionEntity)this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
        TmTerminalEntity tmTerminalEntity = null;
        String hql = "from TmRTermCustPosBGEntity where tmTerminal.id=? and tmPosition.id=?";
        for (String terminalId : ids) {
            tmTerminalEntity = (TmTerminalEntity)this.get(TmTerminalEntity.class, (Serializable)((Object)terminalId));
            List tmRTermCustPosBGEntities = this.findByHql(hql, new Object[]{terminalId, positionId});
            if (CollectionUtil.listNotEmptyNotSizeZero((List)tmRTermCustPosBGEntities)) continue;
            TmRTermCustPosBGEntity tmRTermCustPosBGEntity = new TmRTermCustPosBGEntity();
            tmRTermCustPosBGEntity.setTmPosition(tmPositionEntity);
            tmRTermCustPosBGEntity.setBusinessGroup(tmPositionEntity.getBusinessGroup());
            tmRTermCustPosBGEntity.setTmTerminal(tmTerminalEntity);
            this.save((Object)tmRTermCustPosBGEntity);
            String content = "\u7ec8\u7aef\u5bf9\u63a5\u4eba\u804c\u4f4d\u6279\u91cf\u8c03\u6574,\u5173\u8054\u5bf9\u63a5\u4eba\u804c\u4f4d:<b>" + tmPositionEntity.getPositionName() + "</b>";
            this.addLog(OperationType.INSERT, "\u7ec8\u7aef\u4e0e\u804c\u4f4d\u5bf9\u5e94\u5173\u7cfb", terminalId, content);
        }
    }

    public void updatePostTerminalRelation(String relationIds, String positionId) {
        if (StringUtil.isEmpty((String)relationIds) && StringUtil.isEmpty((String)positionId)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String[] ids = relationIds.split(",");
        TmPositionEntity tmPositionEntity = (TmPositionEntity)this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
        TmRTermCustPosBGEntity tmRTermCustPosBGEntity = null;
        String hql = "from TmRTermCustPosBGEntity where tmTerminal.id=? and tmPosition.id=?";
        for (String id : ids) {
            tmRTermCustPosBGEntity = (TmRTermCustPosBGEntity)this.get(TmRTermCustPosBGEntity.class, (Serializable)((Object)id));
            List tmRTermCustPosBGEntities = this.findByHql(hql, new Object[]{tmRTermCustPosBGEntity.getTmTerminal().getId(), positionId});
            if (CollectionUtil.listNotEmptyNotSizeZero((List)tmRTermCustPosBGEntities)) continue;
            String content = "\u7ec8\u7aef\u5bf9\u63a5\u4eba\u804c\u4f4d\u6279\u91cf\u8c03\u6574,\u5173\u8054\u5bf9\u63a5\u4eba\u804c\u4f4d:<b>" + tmPositionEntity.getPositionName() + "</b>";
            if (tmRTermCustPosBGEntity.getTmPosition() != null) {
                content = "\u7ec8\u7aef\u5bf9\u63a5\u4eba\u804c\u4f4d\u66ff\u6362,\u539f\u5bf9\u63a5\u4eba\u804c\u4f4d:<b>" + tmRTermCustPosBGEntity.getTmPosition().getPositionName() + "</b>\u66ff\u6362\u4e3a<b>" + tmPositionEntity.getPositionName() + "<b>";
            }
            this.addLog(OperationType.UPDATE, "\u7ec8\u7aef\u4e0e\u804c\u4f4d\u5bf9\u5e94\u5173\u7cfb", tmRTermCustPosBGEntity.getTmTerminal().getId(), content);
            tmRTermCustPosBGEntity.setTmPosition(tmPositionEntity);
            this.updateEntity((Object)tmRTermCustPosBGEntity);
        }
    }
}

