/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.user.transformer;

import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserPositionEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class TmUserEntityToTmUserVo
implements Function<TmUserEntity, TmUserVo> {
    private TmUserService tmUserService;

    public TmUserEntityToTmUserVo(TmUserService userService) {
        this.tmUserService = userService;
    }

    public TmUserVo apply(TmUserEntity entity) {
        TmUserVo vo = new TmUserVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        List positions = this.tmUserService.findByProperty(TmUserPositionEntity.class, "tmUser.id", (Object)entity.getId());
        if (!CollectionUtils.isEmpty((Collection)positions)) {
            StringBuffer posNames = new StringBuffer();
            StringBuffer posIds = new StringBuffer();
            StringBuffer isMains = new StringBuffer();
            for (TmUserPositionEntity tmUserPositionEntity : positions) {
                if (posIds.length() > 0) {
                    posIds.append(",");
                    posNames.append(",");
                    isMains.append(",");
                }
                posIds.append(tmUserPositionEntity.getTmPosition().getId());
                posNames.append(tmUserPositionEntity.getTmPosition().getPositionName());
                isMains.append(tmUserPositionEntity.getIsMain());
            }
            vo.setPositionName(posNames.toString());
            vo.setPositionId(posIds.toString());
            vo.setIsMain(isMains.toString());
        }
        return vo;
    }
}

