SELECT
    u.*,
    uc.custname,
    uc.custcode,
    uc.custid,
    ur.rolenames,
    ur.rolecodes,
    ur.roleids
FROM
    tm_user u
    LEFT JOIN (
        SELECT DISTINCT
            tuc.user_id,
            LISTAGG(tc.id) WITHIN GROUP(ORDER BY tc.id) AS custid,
            LISTAGG(tc.customer_name) WITHIN GROUP(ORDER BY tc.id) AS custname,
            LISTAGG(tc.customer_code) WITHIN GROUP(ORDER BY tc.id) AS CUSTCODE
        FROM
            tm_r_user_customer tuc
            JOIN tm_customer tc ON tc.id = tuc.customer_id
        GROUP BY
            tuc.user_id
    ) uc ON uc.user_id = u.id
    LEFT JOIN (
        SELECT DISTINCT
            tmr.user_id,
            LISTAGG(te.role_name) WITHIN GROUP(ORDER BY te.id) AS rolenames,
            LISTAGG(te.role_code) WITHIN GROUP(ORDER BY te.id) AS rolecodes,
            LISTAGG(te.id) WITHIN GROUP(ORDER BY te.id) AS roleids
        FROM
            tm_r_user_role tmr
            JOIN tm_role te ON te.id = tmr.role_id
        GROUP BY
            tmr.user_id
    ) ur ON ur.user_id = u.id
WHERE
    1 = 1
    AND u.user_type = 1
<#if tmUserVo.id ?exists&&tmUserVo.id ?length gt 0>
	AND U.ID = '${tmUserVo.id}'
</#if>
<#if tmUserVo.userName ?exists&&tmUserVo.userName ?length gt 0>
	AND U.USERNAME LIKE '%${tmUserVo.userName}%'
</#if>
<#if tmUserVo.fullName ?exists&&tmUserVo.fullName ?length gt 0>
	AND U.FULLNAME LIKE '%${tmUserVo.fullName}%'
</#if>
<#if tmUserVo.enableStatus ?exists&&tmUserVo.enableStatus ?length gt 0>
	AND U.ENABLE_STATUS = '${tmUserVo.enableStatus}'
</#if>
<#if tmUserVo.custName ?exists&&tmUserVo.custName ?length gt 0>
	AND UC.CUSTNAME LIKE '%${tmUserVo.custName}%'
</#if>
<#if tmUserVo.custCode ?exists&&tmUserVo.custCode ?length gt 0>
	AND UC.CUSTCODE LIKE '%${tmUserVo.custCode}%'
</#if>
<#if tmUserVo.custId ?exists&&tmUserVo.custId ?length gt 0>
	AND UC.CUSTID LIKE '%${tmUserVo.custId}%'
</#if>
ORDER BY U.CREATE_DATE DESC