<%@ page language="java" import="java.util.*" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>附件上传</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <link rel="stylesheet" href="/resources/webuploader/webuploader.css">
    <style>
        .biz-uploader {
            width: 100%;
            height: 100%;
        }

        .biz-uploader-run {
            width: 100%;
            height: 100%;
            position: relative;
            border: 1px solid #dddddd;
            padding: 10px;
            box-sizing: border-box;
        }

        .file-select {
            width: 100%;
            height: 100px;
            border: 2px dashed #898989;
            box-sizing: border-box;
        }

        .uploader-list {
            width: 100%;
            height: 0;
            background: #ffffff;
            margin-top: 20px;
            overflow-y: auto;
            box-sizing: border-box;
            padding: 0 5px;
            border-radius: 5px;
        }

        .uploader-list-item {
            line-height: 35px;
        }

        .upload-file-status.retry {
            color: #1890ff;
            cursor: pointer;
        }

        .upload-file-status.retry:hover {
            opacity: .8;
        }

        .upload-file-remove:hover {
            color: #1890ff;
            cursor: pointer;
        }

        .biz-progress-back {
            position: relative;
            width: 100%;
            overflow: hidden;
            vertical-align: middle;
            background-color: #f5f5f5;
            border-radius: 100px;
        }

        .biz-progress-bar {
            height: 8px;
            width: 0;
            background-color: #1890ff;
            border-radius: 100px;
            transition: all .3s cubic-bezier(0.075, 0.82, 0.165, 1);
        }

        .biz-progress-text {
            width: 50px;
            text-align: center;
        }

        .webuploader-pick {
            background: transparent;
        }

        .webuploader-pick > span {
            font-size: 35px;
            color: #696969;
        }

        .webuploader-pick > p {
            color: #696969;
        }

        .webuploader-pick:hover {
            background: transparent;
        }
    </style>
</head>
<body style="overflow-y: hidden" scroll="no">
<div class="biz-uploader">
    <div class="biz-uploader-run flex flex-column">
        <div class="file-select flex-none flex flex-align-items-center flex-justify-content-center">
            <div id="picker">
                <span class="fa fa-cloud-upload"></span>
                <p>点击上传，或将文件拖拽到此处</p>
            </div>
        </div>
        <div id="fileList" class="uploader-list flex-auto">

        </div>

    </div>
</div>

<script src="/resources/webuploader/webuploader.min.js"></script>

<script>
    var uploader = null;
    var responseArray = [];
    $(function () {
        //移除文件
        $("#fileList").on('click', '.upload-file-remove', function () {
            var itemId = $(this).parents(".uploader-list-item").attr("id");
            uploader.removeFile(itemId);
            $(this).parents(".uploader-list-item").remove();
        });
        //重新上传
        $("#fileList").on('click', '.upload-file-status.retry', function () {
            var itemId = $(this).parents(".uploader-list-item").attr("id");
            uploader.retry(itemId);
        });
    });


    /**
     * 初始化上传
     * @param data
     * data.uploadUrl 上传地址
     * data.muilt 是否多个上传
     * @param callback
     */

    function initWebUploader(data, callback,option) {
        var uuid = Math.random();
        data = $.extend({}, data, {excelUuid: uuid});
        option = option||{};
        let defaultOptions = {
            // swf文件路径
            swf: '/resources/webuploader/Uploader.swf',
            // 文件接收服务端。
            server: data.uploadUrl,
            pick: '#picker',
            resize: false,
            fileVal: "file",
            formData: data,
            disableGlobalDnd: true,
            dnd: ".file-select"
        };
        let options = $.extend({},defaultOptions,option);
        uploader = WebUploader.create(options);
        //文件加入到队列
        uploader.on('fileQueued', function (file) {
            var fileItem = [
                '<div id="' + file.id + '" class="uploader-list-item">',
                '<div class="flex flex-align-items-center">',
                '<div class="upload-file-name flex-auto">' + file.name + '</div>',
                '<div class="upload-file-status flex-none mr20">等待上传</div>',
                '<div class="upload-file-remove flex-none"><span class="fa fa-remove"></span></div>',
                '</div>',
                '</div>'
            ];
            $("#fileList").append(fileItem.join(""));
        });
        // 开始上传
        uploader.on('startUpload', function () {

        });
        // 文件上传过程中创建进度条实时显示。
        uploader.on('uploadProgress', function (file, percentage) {
            var $fileItem = $('#' + file.id),
                $percent = $fileItem.find('.biz-progress');
            // 避免重复创建
            if (!$percent.length) {
                var progress = [
                    '<div class="biz-progress">',
                    '<div class="flex flex-align-items-center" style="height: 20px;">',
                    '<div class="biz-progress-back flex-auto">',
                    '<div class="biz-progress-bar">',
                    '</div>',
                    '</div>',
                    '<div class="biz-progress-text flex-none">',
                    '</div>',
                    '</div>',
                    '</div>'
                ];
                $fileItem.append(progress.join(""))
            }
            var nowPercent = percentage * 100;
            $fileItem.find('.biz-progress-text').text(nowPercent + '%');
            $fileItem.find('.upload-file-status').removeClass("retry").text("正在上传...");
            $fileItem.find('.biz-progress-bar').css({
                width: nowPercent + '%',
                backgroundColor: "#1890ff"
            });
        });
        uploader.on('uploadSuccess', function (file, response) {
            if (response.success) {
                $('#' + file.id).find('.upload-file-status').removeClass("retry").text('上传完成');
                responseArray.push(response);
                $('#' + file.id).find('.biz-progress').fadeOut();
            } else {
                $('#' + file.id).find('.upload-file-status').addClass("retry").text('重新上传');
                $('#' + file.id).find('.biz-progress-bar').css({
                    width: 0 + '%',
                    backgroundColor: "red"
                });
                $('#' + file.id).find('.biz-progress-text').text('0%');
            }
        });
        uploader.on('uploadError', function (file) {
            $('#' + file.id).find('.upload-file-status').addClass("retry").text('重新上传');
            $('#' + file.id).find('.biz-progress-bar').css({
                width: 0 + '%',
                backgroundColor: "red"
            });
            $('#' + file.id).find('.biz-progress-text').text('0%');
            callback(null)
        });
        uploader.on('uploadComplete', function (file) {

        });

        uploader.on("uploadFinished", function () {
            // if(data.muilt){
            callback(responseArray);
            var api = frameElement.api, W = api.opener;
            api.close();
        })
    }

    function startUpload() {
        uploader && uploader.upload();
    }
</script>
</body>
</html>