<%@ page language="java" import="java.util.*" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>Excel导入</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <link rel="stylesheet" href="/resources/webuploader/webuploader.css">
    <style>
        .biz-uploader {
            width: 100%;
            height: 100%;
        }

        .biz-uploader-run {
            width: 100%;
            height: 100%;
            position: relative;
            border: 1px solid #dddddd;
            padding: 20px;
            box-sizing: border-box;
        }

        .biz-uploader-info {
            width: 100%;
            height: 180px;
            border: 1px solid #dddddd;
            overflow-y: auto;
            padding: 0 5px;
            box-sizing: border-box;
            border-radius: 5px;
            background: #ffffff;
        }

        .file-select {
            width: 100%;
            height: 100px;
            border: 2px dashed #898989;
            box-sizing: border-box;
        }

        .uploader-list {
            width: 100%;
            height: 80px;
            box-sizing: border-box;
        }

        .uploader-list-item {
            line-height: 40px;
        }

        .upload-file-status.retry {
            color: #1890ff;
        }

        .upload-file-status.retry:hover {
            opacity: .8;
        }

        .upload-file-remove:hover {
            color: #1890ff;
            cursor: pointer;
        }

        .biz-progress-back {
            position: relative;
            width: 100%;
            overflow: hidden;
            vertical-align: middle;
            background-color: #f5f5f5;
            border-radius: 100px;
        }

        .biz-progress-bar {
            height: 5px;
            width: 0;
            background-color: #1890ff;
            border-radius: 100px;
            transition: all .3s cubic-bezier(0.075, 0.82, 0.165, 1);
        }

        .biz-progress-text {
            width: 50px;
            text-align: center;
        }

        .webuploader-pick {
            background: transparent;
        }

        .webuploader-pick > span {
            font-size: 35px;
            color: #2290FE;
        }

        .webuploader-pick > p {
            color: #696969;
        }

        .webuploader-pick:hover {
            background: transparent;
        }
    </style>
</head>
<body style="overflow-y: hidden" scroll="no">
<div class="biz-uploader">
    <div class="biz-uploader-run">
        <div class="file-select flex flex-align-items-center flex-justify-content-center">
            <div id="picker">
                <span class="fa fa-cloud-upload"></span>
                <p>点击上传，或将文件拖拽到此处</p>
            </div>
        </div>
        <div id="fileList" class="uploader-list">

        </div>
        <div class="biz-uploader-info">
            <p>处理结果：</p>
        </div>
    </div>
</div>

<script src="/resources/webuploader/webuploader.min.js"></script>

<script>
    var uploader = null;
    var pullQueryUrl = '/websocket/websocketApi/circulateController/circulateMessage/';
    $(function () {
        //移除文件
        $("#fileList").on('click', '.upload-file-remove', function () {
            var itemId = $(this).parents(".uploader-list-item").attr("id");
            uploader.removeFile(itemId);
            $(this).parents(".uploader-list-item").remove();
        });
        //重新上传
        $("#fileList").on('click', '.upload-file-status.retry', function () {
            var itemId = $(this).parents(".uploader-list-item").attr("id");
            uploader.retry(itemId);
        });
    });

    function initWebUploader(data, callback) {

        var uuid = Math.random();
        data = $.extend({}, data, {excelUuid: uuid});
        var socketOptions = {url: '${excelWebsocketUrl}', uuid: data.excelUuid};
        var socket = BizSocket(socketOptions);
        uploader = WebUploader.create({
            // swf文件路径
            swf: '/resources/webuploader/Uploader.swf',
            // 文件接收服务端。
            server: data.uploadUrl,
            pick: '#picker',
            resize: false,
            fileVal: "excel",
            formData: data,
            fileNumLimit: 1,
            disableGlobalDnd: true,
            dnd: ".file-select",
            accept: {
                title: 'Excel',
                extensions: 'xlsx,xls',
            }
        });
        //文件加入到队列
        uploader.on('fileQueued', function (file) {
            var fileItem = [
                '<div id="' + file.id + '" class="uploader-list-item">',
                '<div class="flex flex-align-items-center">',
                '<div class="upload-file-name flex-auto">' + file.name + '</div>',
                '<div class="upload-file-status flex-none mr20">等待上传</div>',
                '<div class="upload-file-remove flex-none"><span class="fa fa-remove"></span></div>',
                '</div>',
                '</div>'
            ];
            $("#fileList").append(fileItem.join(""));
        });
        // 开始上传
        uploader.on('startUpload', function () {

            if (socket) {
                /**
                 * 0 - 表示连接尚未建立。
                 * 1 - 表示连接已建立，可以进行通信。
                 * 2 - 表示连接正在进行关闭。
                 * 3 - 表示连接已经关闭或者连接不能打开。
                 * */
                var readyState = socket.readyState;
                if (readyState !== 1) {
                    var interVal = null;
                    interVal = setInterval(function () {
                        pollQuery(pullQueryUrl + data.excelUuid, function (res) {
                            if (res.success) {
                                if (res.obj) {
                                    if (res.obj.content) {
                                        if ($(".biz-uploader-info").find('p[uuid="' + res.obj.uuid + '"]').length === 0) {
                                            $(".biz-uploader-info").append('<p uuid="' + res.obj.uuid + '">' + res.obj.content + '</p>');
                                            setTimeout(function () {
                                                $(".biz-uploader-info").scrollTop($(".biz-uploader-info")[0].scrollHeight);
                                            }, 50);
                                        }
                                    }
                                    if (res.obj.isEnd) {
                                        interVal ? clearInterval(interVal) : "";
                                    }
                                } else {
                                    interVal ? clearInterval(interVal) : "";
                                }
                            } else {
                                interVal ? clearInterval(interVal) : "";
                            }
                        })
                    }, 1000)
                }

                socket.onopen = function (ev) {
                };
                socket.onmessage = function (ev) {
                    var data = ev.data;
                    $(".biz-uploader-info").append('<p>' + data + '</p>');
                    setTimeout(function () {
                        $(".biz-uploader-info").scrollTop($(".biz-uploader-info")[0].scrollHeight);
                    }, 50)
                };

                socket.onerror = function (ev) {

                };

                socket.onclose = function (ev) {
                };
            }
        });
        // 文件上传过程中创建进度条实时显示。
        uploader.on('uploadProgress', function (file, percentage) {
            var $fileItem = $('#' + file.id),
                $percent = $fileItem.find('.biz-progress');
            // 避免重复创建
            if (!$percent.length) {
                var progress = [
                    '<div class="biz-progress">',
                    '<div class="flex flex-align-items-center" style="height: 20px;">',
                    '<div class="biz-progress-back flex-auto">',
                    '<div class="biz-progress-bar">',
                    '</div>',
                    '</div>',
                    '<div class="biz-progress-text flex-none">',
                    '</div>',
                    '</div>',
                    '</div>'
                ];
                $fileItem.append(progress.join(""))
            }
            var nowPercent = percentage * 100;
            $fileItem.find('.biz-progress-text').text(nowPercent + '%');
            $fileItem.find('.upload-file-status').removeClass("retry").text("正在上传...");
            $fileItem.find('.biz-progress-bar').css('width', nowPercent + '%');
        });
        uploader.on('uploadSuccess', function (file, response) {
            if (response.success) {
                $('#' + file.id).find('.upload-file-status').removeClass("retry").text('上传完成');

                callback(response);
            } else {
                $('#' + file.id).find('.upload-file-status').addClass("retry").text('重新上传');
                $(".biz-uploader-info").append('<p style="color:red;">' + response.msg + '</p>');
            }
        });
        uploader.on('uploadError', function (file) {
            $('#' + file.id).find('.upload-file-status').addClass("retry").text('重新上传');
            callback(null)
        });
        uploader.on('uploadComplete', function (file) {
            $('#' + file.id).find('.biz-progress').fadeOut();
        });
    }

    function startUpload() {
        uploader && uploader.upload();
    }

    //轮询
    function pollQuery(url, cb) {
        $.ajax({
            url: url,
            type: "post",
            dataType: "json",
            success: function (res) {
                cb(res);
            }
        })
    }
</script>
</body>
</html>