<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<head>
	<style>
		.list_li{line-height: 20px;cursor:pointer;}
		.list_li:hover{background:#eaf2ff;}
		.list_li input{vertical-align:middle;}
	</style>
</head>
<body class="easyui-layout" id="roleListbody">
<div region="center">
	<t:datagrid name="roleList"  actionUrl="tMroleController.do?findRoleList" fit="true"
				extendTableName="${extendTableName}" idField="id"  fitColumns="false" queryMode="group" onDblClick="onClickExpendPermisson">

		<t:dgToolBar title="新增" operationCode="add"  icon="icon-add" url="tMroleController.do?goRoleForm&optype=0" funname="addFun"></t:dgToolBar>
		<t:dgToolBar title="编辑" operationCode="edit"  icon="icon-edit" url="tMroleController.do?goRoleForm&optype=1" funname="update" width="380" height="150"></t:dgToolBar>
		<t:dgToolBar title="删除" operationCode="remove"  icon="icon-remove"  url="tMroleController.do?delete" funname="deleteById"></t:dgToolBar>

		<t:dgToolBar title="启用" operationCode="start"  icon="icon-start" url="tMroleController.do?startOrStopRole" funname="startOrStopRole('009')"></t:dgToolBar>
		<t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url="tMroleController.do?startOrStopRole" funname="startOrStopRole('003')"></t:dgToolBar>
		<t:dgToolBar title="权限设置" operationCode="setting"  icon="icon-setting"  url="" funname="onClickExpendPermisson"></t:dgToolBar>
		<t:dgToolBar title="查询职位" operationCode="preview"  icon="icon-preview"  url="" funname="findTmPositionByRole"></t:dgToolBar>
		<t:dgToolBar title="角色-职位关系维护" operationCode="previewMaintain"  icon="icon-preview"  url="" funname="maintainTmPositionByRole"></t:dgToolBar>
		<t:dgToolBar title="角色-职位关系导入" operationCode="actRolePositionImp" icon="icon-dataIn" onclick="importDataByXml({impName:'tmRolePosition', gridName:'roleList'})"></t:dgToolBar>
		<t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut" url="tMroleController.do?exportXls" funname="excelExport"></t:dgToolBar>
		<t:dgToolBar title="日志" operationCode="log"  icon="icon-log" url="tmLogController.do?goTmLogDetailMain" funname="detailLog" width="1200" height="460"></t:dgToolBar>
	</t:datagrid>
</div>
<div data-options="region:'east',split:true,collapsed:true,title:'权限列表'" style="width:500px;">
	<div class="easyui-layout" fit="true">
		<div data-options="region:'west',split:false,border:true,collapsible:false,tools:[{iconCls:'icon-save',handler:function(){setMenu()}}]" title="菜单列表" style="width:220px;">
			<ul id="functionId"></ul>
		</div>
		<div data-options="region:'center'">
			<div class="easyui-layout" fit="true">
				<div data-options="region:'north',collapsible:false,fitColumns:true,tools:[{iconCls:'icon-save',handler:function(){setOperation()}}]" title="按钮列表" style="height:250px">
					<table id="buttonList" class="easyui-datagrid"
						   data-options="singleSelect:false,method:'get'">
						<thead>
						<tr>
							<th data-options="field:'ck',checkbox:true"></th>
							<th data-options="field:'id',hidden:true">id</th>
							<th data-options="field:'operationCode'">按钮编码</th>
							<th data-options="field:'title'">按钮名称</th>
						</tr>
						</thead>
					</table>
				</div>
				<div data-options="region:'south',split:true,title:'权限值',tools:[{iconCls:'icon-save',handler:function(){setAuth()}}]" style="height:180px;">
					<table id="authValList" class="easyui-datagrid"
						   data-options="singleSelect:false,method:'get'">
						<thead>
						<tr>
							<th data-options="field:'ck',checkbox:true"></th>
							<th data-options="field:'id',hidden:true">id</th>
							<th data-options="field:'status',hidden:true">checked</th>
							<th data-options="field:'dictCode'">编码</th>
							<th data-options="field:'dictValue'">描述</th>
						</tr>
						</thead>
					</table>
				</div>
				<div data-options="region:'center',title:'权限对象'">
						<table id="authList" class="easyui-datagrid"
							   data-options="singleSelect:true,method:'get'">
							<thead>
							<tr>
								<th data-options="field:'ck',checkbox:true"></th>
								<th data-options="field:'dictCode',hidden:true">dictCode</th>
								<th data-options="field:'dictValue'">权限对象</th>
							</tr>
							</thead>
						</table>
				</div>
				<div data-options="region:'west',split:true,title:'功能列表',fitColumns:true,collapsible:false" style="width:150px;">
					<table id="funAuthList" class="easyui-datagrid"
						   data-options="singleSelect:true,method:'get'">
						<thead>
						<tr>
							<th data-options="field:'ck',checkbox:true"></th>
							<th data-options="field:'funCode',hidden:true">funCode</th>
							<th data-options="field:'funName'">功能名称</th>
							<th data-options="field:'note'">描述</th>
						</tr>
						</thead>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
</body>

<script type="text/javascript">

	$(function () {

    });

//权限列表
function expendPermisson(rowIndex,rowData) {
	var roleTarget = $("#roleList").datagrid('getSelected');
	if(roleTarget==null){
		tip("请选择一条角色数据");
		return;
	}
	if(li_east == 0){
	   $('#system_role_roleList').layout('expand','east'); 
	}
	$('#PermissonDeatil').panel("refresh", "tMroleController.do?goPermSetting&roleId=" +roleTarget.id);
}

function deleteAllbuttonList() {
    var buttonList = $('#buttonList').datagrid("getRows");
    for(var i=buttonList.length-1;i>=0;i--){
        var index = $("#buttonList").datagrid("getRowIndex",buttonList[i]);
        $("#buttonList").datagrid("deleteRow",index);
	}
}

function onClickExpendPermisson() {
    $('#roleListbody').layout('expand', 'east');
    var roleTarget = $("#roleList").datagrid('getSelected');
    if(roleTarget==null){
        tip("请选择一条角色数据");
        return;
    }
     var roleId = roleTarget.id;
    openProgress();
     //初始化权限菜单列表
    $('#functionId').tree({
        checkbox : true,
        url : 'tMroleController.do?getMenuInfoTreeByRole&roleId='+roleId,
        onLoadSuccess : function(node) {
            deleteAllbuttonList();
            clearAllAuthValList();
            clearAllAuthList();
            clearFunAuthList();
            //首次加载之后如果有默认选中的自动展开指定节点
            var node = $('#functionid').tree('getSelected');
            if(node){
                $('#functionId').tree('expand',node.target);
            }
            closeProgress();
        },
        onClick: function(node){
            //是否父级节点
            var isFirstNode =  $('#functionId').tree('getChildren', node.target);
            if(isFirstNode =='' || isFirstNode==undefined || isFirstNode == null){
                loadButton(roleId,node.id);
                setFunAuthList(roleId,node.id);
                clearAllAuthValList();
                clearAllAuthList();
                clearFunAuthList();
                // authObjList(roleId,node.id);
            }else {
                $("#oprateList").html("");
            }
            if (node.checked) {
                //如果被选中，更改当前节点为未选中
                // $(this).tree('uncheck',node.target);
            }else{
                //如果未被选中，更改当前节点状态为已选中
                $(this).tree('check',node.target);
            }
        }
    });
    // $('#PermissonDeatil').panel("refresh", "tMroleController.do?goPermSetting&roleId=" +roleTarget.id);
}

//删除
function deleteById(){
	var roleTarget = $("#roleList").datagrid('getSelected');
	if(roleTarget==null){
		tip("请至少选择一条数据");
		return;
	}
	if(roleTarget.roleName=='admin'){
		tip("超级管理员角色不能被删除");
		return false;
	}
	$.messager.confirm('操作提示',"确定删除数据吗?",function(r){ 
	    if (r){
	    	$.ajax({
	        	type : "POST",
	        	url : "tMroleController.do?delete",
	        	data : {
	            	"id" : roleTarget.id,
	        	},
	        	dataType : "json",
	        	success : function(data) {
	        		tip(data.msg);
	        		$("#roleList").datagrid('reload');
	        	},
	        	error:function(){
	        		tip("服务器异常，请稍后再试");
	        	}
		   });
	    }
	});
}

function addFun(title,url, id) {
	var rowData = $('#'+id).datagrid('getSelected');
	if (rowData) {
		url += '&tmFunction.id='+rowData.id;
	}
	add(title,url,'roleList',380,150);
}

//查询职位
function findTmPositionByRole(){
    var rowData = $("#roleList").datagrid('getSelected');
    if (rowData=="" || rowData==null) {
        tip("请选择一条角色数据");
        return false;
    }
    var roleId = rowData.id;
    openwindow("相关职位", "tmPositionController.do?goTmPositionByRoleMain&roleIds="+roleId, "roleList", 700, 500);
}

//角色-职位关系维护
function maintainTmPositionByRole(){
	var rowData = $("#roleList").datagrid('getSelected');
	if (rowData=="" || rowData==null) {
		tip("请选择一条角色数据");
		return false;
	}
	var roleId = rowData.id;
	openwindow("角色-职位关系维护", "tmPositionController.do?goTmMaintainPositionByRoleMain&roleIds="+roleId, "roleList", 900, 600);
}

//停用启用
function startOrStopRole(flag){
	var roleTarget = $("#roleList").datagrid('getSelected');
	if(roleTarget == null){
		tip("请选择一条要操作的数据");
		return;
	}
	var tipmMsg = "";
	if(flag == '009'){
		tipmMsg = "确定要启用该数据吗?"
	}else{
		tipmMsg = "确定要停用该数据吗?"
	}
	$.messager.confirm('操作提示',tipmMsg,function(r){ 
	    if (r){
	    	$.ajax({
	        	type : "POST",
	        	url : "tMroleController.do?startOrStopRole",
	        	data : {
	            	"id" : roleTarget.id,
	            	"enableStatus": flag
	        	},
	        	dataType : "json",
	        	success : function(data) {
	        		tip(data.msg);
	        		$("#roleList").datagrid('reload');
	        	},
	        	error:function(){
	        		tip("服务器异常，请稍后再试");
	        	}
		   });
	    }
	});
}

function loadButton(roleId,funId) {
    $('#buttonList').datagrid({
        url: 'tMroleController.do?findFunButtonList&funId='+funId,
        onLoadSuccess: function(){
            setButton(roleId,funId);
        }
    });

}

function setButton(roleId,funId) {
    $.post("tMroleController.do?findFunButtonValList", { "roleId": roleId,"funId":funId },
        function(data){
            var datas = $("#buttonList").datagrid("getRows");
            for(var i=0;i<data.length;i++){
                var id = data[i].id;
                for(var j=0;j<datas.length;j++){
                    var idtemp = datas[j].id;
                    if(idtemp==id){
                        var index = $("#buttonList").datagrid("getRowIndex",datas[j]);
                        $("#buttonList").datagrid("selectRow",index);
                        break;
                    }
                }
            }
        }, "json");
}

function clearFunAuthList() {
    var datas = $("#funAuthList").datagrid("getRows");
    for(var i=datas.length-1;i>=0;i--){
        var index = $("#funAuthList").datagrid("getRowIndex",datas[i]);
        $("#funAuthList").datagrid("deleteRow",index);
    }
}

function setFunAuthList(roleId,funId) {
    $('#funAuthList').datagrid({
        url: 'funAuthController.do?findFunAuthListByFunIdForRole&funId='+funId,
        onLoadSuccess: function(){
            // setButton(roleId,funId);
        },
        onSelect:function(rowIndex, rowData){
            loadAuthList(roleId,rowData.funCode,funId);
            clearAllAuthValList();
		}
    });
}

function clearAllAuthList() {
    var datas = $("#authList").datagrid("getRows");
    for(var i=datas.length-1;i>=0;i--){
        var index = $("#authList").datagrid("getRowIndex",datas[i]);
        $("#authList").datagrid("deleteRow",index);
    }
}

function loadAuthList(roleId,funCode,funId) {
    $('#authList').datagrid({
        url: 'funAuthController.do?findFunAuthListByFunCodeValForRole&funCode='+funCode+'&funId='+funId,
        onLoadSuccess: function(){
        },
        onSelect:function(rowIndex, rowData){
            LoadAuthValList(rowData.dictCode,funCode,funId,roleId);
        }
    });
}

function clearAllAuthValList() {
    var datas = $("#authValList").datagrid("getRows");
    for(var i=datas.length-1;i>=0;i--){
        var index = $("#authValList").datagrid("getRowIndex",datas[i]);
        $("#authValList").datagrid("deleteRow",index);
    }
}

function LoadAuthValList(authobj,funCode,funId,roleId) {
    $('#authValList').datagrid({
        url: 'funAuthController.do?findFunAuthValForRole&funCode='+funCode+'&funId='+funId+'&authobj='+authobj+'&roleId='+roleId,
        onLoadSuccess: function(){
            var datas = $("#authValList").datagrid("getRows");
            for(var i=0;i<datas.length;i++){
                if(datas[i].status == "true"){
                    var index = $("#authValList").datagrid("getRowIndex",datas[i]);
                    $("#authValList").datagrid("selectRow",index);
				}
			}
        },
        onClickCell:function(){

        }
    });
}
    function setMenu(){
        var roleTarget = $("#roleList").datagrid('getSelected');
        if(roleTarget==null){
            tip("请选择一条角色数据");
            return;
        }
        var roleId = roleTarget.id;
        var nodes = [];
        var nodes1 = $('#functionId').tree('getChecked');
        var nodes2 = $('#functionId').tree('getChecked', 'indeterminate');//获取所有选中的节点
        nodes = nodes1.concat(nodes2);
        if(nodes != null && nodes != ""){
            var funcIds = "";
            $.each(nodes,function(i,v){
                if(funcIds!="" && funcIds.length > 0){
                    funcIds += ",";
                }
                //加入子节点
                funcIds += v.id;
                var parent = $('#functionId').tree("getParent",v.target);
                //加入父节点id
                if(parent != null && funcIds.indexOf(parent.id) == -1){
                    if(funcIds!="" && funcIds.length > 0){
                        funcIds += ",";
                    }
                    funcIds += parent.id;
                }
            });
        }
        openProgress();
        //请求
        $.ajax({
            cache : false,
            type : 'POST',
            url : "tMroleController.do?setFuncRole",
            data : {
                "roleId" : roleId,
                "funcIds":funcIds
            },
            dataType : "json",
            success : function(data) {
                closeProgress();
                tip(data.msg);
            },
            error:function(){
                tip("服务器异常，请稍后再试");
            }
        });
    }

    function setOperation(){
        var funcTarget = $("#functionId").tree("getSelected");
        var opretionIds = "";
        if(funcTarget == null){
            tip("请选择一个菜单");
            return;
        }
        var opretionTarges = $("#buttonList").datagrid('getSelections');
        //设置选中的按钮
		for(var i=0;i<opretionTarges.length;i++){
            if(opretionIds != ""){
                opretionIds += ",";
            }
            opretionIds += opretionTarges[i].id;
		}

        var roleTarget = $("#roleList").datagrid('getSelected');
        if(roleTarget==null){
            tip("请选择一条角色数据");
            return;
        }
        var roleId = roleTarget.id;
        openProgress();
        //请求
        $.ajax({
            cache : false,
            type : 'POST',
            url : "tMroleController.do?setOperateByFuncRole",
            data : {
                "opretionIds" : opretionIds,
                "roleId":roleId,
                "funcId":funcTarget.id
            },
            dataType : "json",
            success : function(data) {
                closeProgress();
                tip(data.msg);
            },
            error:function(){
                tip("服务器异常，请稍后再试");
            }
        });
    }


    function setAuth(){
        var funcTarget = $("#functionId").tree("getSelected");

        if(funcTarget == null){
            tip("请选择菜单");
            return;
        }
        var roleTarget = $("#roleList").datagrid('getSelected');
        if(roleTarget==null){
            tip("请选择一条角色数据");
            return;
        }
        var roleId = roleTarget.id;

        var authList = $('#authList').datagrid("getSelected");
        if(authList==null){
            tip("请选择一条权限对象数据");
            return;
		}
        var authObj = authList.dictCode;
        var authTarges = $("#authValList").datagrid('getSelections');
        var authIds = "";
        if(authTarges.length > 0){
            $.each(authTarges,function(i,v){
                if(authIds != ""){
                    authIds += ",";
                }
                authIds += v.dictCode;
            });
        }
        var funAuthList = $('#funAuthList').datagrid("getSelected");
        if(funAuthList==null){
            tip("请选择一条功能列表数据");
            return;
		}
		var funCode = funAuthList.funCode;
        openProgress();
        //请求
        $.ajax({
            cache : false,
            type : 'POST',
            url : "tMroleController.do?setAuthObjValue",
            data : {
                "authCodes" : authIds,
                "roleId":roleId,
                "funcId":funcTarget.id,
                "authObj":authObj,
				"funCode":funCode
            },
            dataType : "json",
            success : function(data) {
                closeProgress();
                tip(data.msg);
            },
            error:function(){
                tip("服务器异常，请稍后再试");
            }
        });
    }

</script>

