<%@ page language="java" contentType="text/html; charset=UTF-8"
		 pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools"></t:base>
<body class="easyui-layout">
<div data-options="region:'east',split:true" style="width:350px;">
	<t:datagrid name="refBusinessList" fitColumns="true" title="已关联" queryMode = "group"  onDblClick="onDblClickrefBusinessList" pagination="false"
				actionUrl="tmCustOrgController.do?findRefBusinessGrid&custOrgId=${custOrgId}" idField="id" >
		<t:dgCol title="主键" hidden="true" field="id" ></t:dgCol>
		<t:dgCol title="业务组"  field="businessGroup"></t:dgCol>
		<t:dgCol title="职位编号" field="positionCode" ></t:dgCol>
		<t:dgCol title="职位名称" field="positionName"></t:dgCol>
		<t:dgCol title="用户名" field="userName"></t:dgCol>
		<t:dgCol title="所属组织" field="orgName"></t:dgCol>
		<t:dgToolBar title="移除" icon="icon-user_lock" url="" funname="removeTmposition"></t:dgToolBar>
	</t:datagrid>
</div>
<div data-options="region:'center'" style="padding:5px;">
	<t:datagrid name="notRefBusinessList" fitColumns="true" title="未关联" queryMode = "group"
				idField="id"  onDblClick="onDblClicknotRefBusinessList"
				actionUrl="tmCustOrgController.do?findNotRefBusinessGrid&custOrgId=${custOrgId}">
		<t:dgCol title="主键" hidden="true" field="id" ></t:dgCol>
		<t:dgCol title="业务组"  field="businessGroup" dictionary="business_group" query="true"></t:dgCol>
		<t:dgCol title="职位编号" field="positionCode"></t:dgCol>
		<t:dgCol title="职位名称" field="positionName" query="true" ></t:dgCol>
		<t:dgCol title="用户名" field="userName"  query="true"></t:dgCol>
		<t:dgCol title="所属组织" field="orgName"  query="false"></t:dgCol>
		<t:dgToolBar title="添加" icon="icon-add" url="" funname="addPosition"></t:dgToolBar>
	</t:datagrid>
</div>
</body>

<script type="text/javascript">
    
	function onDblClickrefBusinessList(rowIndex,rowData) {
        $.ajax({
            url : "tmCustOrgController.do?removeCustOrgBusiness",
            type : 'post',
            data : {
                custOrgId : '${custOrgId}',
                id:rowData.id
            },
            cache : false,
            success : function(d) {
                var msg = d.msg;
                if (d.success) {
                    refBusinessListsearch();
                    notRefBusinessListsearch();
                }else{
                    tip(msg);
				}
            }
        });
    }
    
    function removeTmposition(){
        var checkListTarget =  $("#refBusinessList").datagrid("getSelections");
        if(checkListTarget==null || checkListTarget==""){
            tip("请至少选择一条数据");
            return false;
        }
        var rowData = $("#refBusinessList").datagrid("getSelected");
        var id = rowData.id;
        $.ajax({
            url : "tmCustOrgController.do?removeCustOrgBusiness",
            type : 'post',
            data : {
                custOrgId : '${custOrgId}',
                id:id
            },
            cache : false,
            success : function(d) {
                if (d.success) {
                    refBusinessListsearch();
                    notRefBusinessListsearch();
                }else{
                    tip(d.msg);
				}
            }
        });
    }

    function onDblClicknotRefBusinessList(rowIndex,rowData){
        $.ajax({
            url : "tmCustOrgController.do?addCustOrgBusiness",
            type : 'post',
            data : {
                custOrgId : '${custOrgId}',
                id:rowData.id
            },
            cache : false,
            success : function(d) {
                var msg = d.msg;
                if (d.success) {
                    refBusinessListsearch();
                    notRefBusinessListsearch();
                }else{
                    tip(msg);
                }
            }
        });
	}

    $(document).ready(function(){
        $("input[name='orgName']").combotree({
            url: 'tmOrgController.do?getParentOrg',
            onSelect : function(node) {
                $("input[name='orgName']").val(node.id);
            }
        });
    });


    //静态添加
    function addPosition(){
        var seletctTarget =  $("#notRefBusinessList").datagrid("getSelections");
        if(seletctTarget==null || seletctTarget==""){
            tip("请至少选择一条数据");
            return false;
        }
        //添加之前判断已关联业代是否 有一条数据有就不能添加
        var rows = $("#refBusinessList").datagrid("getRows");
        if(rows.length>0){
            tip("当前组织已有关联业代！");
            return false;
        }
        var rowData = $("#notRefBusinessList").datagrid("getSelected");
        var id = rowData.id;
        $.ajax({
            url : "tmCustOrgController.do?addCustOrgBusiness",
            type : 'post',
            data : {
                custOrgId : '${custOrgId}',
                id:id
            },
            cache : false,
            success : function(d) {
                if (d.success) {
                    refBusinessListsearch();
                    notRefBusinessListsearch();
                }else{
                    tip(d.msg);
				}
                // $.messager.show({
                //     title:'提示',
                //     msg:msg,
                //     timeout:3000,
                //     showType:'slide'
                // });
            }
        });
    }

</script>


