<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,autocomplete"></t:base>
<div id="tmMaintainPositionMain" class="easyui-layout" fit="true">
	<div data-options="region:'west',border:false,split:true" style="width:550px">
		<div class="easyui-layout" fit="true">

			<div data-options="region:'center',split:true,border:false">
				<t:datagrid name="unbindingList" title="未关联该职位的用户" fit="true" fitColumns="true" checkbox="true"
							singleSelect="false" actionUrl="tmUserController.do?getUnbindingPositionUsers&positionId=${positionId}" idField="id" queryMode="group">
					<t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
					<t:dgCol title="用户账号" field="userName"  query="true" ></t:dgCol>
					<t:dgCol title="用户名称" field="fullName" query="true"  ></t:dgCol>
					<t:dgToolBar title="添加关联"  icon="icon-add" url="tmUserController.do?addUserPosition&positionId=${positionId}" funname="addUserPosition"></t:dgToolBar>
				</t:datagrid>
			</div>

		</div>
	</div>

	<div data-options="region:'center',split:true,border:false">
		<t:datagrid name="bindingList" title="已关联该职位的用户" fit="true" fitColumns="true"
					singleSelect="false" actionUrl="tmUserController.do?getUserByPositionId&positionId=${positionId}" idField="id" pagination="false">
			<t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
			<t:dgCol title="用户账号" field="userName"   ></t:dgCol>
			<t:dgCol title="用户名称" field="fullName"  ></t:dgCol>
			<t:dgToolBar title="解除关联"  icon="icon-remove" url="tmUserController.do?delUserPosition&positionId=${positionId}" funname="deleteRelotaionForPositionId"></t:dgToolBar>
		</t:datagrid>
	</div>

</div>
<script type="text/javascript">
    function addUserPosition(title, url, gname) {
        var rows = $("#" + gname).datagrid("getSelections");
        if(rows == null || rows == "" || rows.length != 1){
            tip("请至选择一条数据", 'error');
            return false;
        }
		url += "&userId=" + rows[0].id
        $.ajax({
            url : url,
            type : 'post',
            // data : {customerIds : ids.join(',')},
            cache : false,
            success : function(data) {
                var d = data
                var msg = d.msg;
                if (d.success) {
                    tip(msg,'info');
                    reloadDataGrid(gname);
                }else{
                    tip(msg,'error');
                    return;
                }
            },
            error:function(){
                tip("请求错误",'error');
                return false;
            }
        });
    }

    function deleteRelotaionForPositionId(title, url, gname, width, height, params) {
		var rows = $("#" + gname).datagrid("getRows");
		if(rows == null || rows == "" || rows.length == 0){
			tip("未绑定任何用户数据", 'error');
			return false;
		}

        getSafeJq().dialog.confirm("确定删除已绑定的用户?", function(r) {
            if (r) {
                $.ajax({
                    url : url,
                    type : 'post',
                    // data : {ids : ids.join(',')},
                    cache : false,
                    success : function(data) {
                        var d = data
                        var msg = d.msg;
                        if (d.success) {
                            tip(msg,'info');
                            reloadDataGrid(null);
                        }else{
                            tip(msg,'error');
                            return;
                        }
                    },
                    error:function(){
                        tip("请求错误",'error');
                        return false;
                    }
                });
            }
        });
    }

    function reloadDataGrid(gname) {
        if(gname==null){
            $("#unbindingList").datagrid("reload");
        }else{
            $("#"+gname).datagrid("reload");
        }

        $("#bindingList").datagrid("reload");
    }
</script>