
let targetTableTemplate = '<div class="flex flex-align-items-start" v-if="showTarget==1">\n' +
    '                <select class="flex-none mr5" v-model="processKey" @change="loadTargetData">\n' +
    '                    <option :value="bmp.processKey" v-for="bmp in bmpkeys" :key="bmp.processKey">{{bmp.processName}}\n' +
    '                    </option>\n' +
    '                </select>\n' +
    '                <div class="flex-auto target-table mb10">\n' +
    '                    <table>\n' +
    '                        <thead>\n' +
    '                        <tr>\n' +
    '                            <th v-for="(h,hindex) in targetTableData.head" v-show="h.isShow==1" :key="hindex"\n' +
    '                                :width="h.width" :field="h.filed">{{h.name}}\n' +
    '                            </th>\n' +
    '                        </tr>\n' +
    '                        </thead>\n' +
    '                        <tbody>\n' +
    '                        <tr v-for="(b,bindex) in targetTableData.items" :key="bindex">\n' +
    '                            <td v-for="(h,hindex) in targetTableData.head" v-show="h.isShow==1" :key="hindex"\n' +
    '                                :width="h.width">{{b[h.filed]}}\n' +
    '                            </td>\n' +
    '                        </tr>\n' +
    '                        </tbody>\n' +
    '                    </table>\n' +
    '                </div>\n' +
    '                <div class="search-budge p5 flex-none">\n' +
    '                        <span @click="handleRefresh" class="fa fa-refresh"\n' +
    '                              style="display: block;font-size: 16px;"></span>\n' +
    '                </div>\n' +
    '            </div>';
/* 关键指标组件 */
Vue.component('target-table',{
    name:"targetTable",
    template:isExitsFunction('targetTableTemplateExtend') ? targetTableTemplateExtend() : targetTableTemplate,
    props:{
        page:{
            type:String,
            default:"",
            require:true
        },
        id:{
            type:String,
            default:"",
            require:true
        },
        showTarget:{
            type:String,
            default:""
        },
        viewStatus:{
            type:String,
            default:""
        }
    },
    data:function () {
       return{
           bmpkeys: [],
           processKey: "",
           targetTableData: {
               head: [],
               items: []
           }
       }
    },
    mounted: function () {
        this.showTarget == 1 && this.page? this.loadBpmKeys() : '';
    },
    methods: {
        loadBpmKeys: function () {
            let this_ = this;
            $.ajax({
                url: "/act/actCommonController/getBpmList?processPage=" + this_.page + "&id=" + this_.id,
                type: "post",
                dataType: "json",
                success: function (res) {
                    if (res.success) {
                        if (res.obj && res.obj.length > 0) {
                            this_.bmpkeys = res.obj;
                            if (res.obj.length === 1) {
                                this_.processKey = res.obj[0].processKey;
                            } else {
                                this_.processKey = this_.findSelectedProcess(res.obj)||res.obj[0].processKey;
                            }
                            this_.loadTargetData();
                        } else {
                            this_.bmpkeys = [];
                        }
                    } else {
                        tip(res.msg);
                    }
                }
            })
        },
        loadTargetData: function () {
            let this_ = this;
            $.ajax({
                url: "/act/actCommonController/getBpmDetail?1=1&processPage="+this_.page+"&id="+this_.id+"&bpmKey=" + this_.processKey,
                type: "get",
                dataType: "json",
                success: function (res) {
                    if (res.success) {
                        this_.targetTableData = res.obj;
                    }
                }
            })
        },
        findSelectedProcess: function (processArray) {
            let processKey = "";
            processArray.forEach(function (item, index) {
                if (item.selected) {
                    processKey = item.processKey;
                    return false;
                }
            });
            return processKey;
        },
        handleRefresh: function () {
            let target = {
                headTarget: JSON.stringify(this.targetTableData.head),
                itemTarget: JSON.stringify(this.targetTableData.items),
                processKey: this.processKey
            };
            this.$emit("refresh",target);
        },
        getTargetData:function () {
            return {
                headTarget: JSON.stringify(this.targetTableData.head),
                itemTarget: JSON.stringify(this.targetTableData.items),
                processKey: this.processKey
            }
        },
        setTargetData:function (data) {
            this.targetTableData = $.extend({},this.targetTableData,data);
        }
    }
});