/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.authobj.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.authobj.dao.TmFunAuthDao;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthHead;
import com.biz.eisp.mdm.authobj.entity.TmFunctionFunEntity;
import com.biz.eisp.mdm.authobj.entity.TmRoleFuncAuthobjEntity;
import com.biz.eisp.mdm.authobj.service.TmFunAuthService;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmFunAuthService")
@Transactional
public class TmFunAuthServiceImpl
extends BaseServiceImpl
implements TmFunAuthService {
    @Autowired
    private TmFunAuthDao tmFunAuthDao;

    @Override
    public List<TmFunAuthEntity> getTmFunAuthList(String functionId) {
        return this.findByProperty(TmFunAuthEntity.class, "tmFunction.id", functionId);
    }

    @Override
    public void deleteFunctionFun(String id) {
        TmFunctionFunEntity entity = this.get(TmFunctionFunEntity.class, (Serializable)((Object)id));
        String hql = " from TmFunAuthEntity a where a.funCode = ? and a.tmFunction.id=? ";
        List functionFunEntities = this.findByHql(hql, entity.getFunCode(), entity.getFunId());
        this.deleteAllEntity(functionFunEntities);
        this.delete(entity);
    }

    @Override
    public List<TmFunctionFunEntity> findFunAuthListByFunId(String functionId) {
        String sql = " select * from tm_r_function_fun where fun_id = ? ";
        return this.findBySql(TmFunctionFunEntity.class, sql, functionId);
    }

    @Override
    public AjaxJson saveOrUpdateFunctionFun(TmFunctionFunEntity tmFunctionFunEntity, AjaxJson ajaxJson) {
        if (StringUtil.isBlank((String)tmFunctionFunEntity.getId())) {
            tmFunctionFunEntity.setId(null);
        }
        this.saveOrUpdate(tmFunctionFunEntity);
        return ajaxJson;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AjaxJson saveOrUpdateItem(TmFunAuthHead head, AjaxJson ajaxJson) {
        TmFunctionEntity functionEntity = this.get(TmFunctionEntity.class, (Serializable)((Object)head.getFunId()));
        String hql = " from TmFunAuthEntity a where a.funCode = ? and a.tmFunction.id=? ";
        ArrayList oldList = this.findByHql(hql, head.getFunCode(), head.getFunId());
        oldList = oldList == null ? new ArrayList() : oldList;
        Map<String, TmFunAuthEntity> mapOld = oldList.stream().collect(Collectors.toMap(TmFunAuthEntity::getAuthobj, item -> item));
        List<TmFunAuthEntity> items = head.getItems();
        ArrayList<TmFunAuthEntity> addList = new ArrayList<TmFunAuthEntity>();
        ArrayList delList = new ArrayList();
        if (CollectionUtil.listEmpty(items)) {
            if (CollectionUtil.listNotEmptyNotSizeZero(oldList)) {
                this.deleteAllEntity(oldList);
                return ajaxJson;
            }
        } else {
            for (TmFunAuthEntity tmFunAuthEntity : items) {
                if (mapOld.containsKey(tmFunAuthEntity.getAuthobj())) {
                    mapOld.remove(tmFunAuthEntity.getAuthobj());
                    continue;
                }
                tmFunAuthEntity.setId(null);
                tmFunAuthEntity.setTmFunction(functionEntity);
                addList.add(tmFunAuthEntity);
            }
        }
        if (!mapOld.isEmpty()) {
            for (Map.Entry entry : mapOld.entrySet()) {
                delList.add(entry.getValue());
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(delList)) {
            void var11_15;
            this.deleteAllEntity(delList);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" SELECT distinct tmrrfa.*  FROM tm_r_function_authobj tmrfa           JOIN tm_r_role_function tmrrf on tmrfa.FUNCTION_ID = tmrrf.FUNCTION_ID          JOIN tm_r_role_func_authobj tmrrfa                    ON tmrrfa.role_function_id = tmrrf.id  where tmrfa.FUNCTION_ID = ?   and tmrfa.fun_code = ? ");
            stringBuffer.append(" and tmrrfa.AUTHOBJ in (");
            boolean bl = false;
            while (var11_15 < delList.size()) {
                if (var11_15 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("'" + ((TmFunAuthEntity)delList.get((int)var11_15)).getAuthobj() + "'");
                ++var11_15;
            }
            stringBuffer.append(")");
            List<TmRoleFuncAuthobjEntity> list = this.findBySql(TmRoleFuncAuthobjEntity.class, stringBuffer.toString(), head.getFunId(), head.getFunCode());
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                this.deleteAllEntity(list);
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            this.batchSave(addList);
        }
        return ajaxJson;
    }

    @Override
    public List<KnlDictDataEntity> getTmDictData(String dictTypeValue, String authObj) {
        Map<Object, Object> dataMap = DictUtil.getDictMap(dictTypeValue);
        ArrayList<KnlDictDataEntity> dictDataList = new ArrayList<KnlDictDataEntity>();
        if (dataMap != null && dataMap.size() > 0 && dataMap != null && dataMap.size() > 0) {
            dataMap.forEach((k, v) -> {
                KnlDictDataEntity entity = (KnlDictDataEntity)v;
                dictDataList.add(entity);
            });
        }
        return dictDataList;
    }

    @Override
    public void saveFunAuth(TmFunctionAuthVo funAuth) {
        String functionId = funAuth.getTmFunction().getId();
        String authobj = funAuth.getAuthobj();
        List<TmFunAuthEntity> authList = this.findByProperty(TmFunAuthEntity.class, "tmFunction.id", functionId);
        this.deleteAllEntity(authList);
        if (StringUtil.isNotEmpty((String)authobj)) {
            String[] authObjs = authobj.split(",");
            StringBuffer bufs = new StringBuffer();
            for (String auth : authObjs) {
                String hql;
                TmFunAuthEntity tmFunAuth;
                if (bufs.length() > 0) {
                    bufs.append(",");
                }
                if ((tmFunAuth = this.getUniqueByHql(TmFunAuthEntity.class, hql = "from TmFunAuthEntity where tmFunction.id=? and authobj=?", functionId, auth)) == null || StringUtil.isEmpty(tmFunAuth.getId())) {
                    tmFunAuth = new TmFunAuthEntity();
                    tmFunAuth.setAuthobj(auth);
                    tmFunAuth.setTmFunction(funAuth.getTmFunction());
                    this.save(tmFunAuth);
                    continue;
                }
                bufs.append("'").append(auth).append("'");
            }
            String sql = "DELETE FROM TM_R_ROLE_FUNC_AUTHOBJ WHERE ROLE_FUNCTION_ID IN (SELECT TF.ID FROM TM_R_ROLE_FUNCTION TF WHERE TF.FUNCTION_ID=?) AND AUTHOBJ NOT IN(?)";
            this.executeSql(sql, functionId, bufs.toString());
        }
    }

    @Override
    public List<TmFunAuthEntity> getTmFunAuthListByRoleFunc(String roleId, String funcId) {
        TmRoleFunctionEntity tmRoleFunctionEntity;
        List<TmRoleFuncAuthobjEntity> Authobjs;
        SimpleExpression funcCrt;
        ArrayList<String> authObjCodes = new ArrayList<String>();
        ArrayList<TmFunAuthEntity> funAuths = new ArrayList<TmFunAuthEntity>();
        SimpleExpression roleCrt = Restrictions.eq((String)"tmRole.id", (Object)roleId);
        List<TmRoleFunctionEntity> roleFuncs = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{roleCrt, funcCrt = Restrictions.eq((String)"tmFunction.id", (Object)funcId)});
        if (StringUtil.isNotEmpty(roleFuncs) && roleFuncs.size() > 0 && StringUtil.isNotEmpty(Authobjs = this.findByProperty(TmRoleFuncAuthobjEntity.class, "tmRoleFunction.id", (tmRoleFunctionEntity = roleFuncs.get(0)).getId())) && Authobjs.size() > 0) {
            for (TmRoleFuncAuthobjEntity authObj : Authobjs) {
                authObjCodes.add(authObj.getAuthobj());
            }
            String authObjCodesStr = StringUtil.getInSqlStr(authObjCodes);
            List<TmFunAuthEntity> tempList = this.tmFunAuthDao.findFunAuthEntityByAuthobjCodes(authObjCodesStr);
            funAuths.addAll(tempList);
        }
        return funAuths;
    }

    @Override
    public List<KnlDictDataEntity> getTmFunAuthValueByRoleFunc(String roleId, String funcId, String authObj) {
        TmRoleFunctionEntity functionEntity = null;
        ArrayList<KnlDictDataEntity> dictDatas = new ArrayList();
        List<KnlDictDataEntity> dictDatasParent = DictUtil.getDictList("authobj");
        String parentId = "";
        if (CollectionUtil.listNotEmptyNotSizeZero(dictDatasParent)) {
            for (KnlDictDataEntity entity : dictDatasParent) {
                if (!StringUtil.equals(entity.getDictCode(), authObj)) continue;
                parentId = entity.getId();
                break;
            }
        }
        if (StringUtil.isNotEmpty((String)parentId)) {
            dictDatas = DictUtil.getDictByParentId(parentId);
        }
        SimpleExpression cr1 = Restrictions.eq((String)"tmRole.id", (Object)roleId);
        SimpleExpression cr2 = Restrictions.eq((String)"tmFunction.id", (Object)funcId);
        List<TmRoleFunctionEntity> functionEntitys = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{cr1, cr2});
        if (!CollectionUtils.isEmpty(functionEntitys)) {
            functionEntity = functionEntitys.get(0);
        }
        String hql = "from TmRoleFuncAuthobjEntity where tmRoleFunction.id=? and authobj=?";
        List<Object> authobjVlues = new ArrayList();
        if (functionEntity != null) {
            authobjVlues = this.findByHql(hql, functionEntity.getId(), authObj);
        }
        Map<Object, Object> auMap = new HashMap();
        if (CollectionUtil.listNotEmptyNotSizeZero(authobjVlues)) {
            auMap = authobjVlues.stream().filter(dd -> StringUtil.isNotEmpty((String)dd.getAuthobjValue())).collect(Collectors.groupingBy(TmRoleFuncAuthobjEntity::getAuthobjValue));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
            HashMap finalAuMap = auMap;
            dictDatas.stream().filter(dt -> finalAuMap.containsKey(dt.getDictCode())).forEach(authobjEntity -> authobjEntity.setStatus(Globals.ZERO));
        }
        return dictDatas;
    }

    @Override
    public void saveFunAuthValue(String roleId, String funcId, String authObj, String authCodes, String funCode) {
        String hql = "from TmRoleFunctionEntity where tmRole.id=? and tmFunction.id=?";
        List roleFuncs = this.findByHql(hql, roleId, funcId);
        if (!CollectionUtils.isEmpty(roleFuncs) && roleFuncs.size() > 0) {
            TmRoleFunctionEntity roleFunctionEntity = (TmRoleFunctionEntity)roleFuncs.get(0);
            String sql = "delete from tm_r_role_func_authobj where role_function_id=? and authobj=? and fun_code =? ";
            this.executeSql(sql, roleFunctionEntity.getId(), authObj, funCode);
            TmRoleFuncAuthobjEntity authobjEntity = null;
            if (StringUtil.isNotEmpty((String)authCodes)) {
                for (String authCode : authCodes.split(",")) {
                    authobjEntity = new TmRoleFuncAuthobjEntity();
                    authobjEntity.setTmRoleFunction(roleFunctionEntity);
                    authobjEntity.setAuthobj(authObj);
                    authobjEntity.setAuthobjValue(authCode);
                    authobjEntity.setFunCode(funCode);
                    this.save(authobjEntity);
                }
            }
        }
    }
}

