/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.position.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import java.util.List;
import java.util.Map;

public class TmPositionEventHandler
extends ImpEventHandler<TmPositionVo> {
    private TmPositionService tmPositionService = (TmPositionService)ApplicationContextUtils.getContext().getBean("tmPositionService");

    @Override
    public void endRow(Map<String, Object> row, TmPositionVo bean) throws ValidateException {
        try {
            EuPage page = new EuPage();
            if (null != bean.getPositionLevel() && 0 == bean.getPositionLevel()) {
                bean.setPositionLevel(null);
            }
            this.setRelationValues(bean);
            this.tmPositionService.saveTmPosition(bean, page);
        }
        catch (Exception e) {
            this.addError("\u7b2c" + this.getRowNumber() + "\u884c\u9047\u5230\u9519\u8bef:" + e.getMessage());
            e.printStackTrace();
        }
        this.setSuccNum(this.getSuccNum() + 1);
    }

    private void setRelationValues(TmPositionVo bean) {
        if (StringUtil.isNotEmpty((String)bean.getRoleNames())) {
            String roleIds = this.getRoleIds(bean.getRoleNames());
            bean.setRoleIds(roleIds);
        }
        if (StringUtil.isNotEmpty((String)bean.getWorkflowRoleNames())) {
            String actRoleIds = this.getActRoleIds(bean.getWorkflowRoleNames());
            bean.setWorkflowRoleIds(actRoleIds);
        }
    }

    private String getRoleIds(String roleCodes) {
        if (StringUtil.isNotEmpty((String)roleCodes)) {
            roleCodes = roleCodes.replaceAll(",", "','");
            roleCodes = "'" + roleCodes + "'";
            String sql = "SELECT group_concat(distinct id separator ',') AS roleIds FROM tm_role WHERE role_code in ( " + roleCodes + " )";
            List<TmPositionVo> list = this.tmPositionService.findBySql(TmPositionVo.class, sql, new Object[0]);
            if (list != null) {
                return list.get(0).getRoleIds();
            }
        }
        return null;
    }

    private String getActRoleIds(String roleCodes) {
        if (StringUtil.isNotEmpty((String)roleCodes)) {
            roleCodes = roleCodes.replaceAll(",", "','");
            roleCodes = "'" + roleCodes + "'";
            String sql = "SELECT group_concat(distinct id separator ',') AS workflowRoleIds FROM tm_act_role WHERE role_code in ( " + roleCodes + " )";
            List<TmPositionVo> list = this.tmPositionService.findBySql(TmPositionVo.class, sql, new Object[0]);
            if (list != null) {
                return list.get(0).getWorkflowRoleIds();
            }
        }
        return null;
    }
}

