/***********************************************************************************/
/***********************************************************************************/
/************************客户业务组改造脚本********************************************/
/***********************************************************************************/
/***********************************************************************************

--添加客户业务组编码数据字典。
INSERT INTO tm_dict_data(ID, dict_code,dict_value,dict_desc,parent_id,dict_type_code,create_date,create_name,update_date,update_name,is_system)
VALUES(lower(sys_guid()), 'business_group', '业务组', '业务组编码',NULL,'natural_key',SYSDATE,'系统初始化',SYSDATE,'系统初始化',0);

--保存规则
INSERT INTO tb_numrule_config(
  ID,
  RULE,
  RULE_DESC,
  NATURAL_KEY,
  CONFIG_DATE,
  NUM_VALUE,
  CREATE_DATE,
  CREATE_NAME,
  UPDATE_DATE,
  UPDATE_NAME
) 
SELECT
  lower(sys_guid()) AS ID,
  'prefix=bg;length=10' AS RULE,
  '客户业务组编码' AS rule_desc,
  'business_group' AS natural_key,
  SYSDATE AS config_date,
  0 AS num_value,
  SYSDATE AS create_date,
  '系统初始化' AS create_name,
   SYSDATE AS update_date,
  '系统初始化' AS update_name
FROM dual;



-- 添加组织字段信息
alter table TM_R_CUST_POS_BG
  storage
  (
    next 1
  )
;
-- Add/modify columns 
alter table TM_R_CUST_POS_BG add org_id varchar2(32);
-- Add comments to the columns 
comment on column TM_R_CUST_POS_BG.org_id
  is '组织id';
  
CREATE TABLE tm_r_cust_pos_bg_detail (
id VARCHAR2(32) NOT NULL,
detail_code VARCHAR2(50) NULL,
detail_name VARCHAR2(200) NULL,
business_group VARCHAR2(50) NULL,
type_code VARCHAR2(50) NULL,
type_name VARCHAR2(100) NULL,
PRIMARY KEY (id) 
)
NOCOMPRESS 
NOPARALLEL ;

COMMENT ON TABLE tm_r_cust_pos_bg_detail IS '客户-职位-业务 明细信息';
COMMENT ON COLUMN tm_r_cust_pos_bg_detail.id IS '逻辑主键id';
COMMENT ON COLUMN tm_r_cust_pos_bg_detail.detail_code IS '明细业务数据编码，如产品编码';
COMMENT ON COLUMN tm_r_cust_pos_bg_detail.detail_name IS '明细业务数据名称，如：产品名称';
COMMENT ON COLUMN tm_r_cust_pos_bg_detail.business_group IS '业务组编码，对应tm_r_cust_pos_bg的business_group字段';
COMMENT ON COLUMN tm_r_cust_pos_bg_detail.type_code IS '业务类型编码，对应数据字典tm_cust_pos_bg_detail_type编码值';
COMMENT ON COLUMN tm_r_cust_pos_bg_detail.type_name IS '业务类型名称，冗余字段，对应数据字典tm_cust_pos_bg_detail_type名称值';
