/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.interceptors;

import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.mdm.authobj.util.AuthObjHandler;
import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.springframework.stereotype.Component;

@Component
public class HibernateEntityInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 1L;

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        for (int i = 0; i < propertyNames.length; ++i) {
            if ("createDate".equals(propertyNames[i])) {
                if (!this.isEmpty(state[i])) continue;
                state[i] = new Date();
                continue;
            }
            if ("createName".equals(propertyNames[i])) {
                if (!this.isEmpty(state[i])) continue;
                state[i] = ResourceUtil.getCreateName();
                continue;
            }
            if ("updateDate".equals(propertyNames[i])) {
                if (!this.isEmpty(state[i])) continue;
                state[i] = new Date();
                continue;
            }
            if ("updateName".equals(propertyNames[i])) {
                if (!this.isEmpty(state[i])) continue;
                state[i] = ResourceUtil.getCreateName();
                continue;
            }
            if (!"createPosId".equals(propertyNames[i]) || !this.isEmpty(state[i])) continue;
            state[i] = ResourceUtil.getCurrPosition().getId();
        }
        return true;
    }

    private boolean checkSession() {
        boolean b = true;
        HttpServletRequest request = ContextHolderUtils.getRequest();
        if (request == null) {
            b = false;
        } else {
            HttpSession session = request.getSession();
            if (session == null) {
                b = false;
            }
        }
        return b;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        for (int i = 0; i < propertyNames.length; ++i) {
            if ("updateDate".equals(propertyNames[i])) {
                if ("string".equals(types[i].getName())) continue;
                currentState[i] = new Date();
                continue;
            }
            if ("updateName".equals(propertyNames[i])) {
                if (this.checkSession()) {
                    currentState[i] = ResourceUtil.getCreateName();
                    continue;
                }
                if (!this.isEmpty((Object)propertyNames[i])) continue;
                currentState[i] = ResourceUtil.getCreateName();
                continue;
            }
            if (!"updatePosId".equals(propertyNames[i])) continue;
            if (this.checkSession()) {
                currentState[i] = ResourceUtil.getCurrPosition().getId();
                continue;
            }
            if (!this.isEmpty((Object)propertyNames[i])) continue;
            currentState[i] = ResourceUtil.getCurrPosition().getId();
        }
        return true;
    }

    public boolean isEmpty(Object object) {
        return object == null || object.equals("") || object.equals("null");
    }

    public String onPrepareStatement(String sql) {
        return AuthObjHandler.executeAuthHandle((String)sql);
    }
}

