/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.utils;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

/*
 * Exception performing whole class analysis ignored.
 */
public class PinyinUtil {
    public static String[] stringToPinyin(String src) {
        return PinyinUtil.stringToPinyin((String)src, (boolean)false, null);
    }

    public static String[] stringToPinyin(String src, String separator) {
        return PinyinUtil.stringToPinyin((String)src, (boolean)true, (String)separator);
    }

    public static String[] stringToPinyin(String src, boolean isPolyphone, String separator) {
        if ("".equals(src) || null == src) {
            return null;
        }
        char[] srcChar = src.toCharArray();
        int srcCount = srcChar.length;
        String[] srcStr = new String[srcCount];
        for (int i = 0; i < srcCount; ++i) {
            srcStr[i] = PinyinUtil.charToPinyin((char)srcChar[i], (boolean)isPolyphone, (String)separator);
        }
        return srcStr;
    }

    public static String charToPinyin(char src, boolean isPolyphone, String separator) {
        StringBuffer tempPinying;
        block6: {
            HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
            defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            tempPinying = new StringBuffer();
            if (src > '\u0080') {
                try {
                    String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)src, (HanyuPinyinOutputFormat)defaultFormat);
                    if (isPolyphone && null != separator) {
                        for (int i = 0; i < strs.length; ++i) {
                            tempPinying.append(strs[i]);
                            if (strs.length == i + 1) continue;
                            tempPinying.append(separator);
                        }
                        break block6;
                    }
                    tempPinying.append(strs[0]);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
            } else {
                tempPinying.append(src);
            }
        }
        return tempPinying.toString();
    }

    public static String hanziToPinyin(String hanzi) {
        return PinyinUtil.hanziToPinyin((String)hanzi, (String)" ");
    }

    public static String hanziToPinyin(String hanzi, String separator) {
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        String pinyingStr = "";
        try {
            pinyingStr = PinyinHelper.toHanyuPinyinString((String)hanzi, (HanyuPinyinOutputFormat)defaultFormat, (String)separator);
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return pinyingStr;
    }

    public static String stringArrayToString(String[] str, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length; ++i) {
            sb.append(str[i]);
            if (str.length == i + 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String stringArrayToString(String[] str) {
        return PinyinUtil.stringArrayToString((String[])str, (String)"");
    }

    public static String charArrayToString(char[] ch, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ch.length; ++i) {
            sb.append(ch[i]);
            if (ch.length == i + 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String charArrayToString(char[] ch) {
        return PinyinUtil.charArrayToString((char[])ch, (String)" ");
    }

    public static char[] getHeadByChar(char src, boolean isCapital) {
        if (src <= '\u0080') {
            return new char[]{src};
        }
        String[] pinyingStr = PinyinHelper.toHanyuPinyinStringArray((char)src);
        int polyphoneSize = pinyingStr.length;
        char[] headChars = new char[polyphoneSize];
        int i = 0;
        for (String s : pinyingStr) {
            char headChar = s.charAt(0);
            headChars[i] = isCapital ? Character.toUpperCase(headChar) : headChar;
            ++i;
        }
        return headChars;
    }

    public static char[] getHeadByChar(char src) {
        return PinyinUtil.getHeadByChar((char)src, (boolean)true);
    }

    public static String[] getHeadByString(String src) {
        return PinyinUtil.getHeadByString((String)src, (boolean)true);
    }

    public static String[] getHeadByString(String src, boolean isCapital) {
        return PinyinUtil.getHeadByString((String)src, (boolean)isCapital, null);
    }

    public static String[] getHeadByString(String src, boolean isCapital, String separator) {
        char[] chars = src.toCharArray();
        String[] headString = new String[chars.length];
        int i = 0;
        for (char ch : chars) {
            char[] chs = PinyinUtil.getHeadByChar((char)ch, (boolean)isCapital);
            StringBuffer sb = new StringBuffer();
            if (null != separator) {
                int j = 1;
                for (char ch1 : chs) {
                    sb.append(ch1);
                    if (j != chs.length) {
                        sb.append(separator);
                    }
                    ++j;
                }
            } else {
                sb.append(chs[0]);
            }
            headString[i] = sb.toString();
            ++i;
        }
        return headString;
    }

    public static String getPinYin(String src) {
        char[] t1 = null;
        t1 = src.toCharArray();
        String[] t2 = new String[t1.length];
        HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
        t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        t3.setVCharType(HanyuPinyinVCharType.WITH_V);
        String t4 = "";
        int t0 = t1.length;
        try {
            for (int i = 0; i < t0; ++i) {
                if (Character.toString(t1[i]).matches("[\\u4E00-\\u9FA5]+")) {
                    t2 = PinyinHelper.toHanyuPinyinStringArray((char)t1[i], (HanyuPinyinOutputFormat)t3);
                    t4 = t4 + t2[0];
                    continue;
                }
                t4 = t4 + Character.toString(t1[i]);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return t4;
    }

    public static String getPinYinHeadChar(String str) {
        String convert = "";
        for (int j = 0; j < str.length(); ++j) {
            char word = str.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            convert = pinyinArray != null ? convert + pinyinArray[0].charAt(0) : convert + word;
        }
        return convert;
    }

    public static String getCnASCII(String cnStr) {
        StringBuffer strBuf = new StringBuffer();
        byte[] bGBK = cnStr.getBytes();
        for (int i = 0; i < bGBK.length; ++i) {
            strBuf.append(Integer.toHexString(bGBK[i] & 0xFF));
        }
        return strBuf.toString();
    }

    public static String converterToFirstSpell(String chines) {
        String pinyinName = "";
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < nameChar.length; ++i) {
            if (nameChar[i] > '\u0080') {
                try {
                    pinyinName = pinyinName + PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pinyinName = pinyinName + nameChar[i];
        }
        return pinyinName;
    }

    public static String converterToSpell(String chines) {
        String pinyinName = "";
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < nameChar.length; ++i) {
            if (nameChar[i] > '\u0080') {
                try {
                    pinyinName = pinyinName + PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0];
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pinyinName = pinyinName + nameChar[i];
        }
        return pinyinName;
    }

    public static String makeStringByStringSet(Set<String> stringSet) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        for (String s : stringSet) {
            if (i == stringSet.size() - 1) {
                str.append(s);
            } else {
                str.append(s + ",");
            }
            ++i;
        }
        return str.toString().toLowerCase();
    }

    public static Set<String> getPinyin(String src) {
        if (src != null && !src.trim().equalsIgnoreCase("")) {
            char[] srcChar = src.toCharArray();
            HanyuPinyinOutputFormat hanYuPinOutputFormat = new HanyuPinyinOutputFormat();
            hanYuPinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            hanYuPinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            hanYuPinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
            String[][] temp = new String[src.length()][];
            for (int i = 0; i < srcChar.length; ++i) {
                char c = srcChar[i];
                if (String.valueOf(c).matches("[\\u4E00-\\u9FA5]+")) {
                    try {
                        temp[i] = PinyinHelper.toHanyuPinyinStringArray((char)srcChar[i], (HanyuPinyinOutputFormat)hanYuPinOutputFormat);
                    }
                    catch (BadHanyuPinyinOutputFormatCombination e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                temp[i] = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' ? new String[]{String.valueOf(srcChar[i])} : new String[]{""};
            }
            String[] pingyinArray = PinyinUtil.Exchange((String[][])temp);
            HashSet<String> pinyinSet = new HashSet<String>();
            for (int i = 0; i < pingyinArray.length; ++i) {
                pinyinSet.add(pingyinArray[i]);
            }
            return pinyinSet;
        }
        return null;
    }

    public static String[] Exchange(String[][] strJaggedArray) {
        String[][] temp = PinyinUtil.DoExchange((String[][])strJaggedArray);
        return temp[0];
    }

    private static String[][] DoExchange(String[][] strJaggedArray) {
        int len = strJaggedArray.length;
        if (len >= 2) {
            int len1 = strJaggedArray[0].length;
            int len2 = strJaggedArray[1].length;
            int newlen = len1 * len2;
            String[] temp = new String[newlen];
            int Index = 0;
            for (int i = 0; i < len1; ++i) {
                for (int j = 0; j < len2; ++j) {
                    temp[Index] = strJaggedArray[0][i] + strJaggedArray[1][j];
                    ++Index;
                }
            }
            String[][] newArray = new String[len - 1][];
            for (int i = 2; i < len; ++i) {
                newArray[i - 1] = strJaggedArray[i];
            }
            newArray[0] = temp;
            return PinyinUtil.DoExchange((String[][])newArray);
        }
        return strJaggedArray;
    }
}

