<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div id="product_info_List" class="easyui-layout" fit="true">
    <div region="center">
        <t:datagrid  name="productInfoList" fitColumns="false" extendTableName="${extendTableName}"
                actionUrl="tmProductInfoController.do?findProductInfoMainGrid" idField="id"  queryMode="group">
            <t:dgToolBar title="新增" operationCode="add" url="tmProductInfoController.do?goSaveOrUpdateForm&optype=0" icon="icon-add" funname="add" width="380" height="400"></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="edit" url="tmProductInfoController.do?goSaveOrUpdateForm&optype=1" icon="icon-edit" funname="update" width="380" height="400"></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" url="tmProductInfoController.do?goSaveOrUpdateForm&optype=1" icon="icon-edit" funname="detail"></t:dgToolBar>
            <t:dgToolBar title="启用" operationCode="start" icon="icon-start" url="tmProductInfoController.do?startOrStop" funname="startOrStop('009')"></t:dgToolBar>
            <t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url="tmProductInfoController.do?startOrStop" funname="startOrStop('003')"></t:dgToolBar>
            <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn" onclick="importDataByXml({impName:'tmProductInfo', gridName:'productInfoList'})" ></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut" url="tmProductInfoController.do?exportXls" funname="excelExport"></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="tmProductInfoController.do?delProductInfo" funname="deleteALLSelect3"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log"   url="tmCustomerController.do?goTmLogDetailMain" funname="detailLog" width="1200" height="460"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>
<c:if test="${not empty includeJsp}">
    <jsp:include page="${includeJsp}" flush="true"></jsp:include>
</c:if>
<script>

    function uploadPic(id){
        createwindow("图片上传",'tmProductInfoController.do?goUploadProductPic&id='+id,440,400,{});
    }

    //删除
    function deleteALLSelect3(title, url){
        var rowsData = $('#productInfoList').datagrid('getSelections');
        var rowData = $('#productInfoList').datagrid('getSelected');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择产品');
            return;
        }
        if (rowsData.length > 1) {
            tip('请选择一条记录再编辑');
            return;
        }
        var ids = [];
        var rows = $('#productInfoList').datagrid('getSelections');
        if(rows.length > 0){
            $.dialog.confirm('是否删除选中数据？',function(r){
                if(r){
                    for(var i = 0; i < rows.length; i++){
                        ids.push(rows[i].id);
                    }
                    $.ajax({
                        url:url,
                        type:'post',
                        data:{
                            ids:ids.join(',')
                        },
                        cache:false,
                        success:function(data){
                            var d = data;
                            var msg = d.msg;
                            if(d.success){
                                tip(msg);
                                for(var i = 0;i<rows.length ;i++){
                                    var index = $('#productInfoList').datagrid('getRowIndex',rows[i]);
                                    $("#productInfoList").datagrid('deleteRow',index);
                                }
                                ids='';
                            }else{
                                tip(msg);
                                return;
                            }
                        }
                    });
                }
            });
        }else{
            tip("请选择要删除的数据！");
        }
    }

    //启用停用
    function startOrStop(flag){
        var tmUseTarget = $("#productInfoList").datagrid('getSelected');
        if(tmUseTarget == null){
            tip("请选择一条要操作的数据");
            return;
        }
        var tipmMsg = "";
        if(flag == "009"){
            tipmMsg = "确定要启用该数据吗?"
        }else{
            tipmMsg = "确定要停用该数据吗?"
        }
        $.messager.confirm('操作提示',tipmMsg,function(r){
            if (r){
                $.ajax({
                    type : "POST",
                    url : "tmProductInfoController.do?startOrStop",
                    data : {
                        "id" : tmUseTarget.id,
                        "enableStatus": flag
                    },
                    dataType : "json",
                    success : function(data) {
                        tip(data.msg);
                        $("#productInfoList").datagrid('reload');
                    },
                    error:function(){
                        tip("服务器异常，请稍后再试");
                    }
                });
            }
        });
    }
</script>