/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.customer.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.SqlUtil;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.entity.TmRoleFuncAuthobjEntity;
import com.biz.eisp.mdm.authobj.util.AuthUtil;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.dao.TmCustomerDao;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBgDetailEntity;
import com.biz.eisp.mdm.customer.service.TmCustomerDelExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerSearchAuthExpand;
import com.biz.eisp.mdm.customer.service.TmCustomerSearchExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.customer.transformer.TmCustomerVoToTmCustomerEntity;
import com.biz.eisp.mdm.customer.util.CustomerLogMsgUtil;
import com.biz.eisp.mdm.customer.vo.QueryTmCustomerVo;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmCustomerService")
@Transactional
public class TmCustomerServiceImpl
extends BaseServiceImpl
implements TmCustomerService {
    @Autowired
    private TmCustomerDao tmCustomerDao;
    @Autowired(required=false)
    private TmCustomerSearchExtendService tmCustomerSearchExtendService;
    @Autowired(required=false)
    private TmCustomerSearchAuthExpand tmCustomerSearchAuthExpand;
    @Autowired(required=false)
    private TmCustomerExtendService tmCustomerExtendService;
    @Autowired(required=false)
    private TmCustomerDelExtendService tmCustomerDelExtendService;

    @Override
    public List<TmCustomerVo> findTmCustomerList(TmCustomerVo customerVo, Page page, String clickFunctionId) {
        String ids;
        List<TmCustomerVo> vos;
        String sqlTemp;
        List<TmCustomerVo> results;
        List<TmFunAuthEntity> funAuthEntities;
        String sql = "";
        if (this.tmCustomerSearchExtendService != null) {
            sql = this.tmCustomerSearchExtendService.buildSearchSql(customerVo);
            if (StringUtil.isEmpty(sql)) {
                sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, customerVo);
                sql = this.tmCustomerSearchExtendService.extendSearchSql(customerVo, sql);
            }
            return this.tmCustomerDao.findTmCustomerList(customerVo, page, sql);
        }
        sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, customerVo);
        sql = this.appendCustomerCondition(sql, customerVo, Globals.Table_CUSTOMER);
        UserRedis userRedis = UserUtils.getUser();
        String dataBase = ResourceUtil.getSysConfigProperty("dataBase");
        StringBuffer stringBuffer = new StringBuffer();
        if (Globals.MYSQL.equals(dataBase) && StringUtil.isNotBlank((String)clickFunctionId) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername()) && CollectionUtil.listNotEmptyNotSizeZero(funAuthEntities = this.findBySql(TmFunAuthEntity.class, AuthUtil.sqlvew, Globals.VIEW, clickFunctionId))) {
            List<TmRoleFuncAuthobjEntity> valList = this.findBySql(TmRoleFuncAuthobjEntity.class, AuthUtil.sqlval, clickFunctionId, userRedis.getId(), Globals.VIEW);
            if (CollectionUtil.listNotEmptyNotSizeZero(valList)) {
                HashMap<String, List<TmRoleFuncAuthobjEntity>> auMap = new HashMap<String, List<TmRoleFuncAuthobjEntity>>();
                valList.stream().collect(Collectors.groupingBy(TmRoleFuncAuthobjEntity::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put((String)parentId, (List<TmRoleFuncAuthobjEntity>)list));
                stringBuffer.append("  and ( ");
                if (AuthUtil.checAll(valList)) {
                    stringBuffer.append("1=1");
                } else {
                    Map<Object, Object> auValMap;
                    List items;
                    boolean flagOr = false;
                    if (auMap.containsKey("position")) {
                        flagOr = true;
                        items = (List)auMap.get("position");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(TmRoleFuncAuthobjEntity::getAuthobjValue, item -> item));
                        stringBuffer.append("  EXISTS( select aa.id from tm_r_cust_pos_bg aa left join tm_position bb on aa.POSITION_ID = bb.id where t.id = aa.CUSTOMER_ID ");
                        if (auValMap.containsKey("40")) {
                            stringBuffer.append(" and bb.code_rule like '" + userRedis.getPoscoderule() + "%' ");
                        } else if (auValMap.containsKey("50")) {
                            stringBuffer.append(" and bb.id = '" + userRedis.getPosId() + "' ");
                        }
                        stringBuffer.append(")");
                    }
                    if (auMap.containsKey("org")) {
                        items = (List)auMap.get("org");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(TmRoleFuncAuthobjEntity::getAuthobjValue, item -> item));
                        if (flagOr) {
                            stringBuffer.append(" or ");
                        }
                        flagOr = true;
                        stringBuffer.append(" EXISTS( select b.id from tm_org b where t.org_id = b.id  ");
                        if (auValMap.containsKey("20")) {
                            stringBuffer.append(" and b.code_rule like '" + userRedis.getOrgcoderule() + "%' ");
                        } else if (auValMap.containsKey("30")) {
                            stringBuffer.append(" and b.id = '" + userRedis.getOrgId() + "' ");
                        }
                        stringBuffer.append(")");
                    }
                    if (null != this.tmCustomerSearchAuthExpand) {
                        String expandSql = this.tmCustomerSearchAuthExpand.getAuthExpand(auMap, userRedis, flagOr, stringBuffer);
                        stringBuffer.append(expandSql);
                    }
                }
                stringBuffer.append(" )");
            } else {
                stringBuffer.append(" and 1=2");
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(results = this.tmCustomerDao.findTmCustomerList(customerVo, page, sql = sql.replaceFirst("1=1", sqlTemp = " 1=1 " + stringBuffer.toString()))) && CollectionUtil.listNotEmptyNotSizeZero(vos = this.tmCustomerDao.findTmCustomerListChildren(SqlUtil.setSqlIn((ids = results.stream().collect(Collectors.mapping(TmCustomerVo::getId, Collectors.joining(",")))).split(","), "t1.customer_id", true, ""), this.appendCustomerConditionSplit()))) {
            Map<String, List<TmCustomerVo>> map = vos.stream().collect(Collectors.groupingBy(TmCustomerVo::getId));
            results.stream().map(u -> this.toCustomer((List)map.get(u.getId()), (TmCustomerVo)u)).collect(Collectors.toList());
        }
        return results;
    }

    private TmCustomerVo toCustomer(List<TmCustomerVo> customers, TmCustomerVo result) {
        if (CollectionUtil.listNotEmptyNotSizeZero(customers)) {
            result.setPositionId(customers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getPositionId())).collect(Collectors.mapping(TmCustomerVo::getPositionId, Collectors.joining(","))));
            result.setBusinessGroup(customers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getBusinessGroup())).collect(Collectors.mapping(TmCustomerVo::getBusinessGroup, Collectors.joining(","))));
            result.setDockUserName(customers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getDockUserName())).collect(Collectors.mapping(TmCustomerVo::getDockUserName, Collectors.joining(","))));
            result.setDockPosition(customers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getDockPosition())).collect(Collectors.mapping(TmCustomerVo::getDockPosition, Collectors.joining(","))));
        }
        return result;
    }

    public String appendCustomerCondition(String sql, TmCustomerVo customerVo, String table) {
        String sqlJoin = "";
        String sqlOn = "";
        String sqlWhere = "";
        if (StringUtil.isNotEmpty((String)customerVo.getId())) {
            sqlWhere = " and (t.id='" + customerVo.getId() + "'";
        }
        if (StringUtil.isNotEmpty((String)customerVo.getId()) || StringUtil.isNotEmpty((String)customerVo.getDockUserName()) || StringUtil.isNotEmpty((String)customerVo.getDockPosition()) || StringUtil.isNotEmpty((String)customerVo.getBusinessGroup())) {
            sqlWhere = " and exists(select 1 from TM_CUSTOMER t2 left join  TM_R_CUST_POS_BG t3 on t3.customer_id=t2.id  left join tm_r_user_position up on up.position_id=t3.position_id left join tm_user tu on tu.id=up.user_id left join tm_position t4 on t4.id = t3.position_id where t2.id=t.id ";
        }
        if (StringUtil.isNotEmpty((String)customerVo.getDockUserName())) {
            sqlWhere = sqlWhere + " and  (tu.username like '%" + customerVo.getDockUserName() + "%' or tu.fullname like '%" + customerVo.getDockUserName() + "%')";
        }
        if (StringUtil.isNotEmpty((String)customerVo.getDockPosition())) {
            sqlWhere = sqlWhere + "and (t4.position_name like '%" + customerVo.getDockPosition() + "%' or t4.position_code like '%" + customerVo.getDockPosition() + "%')";
        }
        if (StringUtil.isNotEmpty((String)customerVo.getBusinessGroup())) {
            sqlWhere = sqlWhere + " and t3.businessGroup like '%" + customerVo.getBusinessGroup() + "%'";
        }
        sqlWhere = sqlWhere + ")";
        if (StringUtil.isEmpty(customerVo.getId()) && StringUtil.isEmpty(customerVo.getDockUserName()) && StringUtil.isEmpty(customerVo.getDockPosition()) && StringUtil.isEmpty(customerVo.getBusinessGroup())) {
            sqlWhere = "";
        }
        String orderSql = "";
        if (StringUtil.isNotBlank((String)customerVo.getSort()) && StringUtil.isNotBlank((String)customerVo.getOrder())) {
            KnlDictDataEntity tagerEntity;
            KnlDictDataEntity knlDictDataEntity = DictUtil.getDicData(Globals.mdm_table, table + "_");
            if (knlDictDataEntity != null && StringUtil.isNotBlank((String)knlDictDataEntity.getDictCode()) && StringUtil.isNotBlank((String)(tagerEntity = DictUtil.getDictByParentIdAndDictCode(knlDictDataEntity.getId(), customerVo.getSort())).getDictValue())) {
                String c = tagerEntity.getDictValue();
                orderSql = " order by " + c + " " + customerVo.getOrder();
            }
        } else {
            orderSql = " order by t.customerCode desc";
        }
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, sqlJoin, sqlOn, sqlWhere, orderSql);
    }

    public String appendCustomerConditionSplit() {
        String sql = "select t1.customer_id id, t1.position_id,t2.position_name dockPosition,t2.position_code position_code,t1.business_group businessGroup,tu.username username,tu.fullname dockUserName  from TM_R_CUST_POS_BG t1 left join tm_position t2 on t2.id = t1.position_id  left join tm_r_user_position up on up.position_id=t1.position_id  left join tm_user tu on tu.id=up.user_id where ${customerId} group by t1.customer_id,t1.position_id,t2.position_name,t2.position_code,t1.business_group,tu.username,tu.fullname";
        return sql;
    }

    @Override
    public void saveTmCustomer(TmCustomerVo customerVo, Page page) {
        ArrayList<TmBusinessGroupVo> addBusinessGroupVoList = new ArrayList<TmBusinessGroupVo>();
        ArrayList<TmBusinessGroupVo> deleteBusinessGroupVoList = new ArrayList<TmBusinessGroupVo>();
        TmCustomerEntity tmCustomerEntity = null;
        if (StringUtil.isNotEmpty(this.tmCustomerExtendService)) {
            try {
                this.tmCustomerExtendService.validate(customerVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmCustomerEntity = this.tmCustomerExtendService.saveBefore(customerVo, page);
        }
        if (StringUtil.isEmpty(tmCustomerEntity)) {
            tmCustomerEntity = new TmCustomerVoToTmCustomerEntity(this, addBusinessGroupVoList, deleteBusinessGroupVoList).apply(customerVo);
        }
        if (StringUtil.isNotEmpty(this.tmCustomerExtendService)) {
            tmCustomerEntity = this.tmCustomerExtendService.saveBefore(tmCustomerEntity, customerVo, page);
        }
        this.saveOrUpdate(tmCustomerEntity);
        this.getSession().flush();
        this.saveBusinessGroupInfo(tmCustomerEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
        if (StringUtil.isNotEmpty(this.tmCustomerExtendService)) {
            tmCustomerEntity = this.tmCustomerExtendService.savePost(tmCustomerEntity, customerVo, page);
        }
        this.executeSql("DELETE FROM TM_R_CUST_POS_BG WHERE CUSTOMER_ID IS NULL", new Object[0]);
    }

    private void saveBusinessGroupInfo(TmCustomerEntity tmCustomerEntity, List<TmBusinessGroupVo> addBusinessGroupVoList, List<TmBusinessGroupVo> deleteBusinessGroupVoList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteBusinessGroupVoList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (TmBusinessGroupVo vo : deleteBusinessGroupVoList) {
                map.put(vo.getBusinessGroup(), vo.getBusinessGroup());
            }
            String deleteSql = "delete from tm_r_cust_pos_bg_detail where business_group = ?";
            Set keyset = map.keySet();
            for (String key : keyset) {
                this.executeSql(deleteSql, key);
            }
        }
        this.getSession().flush();
        if (CollectionUtil.listNotEmptyNotSizeZero(addBusinessGroupVoList)) {
            for (TmBusinessGroupVo vo : addBusinessGroupVoList) {
                if (vo.getTypeCode() == "orgCode" || vo.getTypeCode() == "positionCode") continue;
                TmRCustPosBgDetailEntity entity = new TmRCustPosBgDetailEntity();
                entity.setBusinessGroup(vo.getBusinessGroup());
                entity.setDetailCode(vo.getDetailCode());
                entity.setDetailName(vo.getDetailName());
                entity.setTypeCode(vo.getTypeCode());
                entity.setTypeName(vo.getTypeName());
                this.save(entity);
            }
        }
        this.getSession().flush();
        this.saveBusinessGroupLog(tmCustomerEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
    }

    private void saveBusinessGroupLog(TmCustomerEntity tmCustomerEntity, List<TmBusinessGroupVo> newBusinessGroupVoList, List<TmBusinessGroupVo> oldBusinessGroupVoList) {
        Map<String, List<TmBusinessGroupVo>> oldMap = this.buildMapByBusinessGroup(oldBusinessGroupVoList);
        Map<String, List<TmBusinessGroupVo>> newMap = this.buildMapByBusinessGroup(newBusinessGroupVoList);
        Set<String> oldKeySet = oldMap.keySet();
        String updateMsg = "";
        String deleteMsg = "";
        String addMsg = "";
        for (String oldKey : oldKeySet) {
            if (newMap.containsKey(oldKey)) {
                updateMsg = updateMsg + CustomerLogMsgUtil.buildUpdateMsg(newMap.get(oldKey), oldMap.get(oldKey)) + "<hr>";
                newMap.remove(oldKey);
                continue;
            }
            deleteMsg = deleteMsg + CustomerLogMsgUtil.buildDeleteMsg(oldMap.get(oldKey)) + "<hr>";
        }
        if (StringUtils.isNotBlank((CharSequence)(addMsg = addMsg + this.buildAddMsg(tmCustomerEntity, newMap)))) {
            this.addLog(OperationType.INSERT, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmCustomerEntity.getId(), addMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)deleteMsg)) {
            this.addLog(OperationType.DELETE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmCustomerEntity.getId(), deleteMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)updateMsg)) {
            this.addLog(OperationType.UPDATE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmCustomerEntity.getId(), updateMsg);
        }
    }

    private Map<String, List<TmBusinessGroupVo>> buildMapByBusinessGroup(List<TmBusinessGroupVo> voList) {
        HashMap<String, List<TmBusinessGroupVo>> map = new HashMap<String, List<TmBusinessGroupVo>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(voList)) {
            for (TmBusinessGroupVo oldBusinessGroupVo : voList) {
                if (map.containsKey(oldBusinessGroupVo.getBusinessGroup())) {
                    ((List)map.get(oldBusinessGroupVo.getBusinessGroup())).add(oldBusinessGroupVo);
                    continue;
                }
                ArrayList<TmBusinessGroupVo> list = new ArrayList<TmBusinessGroupVo>();
                list.add(oldBusinessGroupVo);
                map.put(oldBusinessGroupVo.getBusinessGroup(), list);
            }
        }
        return map;
    }

    private String buildAddMsg(TmCustomerEntity tmCustomerEntity, Map<String, List<TmBusinessGroupVo>> newMap) {
        Set<String> keySet = newMap.keySet();
        String msg = "";
        for (String key : keySet) {
            msg = msg + CustomerLogMsgUtil.buildAddMsg(newMap.get(key));
            msg = msg + "<hr>";
        }
        return msg;
    }

    private void disableCustomerUser(String customerId) {
        String sql = "UPDATE tm_user SET enable_status = '003' WHERE ID in (SELECT user_id FROM tm_r_user_customer WHERE customer_id = ?)";
        this.executeSql(sql, customerId);
    }

    @Override
    public void deleteTmCustomer(String ids, Page page) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] customerIds;
            for (String customerId : customerIds = ids.split(",")) {
                TmCustomerEntity tmCustomerEntity = this.get(TmCustomerEntity.class, (Serializable)((Object)customerId));
                if (this.tmCustomerDelExtendService != null) {
                    this.tmCustomerDelExtendService.validate(tmCustomerEntity, page);
                    this.tmCustomerDelExtendService.delBefore(tmCustomerEntity, page);
                }
                if (tmCustomerEntity == null || !StringUtil.isNotEmpty((String)tmCustomerEntity.getId())) continue;
                this.delete(tmCustomerEntity);
                if (this.tmCustomerDelExtendService == null) continue;
                this.tmCustomerDelExtendService.delPost(tmCustomerEntity, page);
            }
        }
    }

    @Override
    public TmCustomerVo getTmCustomerVoById(TmCustomerVo customerVo, Page page) {
        List<TmCustomerVo> list = this.findTmCustomerList(customerVo, null, "");
        return list.size() > 0 ? list.get(0) : new TmCustomerVo();
    }

    @Override
    public List<TmCustomerVo> findTmCustomerByPosList(TmCustomerVo customerVo, Page page) {
        return this.tmCustomerDao.findTmCustomerByPosList(customerVo, page);
    }

    @Override
    public List<TmCustomerVo> findTmCustTomerByAllPossible(QueryTmCustomerVo queryTmCustomerVo, Page page) {
        return this.tmCustomerDao.findTmCustTomerByAllPossible(queryTmCustomerVo, page);
    }

    @Override
    public List<TmCustomerVo> findTpmCustomerList(TmCustomerVo customerVo, Page page) {
        return this.tmCustomerDao.findTpmCustomerList(customerVo, page);
    }

    @Override
    public List<TmLogVo> findCustomerLogList(TmLogVo tmLogVo, Page page) {
        return this.tmCustomerDao.findCustomerLogList(tmLogVo, page);
    }

    @Override
    public List<TmCustomerVo> findTmCustTomerByOrgAndCustType(QueryTmCustomerVo queryTmCustomerVo, Page page) {
        return this.tmCustomerDao.findTmCustTomerByOrgAndCustType(queryTmCustomerVo, page);
    }

    @Override
    public List<ComboBox> findCustomerComboBoxByPosId(String positionId) {
        String sql = "SELECT DISTINCT TC.ID AS ID,TC.CUSTOMER_NAME AS TEXT,TC.CUSTOMER_CODE AS VALUE FROM TM_CUSTOMER TC JOIN TM_R_CUST_POS_BG TRCP ON TC.ID = TRCP.CUSTOMER_ID WHERE TRCP.POSITION_ID=?";
        return this.findBySql(ComboBox.class, sql, positionId);
    }

    @Override
    public List<TmCustomerVo> findCustomer(String settlementCode, String customerType, String contractCode, String orgId) {
        return this.tmCustomerDao.findCustomer(settlementCode, customerType, contractCode, orgId);
    }

    @Override
    public TmCustomerVo findSapCustomer(String code) {
        List<TmCustomerVo> customerVoList = this.tmCustomerDao.findSapCustomer(code);
        return customerVoList != null && customerVoList.size() > 0 ? customerVoList.get(0) : new TmCustomerVo();
    }

    @Override
    public List<TmCustomerVo> findTmCustomerListByOrgMain(TmCustomerVo customerVo, Page page) {
        List<TmCustomerVo> voList = this.tmCustomerDao.findTmCustomerListByOrgMain(customerVo, page);
        return voList;
    }

    @Override
    public AjaxJson changeCustomerForOrg(TmOrgVo tmOrgVo) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((String)tmOrgVo.getCustomerIds())) {
            String[] customerIds;
            TmCustomerEntity tmCustomerEntity = null;
            TmOrgEntity tmOrgEntity = null;
            for (String posId : customerIds = tmOrgVo.getCustomerIds().split(",")) {
                tmCustomerEntity = this.get(TmCustomerEntity.class, (Serializable)((Object)posId));
                if (!StringUtil.isNotEmpty(tmCustomerEntity)) continue;
                tmOrgEntity = this.get(TmOrgEntity.class, (Serializable)((Object)tmOrgVo.getOrgId()));
                tmCustomerEntity.setTmOrg(tmOrgEntity);
                this.saveOrUpdate(tmCustomerEntity);
            }
            j.setMsg("\u8c03\u6574\u5173\u7cfb\u6210\u529f");
        } else {
            j.setSuccess(false);
            j.setMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
        }
        return j;
    }

    @Override
    public AjaxJson startOrStop(TmCustomerVo tmCustomerVo) {
        AjaxJson j = new AjaxJson();
        TmCustomerEntity tmCustomerEntity = this.get(TmCustomerEntity.class, (Serializable)((Object)tmCustomerVo.getId()));
        if (StringUtil.isNotEmpty(tmCustomerEntity)) {
            if (tmCustomerEntity.getEnableStatus().toString().equals(tmCustomerVo.getEnableStatus().toString())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.equals(tmCustomerVo.getEnableStatus()) ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                tmCustomerEntity.setEnableStatus(tmCustomerVo.getEnableStatus());
                this.updateEntity(tmCustomerEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }
}

