/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer.iterator;

import com.biz.eisp.base.importer.iterator.DataIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TextDataIterator
implements DataIterator {
    public static final char DEFAULT_DELIMITER = ',';
    private BufferedReader reader;
    private int index;
    private char delimiter;
    private String regex;

    public TextDataIterator(InputStream is, char delimiter) throws Exception {
        this.reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        this.delimiter = delimiter;
    }

    public TextDataIterator(InputStream is, String regex) throws Exception {
        this.reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        this.regex = regex;
    }

    public TextDataIterator(InputStream is, char delimiter, String charset) throws Exception {
        this.reader = new BufferedReader(new InputStreamReader(is, charset));
        this.delimiter = delimiter;
    }

    public TextDataIterator(InputStream is, String regex, String charset) throws Exception {
        this.reader = new BufferedReader(new InputStreamReader(is, charset));
        this.regex = regex;
    }

    public TextDataIterator() {
        this.delimiter = (char)44;
    }

    public boolean hasNext() {
        try {
            return this.reader.ready();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Map<String, Object> next() {
        ++this.index;
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        try {
            String line = this.reader.readLine();
            String[] row = null;
            row = this.regex == null ? this.parseLine(line) : line.split(this.regex);
            for (int m = 0; m < row.length; ++m) {
                rowMap.put(m + 1 + "", row[m].trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowMap;
    }

    public void remove() {
    }

    public int getIndex() {
        return this.index;
    }

    public int getRowNumber() {
        return this.index;
    }

    private String[] parseLine(String line) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        char[] c = line.toCharArray();
        int len = c.length;
        int idx = 0;
        char quote = '\"';
        int start = -1;
        int end = -1;
        int delimiterIndex = -1;
        char fc = '\u0000';
        while (idx < len) {
            char curr = c[idx];
            if (fc == '\u0000') {
                fc = curr;
                start = idx;
                if (fc == this.delimiter) {
                    end = start;
                }
            } else if (curr == quote) {
                if (fc == quote) {
                    int next = idx + 1;
                    if (next < len && c[next] == this.delimiter || next == len) {
                        ++start;
                        end = idx++;
                    } else {
                        fc = 'A';
                    }
                }
            } else if (curr == this.delimiter) {
                if (fc == quote) {
                    if (delimiterIndex == -1) {
                        delimiterIndex = idx;
                    }
                } else {
                    end = idx;
                }
            }
            if (end == -1 && ++idx == len) {
                if (delimiterIndex != -1) {
                    end = delimiterIndex;
                    idx = delimiterIndex + 1;
                    delimiterIndex = -1;
                } else {
                    end = idx;
                }
            }
            if (end == -1) continue;
            list.add(new String(c, start, end - start));
            start = -1;
            end = -1;
            delimiterIndex = -1;
            fc = '\u0000';
        }
        String[] row = new String[list.size()];
        list.toArray(row);
        return row;
    }

    public int getSize() {
        return -1;
    }
}

