/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.arearange.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.arearange.dao.TmAreaRangeDao;
import com.biz.eisp.mdm.arearange.entity.TmAreaRangeEntity;
import com.biz.eisp.mdm.arearange.service.TmAreaRangeService;
import com.biz.eisp.mdm.arearange.tansformer.TmAreaRangeTransformer;
import com.biz.eisp.mdm.arearange.vo.TmAreaRangeVo;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TmAreaRangeServiceImpl
extends BaseServiceImpl
implements TmAreaRangeService {
    @Autowired
    private TmAreaRangeDao tmAreaRangeDao;

    public List<TmAreaRangeVo> findAreaRangeList(TmAreaRangeVo vo, Page page) {
        return this.tmAreaRangeDao.findAreaRangeList(vo, page);
    }

    public TmAreaRangeVo getAreaRangeById(String id) {
        TmAreaRangeVo result = new TmAreaRangeVo();
        if (StringUtil.isNotEmpty((String)id)) {
            TmAreaRangeEntity entity = (TmAreaRangeEntity)this.get(TmAreaRangeEntity.class, (Serializable)((Object)id));
            result = TmAreaRangeTransformer.entityToNewVo((TmAreaRangeEntity)entity);
        }
        return result;
    }

    public void saveAreaRange(TmAreaRangeVo vo) {
        this.checkAreaRangeData(vo);
        if (StringUtil.isEmpty((String)vo.getId())) {
            TmAreaRangeEntity entity = TmAreaRangeTransformer.voToNewEntity((TmAreaRangeVo)vo);
            this.save((Object)entity);
        } else {
            TmAreaRangeEntity entity = (TmAreaRangeEntity)this.get(TmAreaRangeEntity.class, (Serializable)((Object)vo.getId()));
            TmAreaRangeTransformer.copyVoToEntity((TmAreaRangeVo)vo, (TmAreaRangeEntity)entity);
            this.saveOrUpdate((Object)entity);
        }
    }

    public void deleteAreaRangeByIds(String ids) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] idArray;
            for (String id : idArray = ids.split(",")) {
                if (!StringUtil.isNotEmpty((String)id)) continue;
                this.deleteEntityById(TmAreaRangeEntity.class, (Serializable)((Object)id));
            }
        } else {
            throw new BusinessException("\u7a7a\u53c2\u6570");
        }
    }

    private void checkAreaRangeData(TmAreaRangeVo vo) {
        if (StringUtil.isEmpty((Object)vo)) {
            throw new BusinessException("\u7a7a\u53c2\u6570");
        }
        if (StringUtil.isEmpty((String)vo.getParentCode())) {
            throw new BusinessException("\u4e0a\u7ea7\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)vo.getCode())) {
            throw new BusinessException("\u884c\u653f\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.tmAreaRangeDao.findAreaRangeToCheckUnique(vo);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            throw new BusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5bf9\u7528\u5173\u7cfb");
        }
    }
}

