/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.function.transformer;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.PinyinUtil;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class TmFunctionVoToTmFunctionEntity
implements Function<TmFunctionVo, TmFunctionEntity> {
    private TmFunctionService functionService;

    public TmFunctionVoToTmFunctionEntity(TmFunctionService functionService) {
        this.functionService = functionService;
    }

    public TmFunctionEntity apply(TmFunctionVo input) {
        TmIconEntity tmIcon;
        TmFunctionEntity tmFunction = null;
        if (jodd.util.StringUtil.isNotEmpty((String)input.getId())) {
            tmFunction = (TmFunctionEntity)this.functionService.get(TmFunctionEntity.class, (Serializable)((Object)input.getId()));
            tmFunction.setUpdateDate(new Date());
            tmFunction.setUpdateName(ResourceUtil.getSessionUserName().getUserName());
        } else {
            tmFunction = new TmFunctionEntity();
            tmFunction.setCreateDate(new Date());
            tmFunction.setCreateName(ResourceUtil.getSessionUserName().getUserName());
        }
        if (StringUtil.isNotEmpty((Object)input.getFunctionOrder())) {
            tmFunction.setFunctionOrder(Integer.valueOf(0));
        }
        if (jodd.util.StringUtil.isNotBlank((String)input.getParentId())) {
            TmFunctionEntity function = (TmFunctionEntity)this.functionService.get(TmFunctionEntity.class, (Serializable)((Object)input.getParentId()));
            if (function == null) {
                throw new BusinessException("\u8f6c\u6362\u83dc\u5355Vo\u5230Po\u65f6\uff0c\u4e0a\u7ea7\u83dc\u5355\u627e\u4e0d\u5230:" + input.getParentId());
            }
            tmFunction.setTmFunction(function);
            tmFunction.setFunctionLevel(Short.valueOf(function.getFunctionLevel() + 1 + ""));
        } else {
            tmFunction.setFunctionLevel(Short.valueOf("0"));
            tmFunction.setTmFunction(null);
        }
        this.doLevel(tmFunction);
        if (jodd.util.StringUtil.isNotBlank((String)input.getIconId()) && (tmIcon = (TmIconEntity)this.functionService.get(TmIconEntity.class, (Serializable)((Object)input.getIconId()))) == null) {
            throw new BusinessException("\u8f6c\u6362\u83dc\u5355Vo\u5230Po\u65f6\uff0c\u56fe\u6807\u4fe1\u606f\u627e\u4e0d\u5230:" + input.getIconId());
        }
        tmFunction.setFunctionName(input.getFunctionName());
        tmFunction.setHeadString(PinyinUtil.getPinYinHeadChar((String)input.getFunctionName()));
        if (tmFunction.getFunctionLevel() == null) {
            tmFunction.setFunctionLevel(input.getFunctionLevel());
        }
        tmFunction.setFunctionOrder(input.getFunctionOrder());
        tmFunction.setFunctionUrl(input.getFunctionUrl());
        tmFunction.setIsSystem(input.getIsSystem());
        tmFunction.setFunctionModule(input.getFunctionModule());
        tmFunction.setIsConfigure(input.getIsConfigure());
        return tmFunction;
    }

    private void doLevel(TmFunctionEntity tmFunction) {
        if (tmFunction == null) {
            return;
        }
        List functionEntities = tmFunction.getTmFunctionList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)functionEntities)) {
            Short functionLevelParent = tmFunction.getFunctionLevel();
            if (functionLevelParent == null) {
                return;
            }
            int childLevel = functionLevelParent.intValue() + 1;
            for (TmFunctionEntity item : functionEntities) {
                int functionLevel = item.getFunctionLevel().intValue();
                if (childLevel == functionLevel) continue;
                item.setFunctionLevel(Short.valueOf(String.valueOf(childLevel)));
                this.doLevel(item);
            }
        }
    }
}

