/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.position.service.impl;

import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import java.util.List;
import java.util.Map;

public class TmPositionEventHandler
extends ImpEventHandler<TmPositionVo> {
    private TmPositionService tmPositionService = (TmPositionService)ApplicationContextUtils.getContext().getBean("tmPositionService");

    public void endRow(Map<String, Object> row, TmPositionVo bean) throws ValidateException {
        try {
            EuPage page = new EuPage();
            if (null != bean.getPositionLevel() && 0 == bean.getPositionLevel()) {
                bean.setPositionLevel(null);
            }
            this.setRelationValues(bean);
            this.tmPositionService.saveTmPosition(bean, (Page)page);
        }
        catch (Exception e) {
            this.addError("\u7b2c" + this.getRowNumber() + "\u884c\u9047\u5230\u9519\u8bef:" + e.getMessage());
            e.printStackTrace();
        }
        this.setSuccNum(this.getSuccNum() + 1);
    }

    private void setRelationValues(TmPositionVo bean) {
        TmPositionEntity positionEntity = (TmPositionEntity)this.tmPositionService.findUniqueByProperty(TmPositionEntity.class, "positionCode", (Object)bean.getPositionCode());
        if (positionEntity != null) {
            String roleIds = this.getRoleIds(positionEntity.getId());
            String actRoleIds = this.getActRoleIds(positionEntity.getId());
            bean.setRoleIds(roleIds);
            bean.setWorkflowRoleIds(actRoleIds);
        }
    }

    private String getRoleIds(String positionId) {
        String sql = "SELECT group_concat(distinct role_id separator ',') AS roleIds FROM tm_r_position_role WHERE position_id = ?";
        List list = this.tmPositionService.findBySql(TmPositionVo.class, sql, new Object[]{positionId});
        if (list != null) {
            return ((TmPositionVo)list.get(0)).getRoleIds();
        }
        return null;
    }

    private String getActRoleIds(String positionId) {
        String sql = "SELECT group_concat(distinct role_id separator ',') AS roleIds FROM tm_r_position_act_role WHERE position_id = ?";
        List list = this.tmPositionService.findBySql(TmPositionVo.class, sql, new Object[]{positionId});
        if (list != null) {
            return ((TmPositionVo)list.get(0)).getRoleIds();
        }
        return null;
    }
}

