/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.productPrice.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.productPrice.dao.TmProductPriceDao;
import com.biz.eisp.mdm.productPrice.entity.TmProductPriceEntity;
import com.biz.eisp.mdm.productPrice.service.TmProductPriceExtendService;
import com.biz.eisp.mdm.productPrice.service.TmProductPriceService;
import com.biz.eisp.mdm.productPrice.transformer.TmProductPriceEntityToTmProductPriceVo;
import com.biz.eisp.mdm.productPrice.transformer.TmProductPriceVoToTmProductPriceEntity;
import com.biz.eisp.mdm.productPrice.vo.TmProductPriceVo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmProductPriceService")
@Transactional
public class TmProductPriceServiceImpl
extends BaseServiceImpl
implements TmProductPriceService {
    @Autowired
    private TmProductPriceDao tmProductPriceDao;
    @Autowired(required=false)
    private TmProductPriceExtendService tmProductPriceExtendService;

    public String saveOrUpdateProductPrice(TmProductPriceVo ic) {
        UserRedis userRedis = UserUtils.getUser();
        Date date = new Date();
        TmProductPriceEntity icon = null;
        if (StringUtil.isNotEmpty((Object)this.tmProductPriceExtendService)) {
            try {
                this.tmProductPriceExtendService.validate(ic);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            icon = this.tmProductPriceExtendService.saveBefore(ic);
        }
        if (StringUtil.isEmpty(icon)) {
            TmProductPriceVoToTmProductPriceEntity transForm = new TmProductPriceVoToTmProductPriceEntity((TmProductPriceService)this);
            icon = transForm.apply(ic);
        }
        if (StringUtil.isEmpty((String)icon.getId())) {
            icon.setCreateBy(userRedis.getUsername());
            icon.setCreateName(userRedis.getRealname());
            icon.setCreateDate(date);
        }
        icon.setUpdateBy(userRedis.getUsername());
        icon.setUpdateName(userRedis.getRealname());
        icon.setUpdateDate(date);
        if (StringUtil.isNotEmpty((Object)this.tmProductPriceExtendService)) {
            icon = this.tmProductPriceExtendService.saveBefore(icon, ic);
        }
        this.saveOrUpdate((Object)icon);
        return "\u64cd\u4f5c\u6210\u529f";
    }

    public String saveImportProductPrice(TmProductPriceVo tmProductPriceVo) {
        this.validateImportDate(tmProductPriceVo);
        this.saveOrUpdateProductPrice(tmProductPriceVo);
        return "\u64cd\u4f5c\u6210\u529f";
    }

    public TmProductPriceVo getProductPriceById(String id) {
        TmProductPriceEntity ie = (TmProductPriceEntity)this.get(TmProductPriceEntity.class, (Serializable)((Object)id));
        if (ie != null) {
            TmProductPriceEntityToTmProductPriceVo trans = new TmProductPriceEntityToTmProductPriceVo((TmProductPriceService)this);
            return trans.apply(ie);
        }
        return null;
    }

    public List<TmProductPriceVo> findProductPriceMainGrid(TmProductPriceVo tmProductPriceVo, Page page) {
        return this.tmProductPriceDao.findTmProductPriceList(tmProductPriceVo, page);
    }

    public List<TmProductPriceVo> getTmProductPriceList(TmProductPriceVo tmProductPriceVo) {
        return this.tmProductPriceDao.getTmProductPriceList(tmProductPriceVo);
    }

    public AjaxJson delProductPrice(String ids) {
        String[] iconIds;
        AjaxJson j = new AjaxJson();
        for (String id : iconIds = ids.split(",")) {
            TmProductPriceEntity tmProductPriceEntity = (TmProductPriceEntity)this.get(TmProductPriceEntity.class, (Serializable)((Object)id));
            if (tmProductPriceEntity == null) {
                j.setMsg("\u5220\u9664\u5931\u8d25\uff01");
                j.setSuccess(false);
                return j;
            }
            this.delete((Object)tmProductPriceEntity);
        }
        j.setMsg("\u5220\u9664\u6210\u529f\uff01");
        return j;
    }

    private void validateImportDate(TmProductPriceVo tmProductPriceVo) {
        String priceDimension = tmProductPriceVo.getPriceDimension();
        try {
            tmProductPriceVo.setBeginTime(DateUtils.getDateYYYYMMDD((String)tmProductPriceVo.getBeginTimeStr()));
            tmProductPriceVo.setEndTime(DateUtils.getDateYYYYMMDD((String)tmProductPriceVo.getEndTimeStr()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        this.volidateProduct(tmProductPriceVo);
        switch (StringUtil.trim((String)priceDimension)) {
            case "\u4ea7\u54c1": {
                tmProductPriceVo.setPriceGroup("");
                tmProductPriceVo.setCustomerCode("");
                break;
            }
            case "\u4ea7\u54c1+\u5ba2\u6237": {
                tmProductPriceVo.setPriceGroup("");
                this.volidateCust(tmProductPriceVo);
                break;
            }
            case "\u4ea7\u54c1+\u4ef7\u683c\u7ec4": {
                tmProductPriceVo.setCustomerCode("");
                this.volidatePriceGroup(tmProductPriceVo);
                break;
            }
            default: {
                throw new BusinessException("\u4ea7\u54c1\u7ef4\u5ea6\u3010" + priceDimension + "\u3011\u4e0e\u5b57\u5178\u4e0d\u4e00\u81f4");
            }
        }
    }

    private void volidateProduct(TmProductPriceVo tmProductPriceVo) {
        int num = this.tmProductPriceDao.findImportProduct(StringUtil.trim((String)tmProductPriceVo.getProductInfoCode()), StringUtil.trim((String)tmProductPriceVo.getProductInfoName()));
        if (num < 1) {
            throw new BusinessException("\u4ea7\u54c1\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u7b26");
        }
        Map priceDimensionMap = DictUtil.getDictMap((String)"price_dimension");
        Map priceTypeMap = DictUtil.getDictMap((String)"price_type");
        Map companyCodeMap = DictUtil.getDictMap((String)"company_code");
        Map saleUnitMap = DictUtil.getDictMap((String)"sale_unit");
        Map priceCurrencyMap = DictUtil.getDictMap((String)"price_currency");
        Map deleteStatusMap = DictUtil.getDictMap((String)"is_no");
        String key = this.getKey(tmProductPriceVo.getPriceDimension(), priceDimensionMap);
        if (key.equals(tmProductPriceVo.getPriceDimension())) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u4ea7\u54c1\u7ef4\u5ea6\u3010" + tmProductPriceVo.getPriceDimension() + "\u3011\u5bf9\u5e94\u5b57\u5178\u503c");
        }
        KnlDictDataEntity dictDataEntity = (KnlDictDataEntity)priceDimensionMap.get(key);
        tmProductPriceVo.setPricePriority(dictDataEntity.getExtendMap().get("priority").toString());
        tmProductPriceVo.setPriceDimension(this.getKey(tmProductPriceVo.getPriceDimension(), priceDimensionMap));
        tmProductPriceVo.setPriceType(this.getKey(tmProductPriceVo.getPriceType(), priceTypeMap));
        tmProductPriceVo.setSaleCompany(this.getKey(tmProductPriceVo.getSaleCompany(), companyCodeMap));
        tmProductPriceVo.setSaleUnit(this.getKey(tmProductPriceVo.getSaleUnit(), saleUnitMap));
        tmProductPriceVo.setPriceCurrency(this.getKey(tmProductPriceVo.getPriceCurrency(), priceCurrencyMap));
        tmProductPriceVo.setDeleteStatus(this.getKey(tmProductPriceVo.getDeleteStatus(), deleteStatusMap));
    }

    private void volidateCust(TmProductPriceVo tmProductPriceVo) {
        if (StringUtil.isBlank((String)tmProductPriceVo.getCustomerCode())) {
            throw new BusinessException("\u4ef7\u683c\u7ef4\u5ea6\u4e3a\u3010\u4ea7\u54c1+\u5ba2\u6237\u3011\u7684\u5ba2\u6237\u7f16\u7801\u5fc5\u586b");
        }
        TmCustomerVo customerVo = this.tmProductPriceDao.findImportCust(StringUtil.trim((String)tmProductPriceVo.getCustomerCode()));
        if (StringUtil.isEmpty((Object)customerVo)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u7b26");
        }
        tmProductPriceVo.setCustomerName(customerVo.getCustomerName());
    }

    private void volidatePriceGroup(TmProductPriceVo tmProductPriceVo) {
        if (StringUtil.isBlank((String)tmProductPriceVo.getPriceGroup())) {
            throw new BusinessException("\u4ef7\u683c\u7ef4\u5ea6\u4e3a\u3010\u4ea7\u54c1+\u4ef7\u683c\u7ec4\u3011\u7684\u4ef7\u683c\u7ec4\u5fc5\u9009");
        }
        Map priceGroupMap = DictUtil.getDictMap((String)"price_group");
        String priceGroup = this.getKey(tmProductPriceVo.getPriceGroup(), priceGroupMap);
        if (priceGroup.equals(tmProductPriceVo.getPriceGroup())) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u4ef7\u683c\u7ec4\u3010" + tmProductPriceVo.getPriceGroup() + "\u3011\u5bf9\u5e94\u5b57\u5178\u503c");
        }
        tmProductPriceVo.setPriceGroup(priceGroup);
    }

    private String getKey(String value, Map<Object, Object> map) {
        for (Map.Entry<Object, Object> it : map.entrySet()) {
            KnlDictDataEntity dictDataEntity = (KnlDictDataEntity)it.getValue();
            if (!value.equals(dictDataEntity.getDictValue())) continue;
            return dictDataEntity.getDictCode();
        }
        return value;
    }
}

