/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.terminal.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.entity.TmRoleFuncAuthobjEntity;
import com.biz.eisp.mdm.authobj.util.AuthUtil;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.terminal.dao.TmTerminalDao;
import com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGDetailEntity;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.service.TmTerminalDelExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalSearchAuthExpand;
import com.biz.eisp.mdm.terminal.service.TmTerminalSearchExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.transformer.TmTerminalVoToTmTerminalEntity;
import com.biz.eisp.mdm.terminal.util.TerminalLogMsgUtil;
import com.biz.eisp.mdm.terminal.vo.QueryTmTerminalVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmTerminalService")
@Transactional(rollbackFor={Exception.class})
public class TmTerminalServiceImpl
extends BaseServiceImpl
implements TmTerminalService {
    private static final Logger log = LoggerFactory.getLogger(TmTerminalServiceImpl.class);
    @Autowired
    private TmTerminalDao tmTerminalDao;
    @Autowired(required=false)
    private TmTerminalExtendService terminalExtendService;
    @Autowired(required=false)
    private TmTerminalSearchExtendService tmTerminalSearchExtendService;
    @Autowired(required=false)
    private TmTerminalSearchAuthExpand tmTerminalSearchAuthExpand;
    @Autowired(required=false)
    private TmTerminalDelExtendService tmTerminalDelExtendService;

    public List<TmTerminalVo> findTmTerminalList(TmTerminalVo tmTerminalVo, Page page, String clickFunctionId) {
        List terminals;
        List vos;
        String sqlTemp;
        List terminalVos;
        List funAuthEntities;
        String sql = "";
        if (this.tmTerminalSearchExtendService != null) {
            sql = this.tmTerminalSearchExtendService.buildSearchSql(tmTerminalVo);
            if (StringUtil.isEmpty((String)sql)) {
                sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_TERMINAL, (Object)tmTerminalVo);
                sql = this.tmTerminalSearchExtendService.extendSearchSql(tmTerminalVo, sql);
            }
            return this.tmTerminalDao.findTerminalList(tmTerminalVo, page, sql);
        }
        sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_TERMINAL, (Object)tmTerminalVo);
        sql = this.appendTerminalCondition(sql, tmTerminalVo, Globals.TABLE_TERMINAL);
        UserRedis userRedis = UserUtils.getUser();
        String dataBase = ResourceUtil.getSysConfigProperty((String)"dataBase");
        StringBuffer stringBuffer = new StringBuffer();
        if (Globals.MYSQL.equals(dataBase) && StringUtil.isNotBlank((String)clickFunctionId) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername()) && CollectionUtil.listNotEmptyNotSizeZero((List)(funAuthEntities = this.findBySql(TmFunAuthEntity.class, AuthUtil.sqlvew, new Object[]{Globals.VIEW, clickFunctionId})))) {
            List valList = this.findBySql(TmRoleFuncAuthobjEntity.class, AuthUtil.sqlval, new Object[]{clickFunctionId, userRedis.getId(), Globals.VIEW});
            if (CollectionUtil.listNotEmptyNotSizeZero((List)valList)) {
                HashMap auMap = new HashMap();
                valList.stream().collect(Collectors.groupingBy(TmRoleFuncAuthobjEntity::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put(parentId, list));
                stringBuffer.append("  and ( ");
                if (AuthUtil.checAll((List)valList)) {
                    stringBuffer.append("1=1");
                } else {
                    Map<Object, Object> auValMap;
                    List items;
                    boolean flagOr = false;
                    if (auMap.containsKey("position")) {
                        flagOr = true;
                        items = (List)auMap.get("position");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(TmRoleFuncAuthobjEntity::getAuthobjValue, item -> item));
                        stringBuffer.append("  EXISTS( select aa.id from TM_R_TERM_CUST_POS_BG aa left join tm_position bb on aa.POSITION_ID = bb.id where t.id = aa.TERMINAL_ID ");
                        if (auValMap.containsKey("40")) {
                            stringBuffer.append(" and bb.code_rule like '" + userRedis.getPoscoderule() + "%' ");
                        } else if (auValMap.containsKey("50")) {
                            stringBuffer.append(" and bb.id = '" + userRedis.getPosId() + "' ");
                        }
                        stringBuffer.append(")");
                    }
                    if (auMap.containsKey("org")) {
                        items = (List)auMap.get("org");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(TmRoleFuncAuthobjEntity::getAuthobjValue, item -> item));
                        if (flagOr) {
                            stringBuffer.append(" or ");
                        }
                        flagOr = true;
                        stringBuffer.append(" EXISTS( select b.id from tm_org b where t.org_id = b.id  ");
                        if (auValMap.containsKey("20")) {
                            stringBuffer.append(" and b.code_rule like '" + userRedis.getOrgcoderule() + "%' ");
                        } else if (auValMap.containsKey("30")) {
                            stringBuffer.append(" and b.id = '" + userRedis.getOrgId() + "' ");
                        }
                        stringBuffer.append(")");
                    }
                    if (null != this.tmTerminalSearchAuthExpand) {
                        String expandSql = this.tmTerminalSearchAuthExpand.getAuthExpand(auMap, userRedis, flagOr, stringBuffer);
                        stringBuffer.append(expandSql);
                    }
                }
                stringBuffer.append(" )");
            } else {
                stringBuffer.append(" and 1=2");
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(terminalVos = this.tmTerminalDao.findTerminalList(tmTerminalVo, page, sql = sql.replaceFirst("1=1", sqlTemp = " 1=1 " + stringBuffer.toString())))) && CollectionUtil.listNotEmptyNotSizeZero((List)(vos = this.tmTerminalDao.findTerminalListChildren(this.appendTerminalConditionSplit(terminals = terminalVos.stream().map(TmTerminalVo::getId).collect(Collectors.toList())))))) {
            Map<String, TmTerminalVo> terminalVoMap = terminalVos.stream().collect(Collectors.toMap(TmTerminalVo::getId, item -> item));
            for (TmTerminalVo terminalVo : vos) {
                String id = terminalVo.getId();
                if (!terminalVoMap.containsKey(id)) continue;
                TmTerminalVo mapVo = terminalVoMap.get(id);
                if (StringUtil.isNotEmpty((String)terminalVo.getCustomerId())) {
                    if (StringUtil.isNotEmpty((String)mapVo.getCustomerId())) {
                        mapVo.setCustomerId(mapVo.getCustomerId() + "," + terminalVo.getCustomerId());
                    } else {
                        mapVo.setCustomerId(terminalVo.getCustomerId());
                    }
                }
                if (StringUtil.isNotEmpty((String)terminalVo.getCustomerCode())) {
                    if (StringUtil.isNotEmpty((String)mapVo.getCustomerCode())) {
                        mapVo.setCustomerCode(mapVo.getCustomerCode() + "," + terminalVo.getCustomerCode());
                    } else {
                        mapVo.setCustomerCode(terminalVo.getCustomerCode());
                    }
                }
                if (StringUtil.isNotEmpty((String)terminalVo.getCustomerName())) {
                    if (StringUtil.isNotEmpty((String)mapVo.getCustomerName())) {
                        mapVo.setCustomerName(mapVo.getCustomerName() + "," + terminalVo.getCustomerName());
                    } else {
                        mapVo.setCustomerName(terminalVo.getCustomerName());
                    }
                }
                if (StringUtil.isNotEmpty((String)terminalVo.getPositionCode())) {
                    if (StringUtil.isNotEmpty((String)mapVo.getPositionCode())) {
                        mapVo.setPositionCode(mapVo.getPositionCode() + "," + terminalVo.getPositionCode());
                    } else {
                        mapVo.setPositionCode(terminalVo.getPositionCode());
                    }
                }
                if (StringUtil.isNotEmpty((String)terminalVo.getDockPosition())) {
                    if (StringUtil.isNotEmpty((String)mapVo.getDockPosition())) {
                        mapVo.setDockPosition(mapVo.getDockPosition() + "," + terminalVo.getDockPosition());
                    } else {
                        mapVo.setDockPosition(terminalVo.getDockPosition());
                    }
                }
                if (StringUtil.isNotEmpty((String)terminalVo.getBusinessGroup())) {
                    if (StringUtil.isNotEmpty((String)mapVo.getBusinessGroup())) {
                        mapVo.setBusinessGroup(mapVo.getBusinessGroup() + "," + terminalVo.getBusinessGroup());
                    } else {
                        mapVo.setBusinessGroup(terminalVo.getBusinessGroup());
                    }
                }
                if (StringUtil.isNotEmpty((String)terminalVo.getDockUserName())) {
                    if (StringUtil.isNotEmpty((String)mapVo.getDockUserName())) {
                        mapVo.setDockUserName(mapVo.getDockUserName() + "," + terminalVo.getDockUserName());
                    } else {
                        mapVo.setDockUserName(terminalVo.getDockUserName());
                    }
                }
                terminalVoMap.put(id, mapVo);
            }
        }
        return terminalVos;
    }

    public String appendTerminalCondition(String sql, TmTerminalVo terminalVo, String table) {
        String joinSql = "";
        String sqlOn = " ";
        String sqlWhere = "";
        if (StringUtil.isNotEmpty((String)terminalVo.getId())) {
            sqlWhere = " and (t.id='" + terminalVo.getId() + "'";
        }
        if (StringUtil.isEmpty((String)terminalVo.getId()) || StringUtil.isNotEmpty((String)terminalVo.getDockUserName()) || StringUtil.isNotEmpty((String)terminalVo.getDockPosition()) || StringUtil.isNotEmpty((String)terminalVo.getBusinessGroup()) || StringUtil.isNotEmpty((String)terminalVo.getCustomerName())) {
            sqlWhere = " and exists(select 1 from tm_terminal t2 left join TM_R_TERM_CUST_POS_BG t3 on t3.terminal_id=t2.id left join tm_r_user_position up on up.position_id=t3.position_id left join tm_user tu on tu.id=up.user_id left join tm_position t4 on t4.id = t3.position_id  left join tm_customer tc on tc.id=t3.customer_id  where t2.id=t.id ";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getDockUserName())) {
            sqlWhere = sqlWhere + " and  (tu.fullname like '%" + terminalVo.getDockUserName() + "%'  or tu.fullname like '%" + terminalVo.getDockUserName() + "%')";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getDockPosition())) {
            sqlWhere = sqlWhere + "and (t4.position_name like '%" + terminalVo.getDockPosition() + "%'or t4.position_code like '%" + terminalVo.getDockPosition() + "%')";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getBusinessGroup())) {
            sqlWhere = sqlWhere + " and t3.businessGroup like '%" + terminalVo.getBusinessGroup() + "%'";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getCustomerName())) {
            sqlWhere = sqlWhere + "and (tc.customer_name like '%" + terminalVo.getCustomerName() + "%' or tc.customer_code like '%" + terminalVo.getCustomerCode() + "%')";
        }
        sqlWhere = sqlWhere + ")";
        if (StringUtil.isEmpty((String)terminalVo.getId()) && StringUtil.isEmpty((String)terminalVo.getDockUserName()) && StringUtil.isEmpty((String)terminalVo.getDockPosition()) && StringUtil.isEmpty((String)terminalVo.getCustomerName()) && StringUtil.isEmpty((String)terminalVo.getBusinessGroup())) {
            sqlWhere = "";
        }
        String orderSql = "";
        if (StringUtil.isNotBlank((String)terminalVo.getSort()) && StringUtil.isNotBlank((String)terminalVo.getOrder())) {
            KnlDictDataEntity tagerEntity;
            KnlDictDataEntity knlDictDataEntity = DictUtil.getDicData((String)Globals.mdm_table, (String)(table + "_"));
            if (knlDictDataEntity != null && StringUtil.isNotBlank((String)knlDictDataEntity.getDictCode()) && StringUtil.isNotBlank((String)(tagerEntity = DictUtil.getDictByParentIdAndDictCode((String)knlDictDataEntity.getId(), (String)terminalVo.getSort())).getDictValue())) {
                String c = tagerEntity.getDictValue();
                orderSql = " order by " + c + " " + terminalVo.getOrder();
            }
        } else {
            orderSql = " order by t.terminalCode desc";
        }
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, joinSql, sqlOn, sqlWhere, orderSql);
    }

    public String appendTerminalConditionSplit(List<String> ids) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select distinct t1.terminal_id id,");
        stringBuffer.append(" t1.customer_id customerId,");
        stringBuffer.append(" tc.customer_name customerName,");
        stringBuffer.append(" tc.customer_code customerCode ,");
        stringBuffer.append(" t1.position_id positionId,");
        stringBuffer.append(" t1.business_group businessGroup ,");
        stringBuffer.append(" t2.position_name  dockPosition,");
        stringBuffer.append(" t2.position_code  position_code,");
        stringBuffer.append(" tu.username username,");
        stringBuffer.append(" tu.fullname dockUserName ");
        stringBuffer.append(" from TM_R_TERM_CUST_POS_BG t1");
        stringBuffer.append(" left join tm_customer tc on tc.id=t1.customer_id ");
        stringBuffer.append(" left join tm_position t2 on t2.id = t1.position_id ");
        stringBuffer.append(" left join tm_r_user_position up on up.position_id=t1.position_id");
        stringBuffer.append(" left join tm_user tu on tu.id=up.user_id");
        stringBuffer.append(" where  t1.terminal_id in (");
        for (int i = 0; i < ids.size(); ++i) {
            stringBuffer.append("'" + ids.get(i) + "'");
            if (i + 1 == ids.size()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void saveTmTerminal(TmTerminalVo tmTerminalVo, Page page) {
        ArrayList addBusinessGroupVoList = new ArrayList();
        ArrayList deleteBusinessGroupVoList = new ArrayList();
        TmTerminalEntity terminalEntity = null;
        if (StringUtil.isNotEmpty((Object)this.terminalExtendService)) {
            try {
                this.terminalExtendService.validate(tmTerminalVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            terminalEntity = this.terminalExtendService.saveBefore(tmTerminalVo, page);
        }
        if (StringUtil.isEmpty(terminalEntity)) {
            terminalEntity = new TmTerminalVoToTmTerminalEntity((TmTerminalService)this, addBusinessGroupVoList, deleteBusinessGroupVoList).apply(tmTerminalVo);
        }
        if (StringUtil.isNotEmpty((Object)this.terminalExtendService)) {
            terminalEntity = this.terminalExtendService.saveBefore(terminalEntity, tmTerminalVo, page);
        }
        this.saveOrUpdate(terminalEntity);
        this.getSession().flush();
        this.saveBusinessGroupInfo(terminalEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
        if (StringUtil.isNotEmpty((Object)this.terminalExtendService)) {
            terminalEntity = this.terminalExtendService.savePost(terminalEntity, tmTerminalVo, page);
        }
        this.executeSql("DELETE FROM TM_R_TERM_CUST_POS_BG WHERE TERMINAL_ID IS NULL", new Object[0]);
    }

    private void saveBusinessGroupInfo(TmTerminalEntity tmTerminalEntity, List<TmBusinessGroupVo> addBusinessGroupVoList, List<TmBusinessGroupVo> deleteBusinessGroupVoList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteBusinessGroupVoList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (TmBusinessGroupVo vo : deleteBusinessGroupVoList) {
                map.put(vo.getBusinessGroup(), vo.getBusinessGroup());
            }
            String deleteSql = "delete from tm_r_term_cust_pos_bg_detail where business_group = ?";
            Set keyset = map.keySet();
            for (String key : keyset) {
                this.executeSql(deleteSql, new Object[]{key});
            }
        }
        this.getSession().flush();
        if (CollectionUtil.listNotEmptyNotSizeZero(addBusinessGroupVoList)) {
            for (TmBusinessGroupVo vo : addBusinessGroupVoList) {
                if (vo.getTypeCode() == "orgCode" || vo.getTypeCode() == "positionCode" || vo.getTypeCode() == "customerCode") continue;
                TmRTermCustPosBGDetailEntity entity = new TmRTermCustPosBGDetailEntity();
                entity.setBusinessGroup(vo.getBusinessGroup());
                entity.setDetailCode(vo.getDetailCode());
                entity.setDetailName(vo.getDetailName());
                entity.setTypeCode(vo.getTypeCode());
                entity.setTypeName(vo.getTypeName());
                this.save((Object)entity);
            }
        }
        this.getSession().flush();
        this.saveBusinessGroupLog(tmTerminalEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
    }

    private void saveBusinessGroupLog(TmTerminalEntity tmTerminalEntity, List<TmBusinessGroupVo> newBusinessGroupVoList, List<TmBusinessGroupVo> oldBusinessGroupVoList) {
        Map oldMap = this.buildMapByBusinessGroup(oldBusinessGroupVoList);
        Map newMap = this.buildMapByBusinessGroup(newBusinessGroupVoList);
        Set oldKeySet = oldMap.keySet();
        String updateMsg = "";
        String deleteMsg = "";
        String addMsg = "";
        for (String oldKey : oldKeySet) {
            if (newMap.containsKey(oldKey)) {
                updateMsg = updateMsg + TerminalLogMsgUtil.buildUpdateMsg((List)((List)newMap.get(oldKey)), (List)((List)oldMap.get(oldKey))) + "<hr>";
                newMap.remove(oldKey);
                continue;
            }
            deleteMsg = deleteMsg + TerminalLogMsgUtil.buildDeleteMsg((List)((List)oldMap.get(oldKey))) + "<hr>";
        }
        if (StringUtils.isNotBlank((CharSequence)(addMsg = addMsg + this.buildAddMsg(tmTerminalEntity, newMap)))) {
            this.addLog(OperationType.INSERT, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmTerminalEntity.getId(), addMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)deleteMsg)) {
            this.addLog(OperationType.DELETE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmTerminalEntity.getId(), deleteMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)updateMsg)) {
            this.addLog(OperationType.UPDATE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmTerminalEntity.getId(), updateMsg);
        }
    }

    private Map<String, List<TmBusinessGroupVo>> buildMapByBusinessGroup(List<TmBusinessGroupVo> voList) {
        HashMap<String, List<TmBusinessGroupVo>> map = new HashMap<String, List<TmBusinessGroupVo>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(voList)) {
            for (TmBusinessGroupVo oldBusinessGroupVo : voList) {
                if (map.containsKey(oldBusinessGroupVo.getBusinessGroup())) {
                    ((List)map.get(oldBusinessGroupVo.getBusinessGroup())).add(oldBusinessGroupVo);
                    continue;
                }
                ArrayList<TmBusinessGroupVo> list = new ArrayList<TmBusinessGroupVo>();
                list.add(oldBusinessGroupVo);
                map.put(oldBusinessGroupVo.getBusinessGroup(), list);
            }
        }
        return map;
    }

    private String buildAddMsg(TmTerminalEntity tmTerminalEntity, Map<String, List<TmBusinessGroupVo>> newMap) {
        Set<String> keySet = newMap.keySet();
        String msg = "";
        for (String key : keySet) {
            msg = msg + TerminalLogMsgUtil.buildAddMsg(newMap.get(key));
            msg = msg + "<hr>";
        }
        return msg;
    }

    public void deleteTmTerminal(String ids, Page page) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] terminalIds;
            for (String terminalId : terminalIds = ids.split(",")) {
                TmTerminalEntity terminalEntity = (TmTerminalEntity)this.get(TmTerminalEntity.class, (Serializable)((Object)terminalId));
                if (this.tmTerminalDelExtendService != null) {
                    this.tmTerminalDelExtendService.validate(terminalEntity, page);
                    this.tmTerminalDelExtendService.delBefore(terminalEntity, page);
                }
                if (terminalEntity == null || !StringUtil.isNotEmpty((String)terminalEntity.getId())) continue;
                this.delete((Object)terminalEntity);
                if (this.tmTerminalDelExtendService == null) continue;
                this.tmTerminalDelExtendService.delPost(terminalEntity, page);
            }
        }
    }

    public TmTerminalVo getTmTerminal(TmTerminalVo tmTerminalVo, Page page) {
        List list = this.findTmTerminalList(tmTerminalVo, page, "");
        return list.size() > 0 ? (TmTerminalVo)list.get(0) : new TmTerminalVo();
    }

    public List<TmTerminalVo> findTmTerminalByPosList(TmTerminalVo terminalVo, Page page) {
        return this.tmTerminalDao.findTmTerminalByPosList(terminalVo, page);
    }

    public List<TmTerminalVo> findTmTerminalByAllPossible(QueryTmTerminalVo queryTmTerminalVo, Page page) {
        return this.tmTerminalDao.findTmTerminalByAllPossible(queryTmTerminalVo, page);
    }

    public List<TmLogVo> findTerminalLogList(TmLogVo tmLogVo, Page page) {
        return this.tmTerminalDao.findTerminalLogList(tmLogVo, page);
    }

    public List<QueryTmTerminalVo> findTmTerminalAndCustByterminalType(QueryTmTerminalVo queryTmTerminalVo, Page page) {
        return this.tmTerminalDao.findTmTerminalAndCustByterminalType(queryTmTerminalVo, page);
    }

    public AjaxJson startOrStop(TmTerminalVo tmTerminalVo) {
        AjaxJson j = new AjaxJson();
        TmTerminalEntity tmTerminalEntity = (TmTerminalEntity)this.get(TmTerminalEntity.class, (Serializable)((Object)tmTerminalVo.getId()));
        if (StringUtil.isNotEmpty((Object)tmTerminalEntity)) {
            if (tmTerminalEntity.getEnableStatus().toString().equals(tmTerminalVo.getEnableStatus().toString())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.equals(tmTerminalVo.getEnableStatus()) ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                tmTerminalEntity.setEnableStatus(tmTerminalVo.getEnableStatus());
                this.updateEntity((Object)tmTerminalEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }
}

