/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.user.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.Md5EncryptionAndDecryption;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.base.utils.SqlUtil;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.login.service.LoginService;
import com.biz.eisp.login.service.PasswdService;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.entity.TmRoleFuncAuthobjEntity;
import com.biz.eisp.mdm.authobj.util.AuthUtil;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.user.dao.TmUserDao;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserPositionEntity;
import com.biz.eisp.mdm.user.service.TmUserExtendService;
import com.biz.eisp.mdm.user.service.TmUserSearchExtendService;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.transformer.TmUserEntityToTmUserVo;
import com.biz.eisp.mdm.user.transformer.TmUserVoToTmUserEntity;
import com.biz.eisp.mdm.user.vo.QueryTmuserVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.user.vo.UserInfoEntity;
import com.biz.eisp.mdm.web.pojo.Client;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmUserService")
@Transactional
public class TmUserServiceImpl
extends BaseServiceImpl
implements TmUserService {
    @Autowired
    private TmUserDao tmUserDao;
    @Autowired(required=false)
    private TmUserExtendService tmUserExtendService;
    @Autowired(required=false)
    private TmUserSearchExtendService tmUserSearchExtendService;
    @Autowired
    private LoginService loginService;
    @Autowired(required=false)
    private PasswdService passwdService;
    @Autowired
    private RedisService redisService;

    public List<TmUserVo> findTmUserList(TmUserVo tmUserVo, Page page, String clickFunctionId) {
        List volist;
        String sql = "";
        if (this.tmUserSearchExtendService != null) {
            sql = this.tmUserSearchExtendService.buildSearchSql(tmUserVo);
            if (StringUtil.isEmpty((String)sql)) {
                sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_USER, (Object)tmUserVo);
                sql = this.tmUserSearchExtendService.extendSearchSql(tmUserVo, sql);
            }
        } else {
            sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_USER, (Object)tmUserVo);
            tmUserVo.setUserType(Integer.valueOf(0));
            sql = this.appendUserCondition(sql, tmUserVo, Globals.TABLE_USER);
        }
        UserRedis userRedis = UserUtils.getUser();
        String dataBase = ResourceUtil.getSysConfigProperty((String)"dataBase");
        if (Globals.MYSQL.equals(dataBase) && StringUtil.isNotBlank((String)clickFunctionId) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername())) {
            List funAuthEntities = this.findBySql(TmFunAuthEntity.class, AuthUtil.sqlvew, new Object[]{Globals.VIEW, clickFunctionId});
            String sqlTemp = AuthUtil.exSql;
            if (CollectionUtil.listNotEmptyNotSizeZero((List)funAuthEntities)) {
                List valList = this.findBySql(TmRoleFuncAuthobjEntity.class, AuthUtil.sqlval, new Object[]{clickFunctionId, userRedis.getId(), Globals.VIEW});
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(" t.id = aa.user_id ");
                if (CollectionUtil.listNotEmptyNotSizeZero((List)valList)) {
                    Map<Object, Object> auValMap;
                    List items;
                    HashMap auMap = new HashMap();
                    valList.stream().collect(Collectors.groupingBy(TmRoleFuncAuthobjEntity::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put(parentId, list));
                    stringBuffer.append("  and ( ");
                    boolean flagOr = true;
                    if (auMap.containsKey("position")) {
                        items = (List)auMap.get("position");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(TmRoleFuncAuthobjEntity::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("10")) {
                            stringBuffer.append("1=1");
                        } else if (auValMap.containsKey("40")) {
                            stringBuffer.append(" bb.code_rule like '" + userRedis.getPoscoderule() + "%' ");
                        } else if (auValMap.containsKey("50")) {
                            stringBuffer.append(" bb.id = '" + userRedis.getPosId() + "' ");
                        }
                    } else {
                        flagOr = false;
                    }
                    if (auMap.containsKey("org")) {
                        if (flagOr) {
                            stringBuffer.append(" or ");
                        }
                        items = (List)auMap.get("org");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(TmRoleFuncAuthobjEntity::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("10")) {
                            stringBuffer.append("1=1");
                        } else if (auValMap.containsKey("20")) {
                            stringBuffer.append(" cc.code_rule like '" + userRedis.getOrgcoderule() + "%' ");
                        } else if (auValMap.containsKey("30")) {
                            stringBuffer.append(" cc.id = '" + userRedis.getOrgId() + "' ");
                        }
                    } else {
                        flagOr = false;
                    }
                    stringBuffer.append(" ) ");
                } else {
                    stringBuffer.append(" and 1=2");
                }
                sqlTemp = sqlTemp.replace("1=1", stringBuffer.toString());
                sql = sql.replaceFirst("1=1", sqlTemp);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(volist = this.tmUserDao.findTmUserList(tmUserVo, page, sql)))) {
            this.extendUserInfo(volist);
            for (TmUserVo userVo : volist) {
                if (StringUtil.isEmpty((String)userVo.getParentUserName()) || !userVo.getParentUserName().contains(",")) continue;
                Object[] userArray = userVo.getParentUserName().split(",");
                HashSet userSet = Sets.newHashSet((Object[])userArray);
                String newParentUser = StringUtil.join((Collection)userSet, (String)",");
                userVo.setParentUserName(newParentUser);
            }
        }
        return volist;
    }

    private void extendUserInfo(List<TmUserVo> volist) {
        String inSql = "SELECT rup.user_id id,   rup.position_id positionId,   p.position_code positionCode,   p.position_name positionName,   p.position_level positionLevel,   tr.org_name orgName,   tr.id orgId,   prp.position_name parentPositionName,  prp.id parentPositionId,  ppu.fullname parentUserName,  ppu.id parentUserId FROM tm_r_user_position rup   LEFT JOIN tm_position p  ON p.id = rup.position_id  LEFT JOIN tm_org tr  ON p.org_id = tr.id  LEFT JOIN tm_position prp  ON prp.id = p.parent_id  LEFT JOIN tm_r_user_position ptup  ON (ptup.position_id=prp.id  )   LEFT JOIN tm_user pu  ON pu.id  =rup.user_id left join tm_user ppu on ppu.id=ptup.user_id where 1=1 ";
        if (!CollectionUtils.isEmpty(volist)) {
            HashSet userSet = new HashSet();
            String userIds = volist.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getId())).collect(Collectors.mapping(TmUserVo::getId, Collectors.joining(",")));
            inSql = inSql + SqlUtil.setSqlIn((String[])userIds.split(","), (String)"pu.id", (boolean)true, null);
            List tempList = this.tmUserDao.findTmUserList(new TmUserVo(), null, inSql);
            HashMap infoMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)tempList)) {
                Map<String, List<TmUserVo>> userMap = tempList.stream().collect(Collectors.groupingBy(TmUserVo::getId));
                volist.stream().map(u -> this.toTmUserVo((List)userMap.get(u.getId()), u)).collect(Collectors.toList());
            }
        }
    }

    private TmUserVo toTmUserVo(List<TmUserVo> users, TmUserVo result) {
        if (CollectionUtil.listNotEmptyNotSizeZero(users)) {
            result.setOrgId(users.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getOrgId())).collect(Collectors.mapping(TmUserVo::getOrgId, Collectors.joining(","))));
            result.setOrgName(users.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getOrgName())).collect(Collectors.mapping(TmUserVo::getOrgName, Collectors.joining(","))));
            result.setPositionId(users.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getPositionId())).collect(Collectors.mapping(TmUserVo::getPositionId, Collectors.joining(","))));
            result.setPositionCode(users.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getPositionCode())).collect(Collectors.mapping(TmUserVo::getPositionCode, Collectors.joining(","))));
            result.setPositionName(users.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getPositionName())).collect(Collectors.mapping(TmUserVo::getPositionName, Collectors.joining(","))));
            result.setPositionLevel(users.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getPositionLevel())).collect(Collectors.mapping(TmUserVo::getPositionLevel, Collectors.joining(","))));
            result.setParentPositionName(users.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getParentPositionName())).collect(Collectors.mapping(TmUserVo::getParentPositionName, Collectors.joining(","))));
            result.setParentPositionId(users.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getParentPositionId())).collect(Collectors.mapping(TmUserVo::getParentPositionId, Collectors.joining(","))));
            result.setParentUserName(users.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getParentUserName())).collect(Collectors.mapping(TmUserVo::getParentUserName, Collectors.joining(","))));
            result.setParentUserId(users.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getParentUserId())).collect(Collectors.mapping(TmUserVo::getParentUserId, Collectors.joining(","))));
        }
        return result;
    }

    public String appendUserCondition(String sql, TmUserVo userVo, String table) {
        String sqlWhere = "";
        boolean sqlJoinFlag = false;
        if (StringUtil.isNotEmpty((String)userVo.getId())) {
            sqlWhere = sqlWhere + " and t.id='" + userVo.getId() + "'";
        }
        if (StringUtil.isNotEmpty((String)userVo.getOrgId())) {
            sqlJoinFlag = true;
            sqlWhere = sqlWhere + " and t1.orgId = '" + userVo.getOrgId() + "'";
        }
        if (StringUtil.isNotEmpty((String)userVo.getOrgName())) {
            sqlJoinFlag = true;
            sqlWhere = sqlWhere + " and t1.orgName like '%" + userVo.getOrgName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)userVo.getPositionName())) {
            sqlJoinFlag = true;
            sqlWhere = sqlWhere + " and t1.positionName like '%" + userVo.getPositionName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)userVo.getParentPositionName())) {
            sqlWhere = sqlWhere + " and t1.parentPositionName like '%" + userVo.getParentPositionName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)userVo.getParentUserName())) {
            sqlWhere = sqlWhere + " and t1.parentUserName like '%" + userVo.getParentUserName() + "%'";
        }
        if (StringUtils.isNotBlank((CharSequence)userVo.getEnableStatus())) {
            sqlWhere = sqlWhere + " and t.enableStatus = '" + userVo.getEnableStatus() + "'";
        }
        if (userVo.getUserType() != null) {
            sqlWhere = sqlWhere + " and t.userType = 0";
        }
        String orderSql = "";
        if (StringUtil.isNotBlank((String)userVo.getSort()) && StringUtil.isNotBlank((String)userVo.getOrder())) {
            KnlDictDataEntity tagerEntity;
            KnlDictDataEntity knlDictDataEntity = DictUtil.getDicData((String)Globals.mdm_table, (String)(table + "_"));
            if (knlDictDataEntity != null && StringUtil.isNotBlank((String)knlDictDataEntity.getDictCode()) && StringUtil.isNotBlank((String)(tagerEntity = DictUtil.getDictByParentIdAndDictCode((String)knlDictDataEntity.getId(), (String)userVo.getSort())).getDictValue())) {
                String c = tagerEntity.getDictValue();
                orderSql = " order by " + c + " " + userVo.getOrder();
            }
        } else {
            orderSql = " order by t.updateDate desc ";
        }
        String sqlOn = " t1.user_id = t.id";
        String joinSql = "";
        if (sqlJoinFlag) {
            joinSql = " select a.USER_ID ,c.id as orgId,c.ORG_NAME as orgName,b.POSITION_NAME as positionName from tm_r_user_position a left join tm_position b on a.POSITION_ID = b.id left join tm_org c on c.id = b.ORG_ID where a.is_main    = 0 ";
        }
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, joinSql, sqlOn, sqlWhere, orderSql);
    }

    public TmUserVo getTmUserVo(String id) {
        TmUserVo vo = null;
        if (StringUtils.isBlank((CharSequence)id)) {
            return vo;
        }
        TmUserEntity tmUserEntity = (TmUserEntity)this.get(TmUserEntity.class, (Serializable)((Object)id));
        if (tmUserEntity == null) {
            throw new BusinessException("\u627e\u4e0d\u5230\u804c\u4f4dEntity\u5b9e\u4f53:" + id);
        }
        vo = new TmUserEntityToTmUserVo((TmUserService)this).apply(tmUserEntity);
        return vo;
    }

    public void saveTmUser(TmUserVo tmUserVo, Page page) {
        TmUserEntity tmUserEntity = null;
        String userId = "";
        if (StringUtil.isNotEmpty((Object)this.tmUserExtendService)) {
            try {
                this.tmUserExtendService.validate(tmUserVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u6821\u9a8c\u5931\u8d25:" + e.getMessage());
            }
            tmUserEntity = this.tmUserExtendService.saveBefore(tmUserVo, page);
        }
        if (tmUserEntity == null) {
            TmUserVoToTmUserEntity tmUserVoToTmUserEntity = new TmUserVoToTmUserEntity((TmUserService)this, this.passwdService);
            tmUserEntity = tmUserVoToTmUserEntity.apply(tmUserVo);
            userId = tmUserEntity.getId();
        }
        if (StringUtil.isNotEmpty((Object)this.tmUserExtendService)) {
            tmUserEntity = this.tmUserExtendService.saveBefore(tmUserEntity, tmUserVo, page);
        }
        if (StringUtil.isNotEmpty((String)tmUserEntity.getUserName())) {
            this.updatePassSusTimes(tmUserEntity.getUserName());
        }
        this.saveOrUpdate((Object)tmUserEntity);
        if (StringUtil.isNotEmpty((Object)this.tmUserExtendService)) {
            tmUserEntity = this.tmUserExtendService.savePost(tmUserEntity, tmUserVo, page);
        }
        String hql = "FROM TmUserPositionEntity where tmUser.id is null";
        List list = this.findByHql(hql, new Object[0]);
        for (TmUserPositionEntity userPosition : list) {
            String userPostId = userPosition.getId();
            super.addLogAndRemoveInvalidInfo(userPostId, (Object)userPosition, userId, null);
        }
        this.executeSql("DELETE FROM TM_R_USER_POSITION WHERE USER_ID IS NULL", new Object[0]);
    }

    public void updatePassSusTimes(String username) {
        String key = "MDM_LOGIN_COUNT_" + username;
        if (this.redisService != null) {
            this.redisService.del(new String[]{key});
        }
        String hql = " from TmUserEntity where enableStatus = '009' and userName=?";
        List list = this.findByHql(hql, new Object[]{username});
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            String sql = "update tm_user set LOGIN_ERR_TIMES = null where username = ?";
            this.executeSql(sql, new Object[]{username});
        }
    }

    public void deleteTmUser(String ids, Page page) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] userIds;
            for (String userId : userIds = ids.split(",")) {
                TmUserEntity userEntity = (TmUserEntity)this.get(TmUserEntity.class, (Serializable)((Object)userId));
                if (userEntity == null || !StringUtil.isNotEmpty((String)userEntity.getId())) continue;
                this.delete((Object)userEntity);
            }
        }
    }

    public void deleteLockTmUser(String ids) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] userIds;
            for (String userId : userIds = ids.split(",")) {
                TmUserEntity userEntity = (TmUserEntity)this.get(TmUserEntity.class, (Serializable)((Object)userId));
                this.loginService.updatePassSusTimes(userEntity.getUserName());
            }
        }
    }

    public ValidForm valideTmUser(TmUserVo tmUserVo, String param) {
        ValidForm validForm = new ValidForm();
        String hql = "";
        if (StringUtil.isNotEmpty((String)tmUserVo.getId())) {
            hql = "from TmUserEntity where userName=? and id<>? and enableStatus=?";
            List list = this.findByHql(hql, new Object[]{param, tmUserVo.getId(), Globals.ZERO});
            if (!CollectionUtils.isEmpty((Collection)list)) {
                validForm.setInfo("\u767b\u5f55\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728");
                validForm.setStatus("n");
            }
        } else {
            hql = "from TmUserEntity where userName=? and enableStatus=?";
            List list = this.findByHql(hql, new Object[]{param, Globals.ZERO});
            if (!CollectionUtils.isEmpty((Collection)list)) {
                validForm.setInfo("\u767b\u5f55\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728");
                validForm.setStatus("n");
            }
        }
        return validForm;
    }

    public AjaxJson startOrStopTmuser(TmUserVo tmUserVo) {
        AjaxJson j = new AjaxJson();
        TmUserEntity tmUserEntity = (TmUserEntity)this.get(TmUserEntity.class, (Serializable)((Object)tmUserVo.getId()));
        if (StringUtil.isNotEmpty((Object)tmUserEntity)) {
            if (tmUserEntity.getEnableStatus().toString().equals(tmUserVo.getEnableStatus().toString())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.equals(tmUserVo.getEnableStatus()) ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                tmUserEntity.setEnableStatus(tmUserVo.getEnableStatus());
                tmUserEntity.setLoginErrTimes(Integer.valueOf(Globals.User_Normal.intValue()));
                this.updateEntity((Object)tmUserEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }

    public TmUserVo getTmUser(TmUserVo tmUserVo) {
        return this.tmUserDao.getTmUser(tmUserVo);
    }

    public AjaxJson changeTmuserPassword(TmUserVo tmUserVo) {
        TmUserEntity userEntity;
        AjaxJson json = new AjaxJson();
        if (StringUtil.isEmpty((String)tmUserVo.getPassword()) || StringUtil.isEmpty((String)tmUserVo.getNewpassword())) {
            json.setSuccess(false);
            json.setMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            return json;
        }
        String password = Md5EncryptionAndDecryption.encryPwd((String)tmUserVo.getPassword());
        if (!password.equals((userEntity = ResourceUtil.getSessionUserName()).getPassword())) {
            json.setSuccess(false);
            json.setMsg("\u539f\u5bc6\u7801\u4e0d\u4e00\u81f4,\u8bf7\u91cd\u65b0\u8f93\u5165\u539f\u5bc6\u7801");
            return json;
        }
        String sql = "update tm_user set password = ? , update_date = ? , update_name = ? where id=?";
        int flag = this.executeSql(sql, new Object[]{Md5EncryptionAndDecryption.encryPwd((String)tmUserVo.getNewpassword()), new Date(), ResourceUtil.getSessionUserName().getUserName(), userEntity.getId()});
        if (flag > 0) {
            Client client = ResourceUtil.getClient();
            userEntity.setPassword(Md5EncryptionAndDecryption.encryPwd((String)tmUserVo.getNewpassword()));
            ResourceUtil.setClient((Client)client);
        }
        return json;
    }

    public AjaxJson changeFirstTmPassword(TmUserVo tmUserVo) {
        TmUserEntity userEntity;
        AjaxJson json = new AjaxJson();
        if (StringUtil.isEmpty((String)tmUserVo.getPassword()) || StringUtil.isEmpty((String)tmUserVo.getNewpassword())) {
            json.setSuccess(false);
            json.setMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            return json;
        }
        String password = Md5EncryptionAndDecryption.encryPwd((String)tmUserVo.getPassword());
        if (!password.equals((userEntity = ResourceUtil.getSessionUserName()).getPassword())) {
            json.setSuccess(false);
            json.setMsg("\u539f\u5bc6\u7801\u4e0d\u4e00\u81f4,\u8bf7\u91cd\u65b0\u8f93\u5165\u539f\u5bc6\u7801");
            return json;
        }
        userEntity.setPassword(Md5EncryptionAndDecryption.encryPwd((String)tmUserVo.getNewpassword()));
        userEntity.setHasFirstTime(Integer.valueOf(0));
        this.saveOrUpdate((Object)userEntity);
        return json;
    }

    public List<TmUserVo> findTmUserByAllPossible(QueryTmuserVo queryTmuserVo, Page page) {
        return this.tmUserDao.findTmUserByAllPossible(queryTmuserVo, page);
    }

    public List<TmUserVo> findTmCustUserByAllPossible(QueryTmuserVo queryTmuserVo, Page page) {
        return this.tmUserDao.findTmCustUserByAllPossible(queryTmuserVo, page);
    }

    public List<TmUserVo> getTmUserBySearch(TmUserVo tmUserVo, Page page) {
        QueryTmuserVo queryTmuserVo = new QueryTmuserVo();
        if (StringUtil.isNotEmpty((String)tmUserVo.getSearchParam())) {
            queryTmuserVo.setFullName(tmUserVo.getSearchParam());
        }
        return this.tmUserDao.findTmUserByAllPossible(queryTmuserVo, page);
    }

    public List<TmUserVo> getTmUserList(TmUserVo tmUserVo) {
        return this.tmUserDao.getTmUserList(tmUserVo);
    }

    public UserInfoEntity findUserInfoEntityByPosId(String posId) {
        String nowDate = DateUtils.dateNow2Str();
        return this.tmUserDao.findUserInfoEntityByPosId(posId, nowDate);
    }

    public int getUserTypeByUserName(String userName) {
        int userType = -1;
        TmUserEntity user = (TmUserEntity)this.findUniqueByProperty(TmUserEntity.class, "userName", (Object)userName);
        if (StringUtil.isNotEmpty((Object)user) && StringUtil.isNotEmpty((Object)user.getUserType())) {
            userType = user.getUserType();
        }
        return userType;
    }

    public List<TmUserEntity> findBelowOrgUserByOrgCode(String orgCode) {
        return this.tmUserDao.findBelowOrgUserByOrgCode(orgCode);
    }

    public List<TmUserEntity> findOrgUserByOrgCode(String orgCode) {
        return this.tmUserDao.findOrgUserByOrgCode(orgCode);
    }

    public List<TmUserEntity> findBelowPosIdUserByPosId(String posId) {
        return this.tmUserDao.findBelowPosIdUserByPosId(posId);
    }

    public List<TmUserEntity> findPosIdUserByPosId(String posId) {
        return this.tmUserDao.findPosIdUserByPosId(posId);
    }

    public List<TmUserEntity> findUserByPosCode(String positionCode) {
        return this.tmUserDao.findUserByPosCode(positionCode);
    }
}

