<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<link rel="stylesheet" href="resources/accordion/css/icons.css" type="text/css"></link>
<link rel="stylesheet" href="resources/accordion/css/accordion.css" type="text/css"></link>
<body class="easyui-layout">
<style>
    td[field='joinType'] input.combobox-f.combo-f,
    td[field="isHidden"] input.combobox-f.combo-f,
    td[field="queryStatus"] input.combobox-f.combo-f,
    td[field="queryMode"] input.combobox-f.combo-f,
    td[field="importOut"] input.combobox-f.combo-f,
    td[field="formType"] input.combobox-f.combo-f,
    td[field="addShowMode"] input.combobox-f.combo-f,
    td[field="updateShowMode"] input.combobox-f.combo-f,
    td[field="required"] input.combobox-f.combo-f {
        display: none !important;
    }


    td[field='joinType'] span.combo-arrow,
    td[field="isHidden"] span.combo-arrow,
    td[field="queryStatus"] span.combo-arrow,
    td[field="queryMode"] span.combo-arrow,
    td[field="importOut"] span.combo-arrow,
    td[field="formType"] span.combo-arrow,
    td[field="addShowMode"] span.combo-arrow,
    td[field="updateShowMode"] span.combo-arrow,
    td[field="required"] span.combo-arrow {
        margin: 0;
        background: url(/resources/easyui/themes/default/images/combo_arrow.png) no-repeat center center;
    }
    input[type=text], select{
        line-height: 20px !important;
        height: 20px !important;
    }
</style>
<div region="center" fit="true" style="">

    <t:datagrid name="tableConfigList" title="字段列表"
                actionUrl="tmTableConfigController.do?tableConfigGrid&tableName=${tableName}" idField="id" fit="true"
                fitColumns="false" pagination="false">
    <!--主表头 -->
        <%-- <t:dgCol title="基础信息" field="" colspan="4"></t:dgCol> --%>
        <t:dgCol title="关联信息" field="" colspan="6"></t:dgCol>
        <t:dgCol title="列表信息" field="" colspan="9"></t:dgCol>
        <t:dgCol title="表单信息" field="" colspan="13"></t:dgCol>


    <!-- 基础信息 begin -->
        <t:dgCol title="主键" field="id" hidden="true" frozenColumn="true"></t:dgCol>
        <t:dgCol title="字段名称" field="columnName" width="120" frozenColumn="true"></t:dgCol>
        <t:dgCol title="字段描述" field="columnDesc" width="200" frozenColumn="true"></t:dgCol>
        <t:dgCol title="字段类型" field="columnType" width="100" frozenColumn="true"></t:dgCol>
        <t:dgCol title="属性名称" field="field" width="80" frozenColumn="true"></t:dgCol>
    <!-- 基础信息 end -->

    <!-- 关联信息 begin -->
        <t:dgCol title="关联表名" field="joinTable" width="80" editor="text"></t:dgCol>
        <t:dgCol title="关联别名" field="alias" width="80" editor="text"></t:dgCol>
        <t:dgCol title="关联类型" field="joinType" width="60" dictionary="join_type" editor="combobox"></t:dgCol>
        <t:dgCol title="关联条件" field="joinOn" width="60" editor="text"></t:dgCol>
        <t:dgCol title="查询字段" field="joinColumn" width="120" editor="text"></t:dgCol>
        <t:dgCol title="字段属性" field="showColumn" width="120" editor="text"></t:dgCol>
    <!-- 关联信息 end -->

    <!-- 显示信息 begin -->
        <t:dgCol title="标题名称" field="fieldName" width="60" editor="text"></t:dgCol>
        <t:dgCol title="显示属性" field="fieldProperty" width="70" editor="text"></t:dgCol>
        <t:dgCol title="是否隐藏" field="isHidden" width="60" editor="combobox" dictionary="yesorno"></t:dgCol>
        <t:dgCol title="显示宽度" field="fielWidth" width="60"
                 editor="{type:'numberbox',options:{min:1,value:''}}"></t:dgCol>
        <t:dgCol title="显示排序" field="columnOrder" width="60"
                 editor="{type:'numberbox',options:{min:1,value:''}}"></t:dgCol>
        <t:dgCol title="格式化" field="format" width="80" editor="text"></t:dgCol>
        <t:dgCol title="是否查询" field="queryStatus" width="60" editor="combobox" dictionary="yesorno"></t:dgCol>
        <t:dgCol title="查询模式" field="queryMode" width="65" editor="combobox" dictionary="searchmode"></t:dgCol>
        <t:dgCol title="数据字典" field="dictType" width="80" editor="text"></t:dgCol>
        <t:dgCol title="是否导出" field="importOut" width="80" editor="combobox" dictionary="yesorno"></t:dgCol>
    <!-- 显示信息 end -->

    <!-- 表单信息 begin -->
        <t:dgCol title="标签名称" field="formName" width="90" editor="text"></t:dgCol>
        <t:dgCol title="表单类型" field="formType" width="80" editor="combobox" dictionary="form_type"></t:dgCol>
        <t:dgCol title="新增显示模式" field="addShowMode" width="80" editor="combobox" dictionary="show_mode"></t:dgCol>
        <t:dgCol title="编辑显示模式" field="updateShowMode" width="80" editor="combobox" dictionary="show_mode"></t:dgCol>
        <t:dgCol title="表单排序" field="formOrder" width="60" editor="{type:'numberbox',options:{min:1,value:''}}"></t:dgCol>
        <t:dgCol title="表单数据源" field="formUrl" width="100" editor="text"></t:dgCol>
        <t:dgCol title="表单验证" field="dataType" width="100" editor="text"></t:dgCol>
        <t:dgCol title="错误提示" field="errorMsg" width="120" editor="text"></t:dgCol>
        <t:dgCol title="是否必填" field="required" width="80" editor="combobox" dictionary="yesorno"></t:dgCol>
        <t:dgCol title="表单提示" field="inputMsg" width="80" editor="text"></t:dgCol>
        <t:dgCol title="日期格式化" field="formFormat" width="80" editor="text"></t:dgCol>
        <t:dgCol title="表单扩展" field="formExtend" width="120" editor="text"></t:dgCol>
        <t:dgCol title="导入属性" field="importField" width="80" editor="text"></t:dgCol>
        <t:dgCol title="导入列标题" field="importTitle" width="80" editor="text"></t:dgCol>
        <t:dgCol title="监听函数" field="onclick" width="80" editor="text"></t:dgCol>
        <t:dgCol title="是否排序" field="sortable" width="80" editor="combobox"  dictionary="yesorno"></t:dgCol>
    <!-- 表单信息 begin -->

        <t:dgToolBar operationCode="save" title="保存" icon="icon-save" url="" funname="doSave"></t:dgToolBar>
        <t:dgToolBar operationCode="log" title="日志" icon="icon-log" url="tmLogController.do?goTmLogDetailMain" funname="detailLog"
                     width="1200" height="460"></t:dgToolBar>
    </t:datagrid>
    </dv>
</body>

<script type="text/javascript">

  $(document).ready(function (){
    //初始化编码器，及添加单击行事件开始编辑
    $("#tableConfigList").datagrid({
      onClickRow: function (rowIndex, rowData){
        $(this).datagrid('beginEdit', rowIndex);
        //
        var editors = $(this).datagrid('getEditors', rowIndex);
        $.each(editors, function (index, editor){
          if (editor.type == "combobox") {
            var ed = $("#tableConfigList").datagrid('getEditor', { index: rowIndex, field: editor.field });
            if (editor.field == "queryMode") {
              $(ed.target).combobox('reload', "tmTableConfigController.do?dictCombox&dictCode=searchmode");
            } else if (editor.field == "formType") {
              $(ed.target).combobox('reload', "tmTableConfigController.do?dictCombox&dictCode=form_type");
            } else if (editor.field == "joinType") {
              $(ed.target).combobox('reload', "tmTableConfigController.do?dictCombox&dictCode=join_type");
            } else if (editor.field == "addShowMode" || editor.field == "updateShowMode") {
              $(ed.target).combobox('reload', "tmTableConfigController.do?dictCombox&dictCode=show_mode");
            } else {
              $(ed.target).combobox('reload', "tmTableConfigController.do?dictCombox&dictCode=yesorno");
            }
          }
        });
      }
    });
  });

  //保存操作
  function doSave(){
    var rows = $("#tableConfigList").datagrid("getRows");
    $.each(rows, function (index, row){
      var rowIndex = $("#tableConfigList").datagrid("getRowIndex", row);
      $("#tableConfigList").datagrid('endEdit', rowIndex);
    });

    var updated = $("#tableConfigList").datagrid("getChanges", "updated");
    var updateds = [];
    $.messager.confirm('确认', "是否确定保存所有数据？", function (r){
      if (r) {
        $.ajax({
          url: "tmTableConfigController.do?saveTableConfig",
          type: 'post',
          data: { saveJsonData: JSON.stringify(updated) },
          cache: false,
          success: function (data){
            if (data.success) {
              var msg = data.msg;
              $.messager.show({
                title: '提示',
                msg: msg,
                timeout: 3000,
                showType: 'slide'
              });
              $("#tableConfigList").datagrid("reload");
            }
          }
        });
      }
    });
  }

</script>

