<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,autocomplete"></t:base>
<div id="tmMaintainPositionMain" class="easyui-layout" fit="true">
	<div data-options="region:'west',border:false,split:true" style="width:450px">
		<div class="easyui-layout" fit="true">

			<div data-options="region:'north',border:false,split:true" style="height:360px">
				<t:datagrid name="noAnyRolePositionList" title="未关联任何客户的终端" fit="true" fitColumns="true" checkbox="true"
							singleSelect="false" actionUrl="tmTermCustPostController.do?findNotAnyCustTerminalList" idField="id" queryMode="group">
					<t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
					<t:dgCol title="终端编码" field="terminalCode"  query="true" ></t:dgCol>
					<t:dgCol title="终端名称" field="terminalName" query="true"  ></t:dgCol>
					<t:dgCol title="终端类型" field="terminalType"   dictionary="terminal_type" ></t:dgCol>
					<t:dgCol title="终端地址" field="address"></t:dgCol>
					<t:dgCol title="客户组织" field="custOrgName" query="true"></t:dgCol>
					<t:dgCol title="组织" field="orgName" query="true"></t:dgCol>
					<t:dgCol title="省"  field="province" query="true"></t:dgCol>
					<t:dgCol title="市"  field="city" query="true"></t:dgCol>
					<t:dgCol title="区"  field="area" query="true"></t:dgCol>
					<t:dgToolBar title="添加关联"  icon="icon-add" url="tmTermCustPostController.do?addRelotaionForCustomerId&customerId=${customerId}" funname="addTerminalCustRelation"></t:dgToolBar>
				</t:datagrid>
			</div>

			<div data-options="region:'center',split:true,border:false">
				<t:datagrid name="noThisRolePositionList" title="未关联该客户的终端" fit="true" fitColumns="true" checkbox="true"
							singleSelect="false" actionUrl="tmTermCustPostController.do?findNotCurrCustTerminalList&customerId=${customerId}" idField="id" queryMode="group">
					<t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
					<t:dgCol title="终端编码" field="terminalCode"  query="true" ></t:dgCol>
					<t:dgCol title="终端名称" field="terminalName" query="true"  ></t:dgCol>
					<t:dgCol title="终端类型" field="terminalType"   dictionary="terminal_type" ></t:dgCol>
					<t:dgCol title="终端地址" field="address" ></t:dgCol>
					<t:dgCol title="客户组织" field="custOrgName" query="true"></t:dgCol>
					<t:dgCol title="组织" field="orgName" query="true"></t:dgCol>
					<t:dgCol title="省"  field="province" query="true"></t:dgCol>
					<t:dgCol title="市"  field="city" query="true"></t:dgCol>
					<t:dgCol title="区"  field="area" query="true"></t:dgCol>
					<t:dgCol title="上级客户编码"  field="customerCode" ></t:dgCol>
					<t:dgCol title="上级客户名称"  field="customerName" ></t:dgCol>
					<t:dgToolBar title="添加关联"  icon="icon-add" url="tmTermCustPostController.do?addRelotaionForCustomerId&customerId=${customerId}" funname="addTerminalCustRelation"></t:dgToolBar>
				</t:datagrid>
			</div>

		</div>
	</div>

	<div data-options="region:'center',split:true,border:false">
		<t:datagrid name="thisRolePositionList" title="已关联该客户的终端" fit="true" fitColumns="true" checkbox="true"
					singleSelect="false" actionUrl="tmTermCustPostController.do?findTmTermCustPostList&customerId=${customerId}" idField="id" queryMode="group">
			<t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
			<t:dgCol title="终端编码" field="terminalCode"  query="true" ></t:dgCol>
			<t:dgCol title="终端名称" field="terminalName" query="true"  ></t:dgCol>
			<t:dgCol title="客户组织" field="custOrgName" query="true"></t:dgCol>
			<t:dgCol title="组织" field="orgName" query="true"></t:dgCol>
			<t:dgCol title="省" field="province" query="true"></t:dgCol>
			<t:dgCol title="市" field="city" query="true"></t:dgCol>
			<t:dgCol title="区" field="area" query="true"></t:dgCol>
			<t:dgCol title="对接人职位编码"  field="positionCode" ></t:dgCol>
			<t:dgCol title="对接人职位名称"  field="positionName"  ></t:dgCol>
			<t:dgToolBar title="解除上级客户"  icon="icon-remove" url="tmTermCustPostController.do?deleteRelotaion&flag=1" funname="deleteRelotaionForCustomerId"></t:dgToolBar>
			<t:dgToolBar title="替换上级客户"  icon="icon-edit" url="tmTermCustPostController.do?goSelectNewCustomer&customerId=${customerId}" funname="updateTerminalCustRelation"></t:dgToolBar>
			<t:dgToolBar title="替换对接职位"  icon="icon-edit" url="tmTermCustPostController.do?goSelectNewPosition" funname="updatePositionTermRelation"></t:dgToolBar>
		</t:datagrid>
	</div>

</div>
<script type="text/javascript">
	function addTerminalCustRelation(title, url, gname, width, height, params) {
		var rows = $("#" + gname).datagrid("getSelections");
        if(rows == null || rows == ""){
            tip("请至少选择一条数据");
            return false;
        }

        var ids = [];
        for ( var i = 0; i < rows.length; i++) {
            ids.push(rows[i].id);
        }

        $.ajax({
            url : url,
            type : 'post',
            data : {terminalIds : ids.join(',')},
            cache : false,
            success : function(data) {
                var d = data;
                var msg = d.msg;
                if (d.success) {
                    tip(msg,'info');
                    reloadDataGrid(gname);
                }else{
                    tip(msg,'error');
                    return;
                }
            },
            error:function(){
                tip("客户端请求错误",'error');
                return false;
            }
        });
    }


    function updatePositionTermRelation(title, url, gname, width, height, params) {
        var rows = $("#" + gname).datagrid("getSelections");
        if(rows == null || rows == ""){
            tip("请至少选择一条数据");
            return false;
        }

        var ids = [];
        for ( var i = 0; i < rows.length; i++) {
            ids.push(rows[i].id);
        }

        var relationIds = ids.join(',');

        url += "&relationIds=" + relationIds;

        $.dialog({
            title : title,
            content : "url:" + url,
            lock : true,
            width : "500",
            height : "400",
            zIndex : 10000,
            parent : windowapi,
            ok : function() {
                iframe = this.iframe.contentWindow;
                var relationIds = iframe.$("#relationIds").val();
                var row = iframe.$("#custList").datagrid("getSelected");

                if(row == null || row == "") {
                    iframe.tip("请选择一条数据");
                    return false;
                }

                var positionId = row.id;

                $.ajax({
                    url : "tmTermCustPostController.do?updatePostTerminalRelation",
                    type : 'post',
                    data : {relationIds:relationIds,positionId:positionId},
                    cache : false,
                    success : function(data) {
                        var d = data;
                        var msg = d.msg;
                        if (d.success) {
                            tip(msg,'info');
                            $("#thisRolePositionList").datagrid("reload");
                        }else{
                            tip(msg,'error');
                            return;
                        }
                    },
                    error:function(){
                        tip("职位端请求错误",'error');
                        return false;
                    }
                });
            },
            cancelVal : '关闭',
            cancel : true
        });

    }

    function deleteRelotaionForCustomerId(title, url, gname, width, height, params) {
        var rows = $("#" + gname).datagrid("getSelections");
        if(rows == null || rows == ""){
            tip("请至少选择一条数据");
            return false;
        }

        var ids = [];
        for ( var i = 0; i < rows.length; i++) {
            ids.push(rows[i].id);
        }

        getSafeJq().dialog.confirm("你确定移除该数据吗?", function(r) {
            if (r) {
                $.ajax({
                    url : url,
                    type : 'post',
                    data : {ids : ids.join(',')},
                    cache : false,
                    success : function(data) {
                        var d = data;
                        var msg = d.msg;
                        if (d.success) {
                            tip(msg,'info');
                            reloadDataGrid(null);
                        }else{
                            tip(msg,'error');
                            return;
                        }
                    },
                    error:function(){
                        tip("客户端请求错误",'error');
                        return false;
                    }
                });
            }
        });
    }

    function updateTerminalCustRelation(title, url, gname, width, height, params) {
        var rows = $("#" + gname).datagrid("getSelections");
        if(rows == null || rows == ""){
            tip("请至少选择一条数据");
            return false;
        }

        var ids = [];
        for ( var i = 0; i < rows.length; i++) {
            ids.push(rows[i].id);
        }

      	var relationIds = ids.join(',');

		url += "&relationIds=" + relationIds;

        $.dialog({
            title : title,
            content : "url:" + url,
            lock : true,
            width : "500",
            height : "400",
            zIndex : 10000,
            parent : windowapi,
            ok : function() {
                iframe = this.iframe.contentWindow;
                var relationIds = iframe.$("#relationIds").val();
                var row = iframe.$("#custList").datagrid("getSelected");

                if(row == null || row == "") {
                    iframe.tip("请选择一条数据");
                    return false;
                }

                var customerId = row.id;

                $.ajax({
                    url : "tmTermCustPostController.do?updateCustTerminalRelation",
                    type : 'post',
                    data : {relationIds:relationIds,customerId:customerId},
                    cache : false,
                    success : function(data) {
                        var d = data;
                        var msg = d.msg;
                        if (d.success) {
                            tip(msg,'info');
                            $("#thisRolePositionList").datagrid("reload");
                        }else{
                            tip(msg,'error');
                            return;
                        }
                    },
                    error:function(){
                        tip("客户端请求错误",'error');
                        return false;
                    }
                });
            },
            cancelVal : '关闭',
            cancel : true
        });

    }

    function reloadDataGrid(gname) {
	    if(gname==null){
            $("#noAnyRolePositionList").datagrid("reload");
            $("#noThisRolePositionList").datagrid("reload");
		}else{
            $("#"+gname).datagrid("reload");
		}

        $("#thisRolePositionList").datagrid("reload");
	}
</script>