/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.busarea.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.busarea.TmBusinessAreaVo;
import com.biz.eisp.busarea.dao.BusareaDao;
import com.biz.eisp.busarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.busarea.service.BusareaService;
import com.biz.eisp.position.service.PositionService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class BusareaServiceImpl
implements BusareaService {
    @Autowired
    private PositionService positionService;
    @Autowired
    private BusareaDao busareaDao;

    @Override
    public List<TmBusinessAreaVo> getBusareaList(String id, String code, String areaLevel) {
        if (StringUtil.isEmpty((String)areaLevel)) {
            return this.getBusareaList(id, code);
        }
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            return this.busareaDao.getBusareaList(id, areaLevel);
        }
        if (StringUtil.isEmpty((String)id) && StringUtil.isNotEmpty((CharSequence)code)) {
            List<TmBusinessAreaVo> listOne = this.getBusareaList(id, code);
            if (CollectionUtil.listNotEmptyNotSizeZero(listOne)) {
                String idCode = listOne.get(0).getId();
                return this.busareaDao.getBusareaList(idCode, areaLevel);
            }
            return null;
        }
        return this.busareaDao.getBusareaList(null, areaLevel);
    }

    private List<TmBusinessAreaVo> getBusareaList(String id, String code) {
        Example example = new Example(TmBusinessAreaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isEmpty((String)id) && StringUtil.isNotEmpty((CharSequence)code)) {
            criteria.andEqualTo("code", (Object)code);
        } else if (StringUtil.isEmpty((String)code) && StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        } else {
            return null;
        }
        List list = this.busareaDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            ArrayList<TmBusinessAreaVo> tempList = new ArrayList<TmBusinessAreaVo>();
            list.forEach(vo -> {
                TmBusinessAreaVo tempVo = new TmBusinessAreaVo();
                BeanUtils.copyProperties((Object)vo, (Object)tempVo);
                tempList.add(tempVo);
            });
            return tempList;
        }
        return null;
    }
}

