/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.product.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.page.Page;
import com.biz.eisp.product.TbAttachmentVo;
import com.biz.eisp.product.entity.TmProductInfoEntity;
import com.biz.eisp.product.service.TmProductInfoService;
import com.biz.eisp.productPic.entity.TbAttachmentEntity;
import com.biz.eisp.productPic.service.TbAttachmentService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MDM-\u4ea7\u54c1"}, description="CRM-MDM \u4ea7\u54c1\u4fe1\u606f")
@RestController
@RequestMapping(value={"/mdmApi/productApiCotroller"})
public class ProductApiCotroller {
    @Autowired
    private TmProductInfoService tmProductInfoService;
    @Autowired
    private TbAttachmentService tbAttachmentService;

    @ApiOperation(value="\u67e5\u8be2\u4ea7\u54c1\u5217\u8868", notes="\u67e5\u8be2\u83dc\u5355\u6700\u5e95\u5c42\u5217\u8868,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"findProductInfoByPage"})
    public AjaxJson<TmProductInfoEntity> findProductInfoByPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmProductInfoEntity> tmFunctionEntities = this.tmProductInfoService.findProductInfoByPage(param, page);
        if (tmFunctionEntities.getList() != null && tmFunctionEntities.getList().size() > 0) {
            for (TmProductInfoEntity entity : tmFunctionEntities.getList()) {
                HashMap<String, Object> paramPic = new HashMap<String, Object>();
                paramPic.put("businessKey", entity.getId());
                List<TbAttachmentEntity> tbAttachmentEntities = this.tbAttachmentService.findTbAttachmentList(paramPic);
                ArrayList<TbAttachmentVo> tbAttachmentVos = new ArrayList<TbAttachmentVo>();
                tbAttachmentEntities.forEach(item -> {
                    TbAttachmentVo vo = new TbAttachmentVo();
                    BeanUtils.copyProperties((Object)item, (Object)vo);
                    tbAttachmentVos.add(vo);
                });
                entity.setTbAttachmentVos(tbAttachmentVos);
            }
        }
        ajaxJson.setPageInfo(tmFunctionEntities);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u4ea7\u54c1\u8be6\u60c5", notes="\u67e5\u8be2\u4ea7\u54c1\u8be6\u60c5,\u8fd4\u56de\u503c \u5728obj", httpMethod="POST")
    @PostMapping(value={"getProductInfoDetail"})
    public AjaxJson<TmProductInfoEntity> getProductInfoDetail(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TmProductInfoEntity tmFunctionEntitie = this.tmProductInfoService.getTmProductInfoEntityById(id);
        if (tmFunctionEntitie == null) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e\uff01");
            return ajaxJson;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("businessKey", tmFunctionEntitie.getId());
        List<TbAttachmentEntity> tbAttachmentEntities = this.tbAttachmentService.findTbAttachmentList(param);
        ArrayList<TbAttachmentVo> tbAttachmentVos = new ArrayList<TbAttachmentVo>();
        tbAttachmentEntities.forEach(item -> {
            TbAttachmentVo vo = new TbAttachmentVo();
            BeanUtils.copyProperties((Object)item, (Object)vo);
            tbAttachmentVos.add(vo);
        });
        tmFunctionEntitie.setTbAttachmentVos(tbAttachmentVos);
        ajaxJson.setObj((Object)tmFunctionEntitie);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636eai\u7f16\u7801\u67e5\u8be2\u4ea7\u54c1\u8be6\u60c5", notes="\u6839\u636eai\u7f16\u7801\u67e5\u8be2\u4ea7\u54c1\u8be6\u60c5,\u8fd4\u56de\u503c \u5728obj", httpMethod="POST")
    @PostMapping(value={"getProductInfoDetailByAiCode"})
    public AjaxJson<TmProductInfoEntity> getProductInfoDetailByAiCode(@RequestParam(value="aiCode") String aiCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TmProductInfoEntity tmFunctionEntitie = this.tmProductInfoService.getTmProductInfoEntityByAiCode(aiCode);
        if (tmFunctionEntitie == null) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e\uff01");
            return ajaxJson;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("businessKey", tmFunctionEntitie.getId());
        List<TbAttachmentEntity> tbAttachmentEntities = this.tbAttachmentService.findTbAttachmentList(param);
        ArrayList<TbAttachmentVo> tbAttachmentVos = new ArrayList<TbAttachmentVo>();
        tbAttachmentEntities.forEach(item -> {
            TbAttachmentVo vo = new TbAttachmentVo();
            BeanUtils.copyProperties((Object)item, (Object)vo);
            tbAttachmentVos.add(vo);
        });
        tmFunctionEntitie.setTbAttachmentVos(tbAttachmentVos);
        ajaxJson.setObj((Object)tmFunctionEntitie);
        return ajaxJson;
    }
}

