/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.operation.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.vo.OperationVo;
import com.biz.eisp.operation.dao.TmOperationDao;
import com.biz.eisp.operation.dao.TmRoleFunctionDao;
import com.biz.eisp.operation.entity.TmOperationEntity;
import com.biz.eisp.operation.service.TmRoleFunctionService;
import com.biz.eisp.service.RedisService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class TmRoleFunctionServiceImpl
implements TmRoleFunctionService {
    @Autowired
    private TmRoleFunctionDao tmRoleFunctionDao;
    @Autowired
    private TmOperationDao tmOperationDao;
    @Autowired
    private RedisService redisService;

    @Override
    public List<OperationVo> findNoOperationByUserAndFunId(String userId, String functionId, String version) {
        String key = "NO_OPERATION_USER_FUNID_VERSION_" + userId + functionId + version;
        List<OperationVo> operations = this.findNoOperationByUserAndFunIdData(userId, functionId, version);
        Map<String, Object> map = operations.stream().collect(Collectors.toMap(OperationVo::getOperationCode, operationVo -> operationVo));
        this.redisService.hmset(key, map, 2592000L);
        return operations;
    }

    public List<OperationVo> findNoOperationByUserAndFunIdData(String userId, String functionId, String version) {
        ArrayList<OperationVo> list = new ArrayList<OperationVo>();
        OperationVo operationVo = new OperationVo();
        operationVo.setOperationCode(UUID.randomUUID().toString().replaceAll("-", ""));
        list.add(operationVo);
        if (StringUtil.isEmpty((String)userId) || StringUtil.isEmpty((String)version)) {
            return list;
        }
        String key = "NO_OPERATION_USER_FUNID_VERSION_" + userId + functionId + version;
        this.redisService.del(new String[]{key});
        Example exampleOperation = new Example(TmOperationEntity.class);
        Example.Criteria criteria = exampleOperation.createCriteria();
        criteria.andEqualTo("functionId", (Object)functionId);
        List tmOperationEntities = this.tmOperationDao.selectByExample(exampleOperation);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)tmOperationEntities)) {
            return list;
        }
        List<String> operations = this.tmRoleFunctionDao.getOperationByUserAndFunId(userId, functionId);
        HashMap<String, String> operationMap = new HashMap<String, String>();
        if (!CollectionUtil.listNotEmptyNotSizeZero(operations)) {
            operations = new ArrayList<String>();
        }
        for (String operation : operations) {
            String[] operationArr = operation.split(",");
            for (String temp2 : operationArr) {
                if (!StringUtil.isNotEmpty((CharSequence)temp2)) continue;
                operationMap.put(temp2, temp2);
            }
        }
        List tmOperationEntitiesY = new ArrayList();
        if (!operationMap.isEmpty()) {
            Example example = new Example(TmOperationEntity.class);
            Example.Criteria criteria1 = example.createCriteria();
            criteria1.andIn("id", operationMap.keySet());
            tmOperationEntitiesY = this.tmOperationDao.selectByExample(example);
        }
        tmOperationEntitiesY = CollectionUtil.listEmpty(tmOperationEntitiesY) ? new ArrayList() : tmOperationEntitiesY;
        Map<Object, Object> mapY = new HashMap();
        Map<Object, Object> mapOld = new HashMap();
        mapOld = tmOperationEntities.stream().collect(Collectors.toMap(TmOperationEntity::getId, temp -> temp));
        mapY = tmOperationEntitiesY.stream().collect(Collectors.toMap(TmOperationEntity::getId, temp -> temp));
        for (Map.Entry entry : mapY.entrySet()) {
            if (!mapOld.containsKey(entry.getKey())) continue;
            mapOld.remove(entry.getKey());
        }
        if (mapOld.isEmpty()) {
            return list;
        }
        mapOld.forEach((k, v) -> {
            OperationVo operationVoTemp = new OperationVo();
            operationVoTemp.setOperationCode(v.getOperationCode());
            list.add(operationVoTemp);
        });
        return list;
    }
}

