/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.org.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.org.dao.OrgDao;
import com.biz.eisp.org.entity.TmOrgEntity;
import com.biz.eisp.org.service.OrgService;
import com.biz.eisp.position.entity.TmPositionEntity;
import com.biz.eisp.position.service.PositionService;
import com.biz.eisp.tree.TreeGrid;
import com.biz.eisp.tree.TreeGridModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class OrgServiceImpl
implements OrgService {
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrgDao orgDao;

    @Override
    public TmOrgVo getOrgByPos(String posId, String posCode) {
        TmOrgVo tmOrgVo = null;
        TmPositionEntity tmPositionEntity = this.positionService.getTmPosition(posId, posCode);
        if (tmPositionEntity == null || StringUtil.isEmpty((String)tmPositionEntity.getOrgId())) {
            return tmOrgVo;
        }
        TmOrgEntity tmOrgEntity = (TmOrgEntity)this.orgDao.selectByPrimaryKey(tmPositionEntity.getOrgId());
        if (tmOrgEntity != null) {
            tmOrgVo = new TmOrgVo();
            BeanUtils.copyProperties((Object)tmOrgEntity, (Object)tmOrgVo);
        }
        return tmOrgVo;
    }

    @Override
    public List<TmOrgEntity> getOrgList(String orgId, String orgCode) {
        List<TmOrgEntity> tmOrgEntities = this.orgDao.selectAll();
        if (StringUtil.isEmpty((String)orgCode) && StringUtil.isEmpty((String)orgId)) {
            tmOrgEntities = this.createOrgList(tmOrgEntities, null);
        } else if (StringUtil.isEmpty((String)orgId) && StringUtil.isNotEmpty((CharSequence)orgCode)) {
            Example example = new Example(TmOrgEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("orgCode", (Object)orgCode);
            TmOrgEntity tmOrgEntity = (TmOrgEntity)this.orgDao.selectOneByExample(example);
            if (tmOrgEntity != null) {
                tmOrgEntities = this.createOrgList(tmOrgEntities, tmOrgEntity.getId());
            }
        } else {
            TmOrgEntity tmOrgEntity = (TmOrgEntity)this.orgDao.selectByPrimaryKey(orgId);
            if (tmOrgEntity != null) {
                tmOrgEntities = this.createOrgList(tmOrgEntities, tmOrgEntity.getId());
            }
        }
        return tmOrgEntities;
    }

    private List<TmOrgEntity> createOrgList(List<TmOrgEntity> tmOrgEntities, String targetId) {
        List<TmOrgEntity> orgVos = new ArrayList<TmOrgEntity>();
        HashMap<String, List<TmOrgEntity>> orgListMap = new HashMap<String, List<TmOrgEntity>>();
        tmOrgEntities.stream().collect(Collectors.groupingBy(TmOrgEntity::getParentId, Collectors.toList())).forEach((parentId, list) -> orgListMap.put((String)parentId, (List<TmOrgEntity>)list));
        if (StringUtil.isEmpty((String)targetId)) {
            List orgVosTemp = (List)orgListMap.get("0");
            orgVosTemp.forEach(item -> this.createchildList((Map<String, List<TmOrgEntity>>)orgListMap, (TmOrgEntity)item));
            orgVos = orgVosTemp;
        } else {
            TmOrgEntity tmOrgEntity = (TmOrgEntity)this.orgDao.selectByPrimaryKey(targetId);
            if (tmOrgEntity != null) {
                this.createchildList(orgListMap, tmOrgEntity);
                orgVos.add(tmOrgEntity);
            }
        }
        return orgVos;
    }

    private void createchildList(Map<String, List<TmOrgEntity>> orgListMap, TmOrgEntity entity) {
        List<TmOrgEntity> list = orgListMap.get(entity.getId());
        entity.setTmOrgList(list);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> this.createchildList(orgListMap, (TmOrgEntity)item));
        }
    }

    @Override
    public List<TreeGrid> findTmOrgList(TmOrgVo tmOrgEntity) {
        List<TreeGrid> treeGrids = null;
        String orgId = tmOrgEntity.getId();
        String orgCode = tmOrgEntity.getOrgCode();
        if (null != orgId) {
            List<TmOrgEntity> orgList = this.getOrgList(orgId, orgCode);
            ArrayList<TmOrgVo> orgVos = new ArrayList<TmOrgVo>();
            for (TmOrgEntity entity : orgList) {
                TmOrgVo orgVo = new TmOrgVo();
                BeanUtils.copyProperties((Object)entity, (Object)orgVo);
                orgVos.add(orgVo);
            }
            if (orgVos != null) {
                for (TmOrgVo orgEntity : orgVos) {
                    treeGrids = this.treeGridModel(orgEntity.getTmOrgList());
                }
            }
        } else {
            List<TmOrgEntity> orgList = this.getOrgList(orgId, orgCode);
            ArrayList<TmOrgVo> orgVos = new ArrayList<TmOrgVo>();
            for (TmOrgEntity entity : orgList) {
                TmOrgVo orgVo = new TmOrgVo();
                BeanUtils.copyProperties((Object)entity, (Object)orgVo);
                orgVos.add(orgVo);
            }
            if (orgVos != null) {
                treeGrids = this.treeGridModel(orgVos);
            }
        }
        return treeGrids;
    }

    private List<TreeGrid> treeGridModel(List<TmOrgVo> orgList) {
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("orgCode");
        treeGridModel.setSrc("orgName");
        treeGridModel.setParentId("parentId");
        treeGridModel.setFunctionType("orgType");
        treeGridModel.setIdField("id");
        treeGridModel.setParentText("orgDesc");
        treeGridModel.setChildList("tmOrgList");
        treeGrids = this.treegrid(orgList, treeGridModel);
        return treeGrids;
    }

    private List<TreeGrid> treegrid(List all, TreeGridModel treeGridModel) {
        ArrayList<TreeGrid> treegrid = new ArrayList<TreeGrid>();
        for (Object obj : all) {
            List childList;
            Object icon;
            ReflectHelper reflectHelper = new ReflectHelper(obj);
            TreeGrid tg = new TreeGrid();
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getCode())) {
                String code = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getCode()));
                tg.setCode(code);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getOrder())) {
                String order = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getOrder()));
                tg.setOrder(order);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getIdField())) {
                String id = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getIdField()));
                tg.setId(id);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getSrc())) {
                String src = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getSrc()));
                tg.setSrc(src);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getTextField())) {
                String text = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getTextField()));
                tg.setText(text);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getParentText())) {
                String orgDesc = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getParentText()));
                tg.setParentText(orgDesc);
            }
            if (treeGridModel.getParentId() != null) {
                Object pid = OrgServiceImpl.fieldNametoValues(treeGridModel.getParentId(), obj);
                if (pid != null) {
                    tg.setParentId(pid.toString());
                } else {
                    tg.setParentId("");
                }
            }
            if (treeGridModel.getIcon() != null && (icon = OrgServiceImpl.fieldNametoValues(treeGridModel.getIcon(), obj)) != null) {
                tg.setIcon(icon.toString());
            }
            if ((childList = (List)reflectHelper.getMethodValue(treeGridModel.getChildList())) != null && childList.size() > 0) {
                tg.setState("closed");
            }
            if (treeGridModel.getFieldMap() != null) {
                tg.setFieldMap(new HashMap());
                for (Map.Entry entry : treeGridModel.getFieldMap().entrySet()) {
                    Object fieldValue = reflectHelper.getMethodValue(entry.getValue().toString());
                    tg.getFieldMap().put(entry.getKey(), fieldValue);
                }
            }
            treegrid.add(tg);
        }
        return treegrid;
    }

    public static Object fieldNametoValues(String FiledName, Object o) {
        Object value = "";
        String fieldName = "";
        String childFieldName = null;
        ReflectHelper reflectHelper = new ReflectHelper(o);
        if (FiledName.indexOf("_") == -1) {
            if (FiledName.indexOf(".") == -1) {
                fieldName = FiledName;
            } else {
                fieldName = FiledName.substring(0, FiledName.indexOf("."));
                childFieldName = FiledName.substring(FiledName.indexOf(".") + 1);
            }
        } else {
            fieldName = FiledName.substring(0, FiledName.indexOf("_"));
            childFieldName = FiledName.substring(FiledName.indexOf("_") + 1);
        }
        Object object = value = reflectHelper.getMethodValue(fieldName) == null ? "" : reflectHelper.getMethodValue(fieldName);
        if (value != null && (FiledName.indexOf("_") != -1 || FiledName.indexOf(".") != -1)) {
            if (value instanceof List) {
                String tempValue = "";
                for (Object listValue : (List)value) {
                    tempValue = tempValue.toString() + OrgServiceImpl.fieldNametoValues(childFieldName, listValue) + ",";
                }
                value = tempValue;
            } else {
                value = OrgServiceImpl.fieldNametoValues(childFieldName, value);
            }
        }
        if (value != "" && value != null) {
            value = value.toString().replaceAll("\r\n", "");
        }
        return value;
    }

    @Override
    public List<TmOrgVo> getOrgUpById(String orgId) {
        ArrayList<TmOrgVo> vos = new ArrayList<TmOrgVo>();
        TmOrgEntity entity = (TmOrgEntity)this.orgDao.selectByPrimaryKey(orgId);
        String parentId = entity.getParentId();
        if (entity != null) {
            TmOrgVo orgVo = new TmOrgVo();
            BeanUtils.copyProperties((Object)entity, (Object)orgVo);
            vos.add(orgVo);
        }
        while (StringUtil.isNotEmpty((CharSequence)parentId)) {
            TmOrgEntity parentEntity = (TmOrgEntity)this.orgDao.selectByPrimaryKey(parentId);
            if (parentEntity == null) {
                parentId = "";
                continue;
            }
            parentId = parentEntity.getParentId();
            TmOrgVo orgVo = new TmOrgVo();
            BeanUtils.copyProperties((Object)parentEntity, (Object)orgVo);
            vos.add(orgVo);
        }
        return vos;
    }

    @Override
    public TmOrgVo getOrgByIdOrCode(String orgId, String orgCode) {
        if (StringUtil.isEmpty((String)orgId) && StringUtil.isEmpty((String)orgCode)) {
            return null;
        }
        if (!StringUtil.isEmpty((String)orgId)) {
            TmOrgVo orgVo = new TmOrgVo();
            TmOrgEntity entity = (TmOrgEntity)this.orgDao.selectByPrimaryKey(orgId);
            BeanUtils.copyProperties((Object)entity, (Object)orgVo);
            return orgVo;
        }
        TmOrgVo orgVo = new TmOrgVo();
        Example example = new Example(TmOrgEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("orgCode", (Object)orgCode);
        TmOrgEntity entity = (TmOrgEntity)this.orgDao.selectOneByExample(example);
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)orgVo);
            return orgVo;
        }
        return null;
    }

    @Override
    public List<TmOrgVo> getOrgByparam(TmOrgVo tmOrgVo) {
        Example example = new Example(TmOrgEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)tmOrgVo.getId())) {
            criteria.andEqualTo("id", (Object)tmOrgVo.getId());
        }
        if (StringUtil.isNotEmpty((CharSequence)tmOrgVo.getOrgName())) {
            criteria.andEqualTo("orgName", (Object)tmOrgVo.getOrgName());
        }
        if (StringUtil.isNotEmpty((CharSequence)tmOrgVo.getOrgDesc())) {
            criteria.andEqualTo("orgDesc", (Object)tmOrgVo.getOrgDesc());
        }
        if (StringUtil.isNotEmpty((CharSequence)tmOrgVo.getOrgCode())) {
            criteria.andEqualTo("orgCode", (Object)tmOrgVo.getOrgCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)tmOrgVo.getOrgType())) {
            criteria.andEqualTo("orgType", (Object)tmOrgVo.getOrgType());
        }
        if (StringUtil.isNotEmpty((CharSequence)tmOrgVo.getParentId())) {
            criteria.andEqualTo("parentId", (Object)tmOrgVo.getParentId());
        }
        List entities = this.orgDao.selectByExample(example);
        ArrayList<TmOrgVo> vos = new ArrayList<TmOrgVo>();
        entities.forEach(item -> {
            TmOrgVo vo = new TmOrgVo();
            BeanUtils.copyProperties((Object)item, (Object)vo);
            vos.add(vo);
        });
        return vos;
    }

    @Override
    public List<TmOrgEntity> getOrgListAll() {
        List tmOrgEntities = this.orgDao.selectAll();
        return tmOrgEntities;
    }
}

