/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.org.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.org.entity.TmOrgEntity;
import com.biz.eisp.org.service.OrgService;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.position.service.PositionService;
import com.biz.eisp.tree.TreeGrid;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MDM-\u7ec4\u7ec7"}, description="CRM-MDM MDM\u7ec4\u7ec7\u4fe1\u606f")
@RestController
@RequestMapping(value={"/mdmApi/orgApiController"})
public class OrgApiController {
    @Autowired
    private OrgService orgService;
    @Autowired
    private PositionService positionService;

    @ApiOperation(value="\u6839\u636e\u5c97\u4f4d\u5f97\u5230\u7ec4\u7ec7", notes="\u6839\u636e\u5c97\u4f4did\u6216\u8005\u5c97\u4f4d\u7f16\u7801\u5f97\u5230\u7ec4\u7ec7\uff0c\u8fd4\u56de\u7ed3\u679cobj", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="posId", value="\u804c\u4f4dID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="posCode", value="\u804c\u4f4d\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getOrgByPos"})
    public AjaxJson<TmOrgVo> getOrgByPos(@RequestParam(value="posId", required=false) String posId, @RequestParam(value="posCode", required=false) String posCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TmOrgVo tmOrgVo = this.orgService.getOrgByPos(posId, posCode);
        ajaxJson.setObj((Object)tmOrgVo);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u6811", notes="\u6811\u72b6\u67e5\u8be2\u6307\u5b9a\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7objList", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgId", value="\u7ec4\u7ec7ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getOrgList"})
    public AjaxJson<TmOrgEntity> getOrgList(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="orgCode", required=false) String orgCode) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmOrgEntity> orgEntities = this.orgService.getOrgList(orgId, orgCode);
        ajaxJson.setObjList(orgEntities);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7ec4\u7ec7\u7f16\u7801\uff0c\u67e5\u8be2\u5f53\u524d\u53ca\u5176\u4e0b\u7ea7\u6240\u6709\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408", notes="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7ec4\u7ec7\u7f16\u7801\uff0c\u67e5\u8be2\u5f53\u524d\u53ca\u5176\u4e0b\u7ea7\u6240\u6709\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgId", value="\u7ec4\u7ec7ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getOrgListDownCodes"})
    public AjaxJson<String> getOrgListDownCodes(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="orgCode", required=false) String orgCode) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmOrgEntity> orgEntities = this.orgService.getOrgListDown(orgId, orgCode);
        List<Object> codes = new ArrayList();
        if (CollectionUtil.listNotEmptyNotSizeZero(orgEntities)) {
            codes = orgEntities.stream().map(TmOrgEntity::getOrgCode).collect(Collectors.toList());
        }
        ajaxJson.setObjList(codes);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7ec4\u7ec7\u7f16\u7801\uff0c\u67e5\u8be2\u5f53\u524d\u53ca\u5176\u4e0b\u7ea7\u6240\u6709\u7ec4\u7ec7\u96c6\u5408", notes="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7ec4\u7ec7\u7f16\u7801\uff0c\u67e5\u8be2\u5f53\u524d\u53ca\u5176\u4e0b\u7ea7\u6240\u6709\u7ec4\u7ec7\u96c6\u5408", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgId", value="\u7ec4\u7ec7ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getOrgListDown"})
    public AjaxJson<TmOrgEntity> getOrgListDown(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="orgCode", required=false) String orgCode) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmOrgEntity> orgEntities = this.orgService.getOrgListDown(orgId, orgCode);
        ajaxJson.setObjList(orgEntities);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7684\u6240\u6709\u804c\u4f4d\u5bf9\u5e94\u7684\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408", notes="\u67e5\u8be2\u7528\u6237\u7684\u6240\u6709\u804c\u4f4d\u5bf9\u5e94\u7684\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="userName", value="\u7528\u6237\u767b\u5f55\u8d26\u53f7", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getOrgCodesByUser"})
    public AjaxJson<String> getOrgCodesByUser(@RequestParam(value="userId", required=false) String userId, @RequestParam(value="userName", required=false) String userName) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmPositionVo> positionVos = this.positionService.getUserPositons(userName, userId);
        List<Object> codes = new ArrayList();
        if (!CollectionUtil.listNotEmptyNotSizeZero(positionVos)) {
            ajaxJson.setObjList(codes);
            return ajaxJson;
        }
        List orgIds = positionVos.stream().map(TmPositionVo::getOrgId).distinct().collect(Collectors.toList());
        for (String ordId : orgIds) {
            TmOrgVo tmOrgVo = this.orgService.getOrgByIdOrCode(ordId, null);
            if (tmOrgVo == null) continue;
            codes.add(tmOrgVo.getOrgCode());
        }
        codes = codes.stream().distinct().collect(Collectors.toList());
        ajaxJson.setObjList(codes);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7684\u6240\u6709\u804c\u4f4d\u5bf9\u5e94\u7684\u7ec4\u7ec7\u7f16\u7801 \u5f53\u524d\u53ca\u5176\u4e0b\u7ea7\u96c6\u5408", notes="\u67e5\u8be2\u7528\u6237\u7684\u6240\u6709\u804c\u4f4d\u5bf9\u5e94\u7684\u7ec4\u7ec7\u7f16\u7801 \u5f53\u524d\u53ca\u5176\u4e0b\u7ea7\u96c6\u5408", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="userName", value="\u7528\u6237\u767b\u5f55\u8d26\u53f7", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getOrgCodesDownByUser"})
    public AjaxJson<String> getOrgCodesDownByUser(@RequestParam(value="userId", required=false) String userId, @RequestParam(value="userName", required=false) String userName) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmPositionVo> positionVos = this.positionService.getUserPositons(userName, userId);
        List<Object> codes = new ArrayList();
        if (!CollectionUtil.listNotEmptyNotSizeZero(positionVos)) {
            ajaxJson.setObjList(codes);
            return ajaxJson;
        }
        List orgIds = positionVos.stream().map(TmPositionVo::getOrgId).distinct().collect(Collectors.toList());
        ArrayList<TmOrgEntity> entities = new ArrayList<TmOrgEntity>();
        for (String ordId : orgIds) {
            List<TmOrgEntity> entitiesTemp = this.orgService.getOrgListDown(ordId, null);
            if (!CollectionUtil.listNotEmptyNotSizeZero(entitiesTemp)) continue;
            entities.addAll(entitiesTemp);
        }
        codes = entities.stream().map(TmOrgEntity::getOrgCode).distinct().collect(Collectors.toList());
        ajaxJson.setObjList(codes);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7ec4\u7ec7", notes="\u67e5\u8be2\u6240\u6709\u7ec4\u7ec7\uff0c\u8fd4\u56de\u503c\u5728objList", httpMethod="GET")
    @GetMapping(value={"getOrgListAll"})
    public AjaxJson<TmOrgEntity> getOrgListAll() {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmOrgEntity> orgEntities = this.orgService.getOrgListAll();
        ajaxJson.setObjList(orgEntities);
        return ajaxJson;
    }

    @PostMapping(value={"getTmOrgEntityTree"})
    public AjaxJson<TreeGrid> getTmOrgEntityTree(@RequestBody TmOrgVo tmOrgVo) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TreeGrid> treeGrids = this.orgService.findTmOrgList(tmOrgVo);
        ajaxJson.setObjList(treeGrids);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u53ca\u7ec4\u7ec7\u4e0a\u7ea7", notes="\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u53ca\u7ec4\u7ec7\u4e0a\u7ea7objList", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgId", value="\u7ec4\u7ec7ID", required=true, dataType="String", paramType="query")})
    @PostMapping(value={"getOrgUpById"})
    public AjaxJson<TmOrgVo> getOrgUpById(@RequestParam(value="orgId") String orgId) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmOrgVo> tmOrgVoList = this.orgService.getOrgUpById(orgId);
        ajaxJson.setObjList(tmOrgVoList);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7ID\u6216\u8005\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec4\u7ec7\u5b9e\u4f53", notes="\u6839\u636e\u7ec4\u7ec7ID\u6216\u8005\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec4\u7ec7\u5b9e\u4f53obj", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgId", value="\u7ec4\u7ec7ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getOrgByIdOrCode"})
    public AjaxJson<TmOrgVo> getOrgByIdOrCode(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="orgCode", required=false) String orgCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TmOrgVo orgEntities = this.orgService.getOrgByIdOrCode(orgId, orgCode);
        ajaxJson.setObj((Object)orgEntities);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u5c5e\u6027\u7cbe\u786e\u67e5\u8be2\u7ec4\u7ec7", notes="\u6839\u636e\u7ec4\u7ec7\u5c5e\u6027\u7cbe\u786e\u67e5\u8be2\u7ec4\u7ec7", httpMethod="POST")
    @PostMapping(value={"getOrgByparam"})
    public AjaxJson<TmOrgVo> getOrgByparam(@RequestBody TmOrgVo tmOrgVo) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmOrgVo> tmOrgVos = this.orgService.getOrgByparam(tmOrgVo);
        ajaxJson.setObjList(tmOrgVos);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u6216\u8005\u767b\u5f55\u8d26\u53f7\u83b7\u53d6\u5bf9\u5e94\u7684\u6240\u6709\u4f01\u4e1a\u7ec4\u7ec7\u5217\u8868\u96c6\u5408", notes="\u6839\u636e\u7528\u6237id\u6216\u8005\u767b\u5f55\u8d26\u53f7\u83b7\u53d6\u5bf9\u5e94\u7684\u6240\u6709\u4f01\u4e1a\u7ec4\u7ec7\u5217\u8868\u96c6\u5408", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="userName", value="\u767b\u5f55\u8d26\u53f7", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getOrgListByUser"})
    public AjaxJson<TmOrgVo> getOrgListByUser(@RequestParam(value="userId", required=false) String userId, @RequestParam(value="userName", required=false) String userName) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmOrgVo> orgVos = new ArrayList();
        List<TmPositionVo> positionVos = this.positionService.getUserPositons(userName, userId);
        if (CollectionUtil.listEmpty(positionVos)) {
            ajaxJson.setObjList(orgVos);
            return ajaxJson;
        }
        for (TmPositionVo vo : positionVos) {
            TmOrgVo tmOrgVo = this.orgService.getOrgByPos(vo.getId(), null);
            if (tmOrgVo == null) continue;
            orgVos.add(tmOrgVo);
        }
        if (CollectionUtil.listEmpty(orgVos)) {
            ajaxJson.setObjList(orgVos);
            return ajaxJson;
        }
        orgVos = orgVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TmOrgVo>(Comparator.comparing(TmOrgVo::getId))), ArrayList::new));
        ajaxJson.setObjList(orgVos);
        return ajaxJson;
    }
}

