/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.customer.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.customer.TmCustomerResultVo;
import com.biz.eisp.customer.TmCustomerVo;
import com.biz.eisp.customer.dao.CustomerDao;
import com.biz.eisp.customer.entity.TmCustomerEntity;
import com.biz.eisp.customer.service.CustomerService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class CustomerServiceImpl
implements CustomerService {
    private static final Logger log = Logger.getLogger(CustomerServiceImpl.class.getName());
    @Autowired
    private CustomerDao customerDao;

    @Override
    public PageInfo<TmCustomerEntity> getCustomerPage(Map<String, Object> param, Page page) {
        Example example = new Example(TmCustomerEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((Object)param.get("customerCode"))) {
            criteria.andLike("customerCode", "%" + param.get("customerCode").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("customerName"))) {
            criteria.andLike("customerName", "%" + param.get("customerName").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("erpCode"))) {
            criteria.andLike("erpCode", "%" + param.get("erpCode").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("customerType"))) {
            criteria.andEqualTo("customerType", (Object)param.get("customerType").toString());
        }
        return PageAutoHelperUtil.generatePage(() -> this.customerDao.selectByExample(example), (Page)page);
    }

    @Override
    public PageInfo<TmCustomerResultVo> getCustomerByPosIdPage(Map<String, Object> param, Page page) {
        TmCustomerVo vo = new TmCustomerVo();
        String posId = OConvertUtils.getString((Object)param.get("posId"));
        String[] array = posId.split(",");
        ArrayList posList = new ArrayList(array.length);
        Collections.addAll(posList, array);
        vo.setPosId(OConvertUtils.getString((Object)param.get("posId")));
        vo.setCustomerCode(OConvertUtils.getString((Object)param.get("customerCode")));
        vo.setCustomerName(OConvertUtils.getString((Object)param.get("customerName")));
        vo.setExtChar16(OConvertUtils.getString((Object)param.get("custLevel")));
        vo.setExtChar4(OConvertUtils.getString((Object)param.get("custType")));
        return PageAutoHelperUtil.generatePage(() -> this.customerDao.getCustomerByPosIdPage(posList, vo), (Page)page);
    }

    @Override
    public PageInfo<TmCustomerResultVo> getCustomerByPosPage(Map<String, Object> param, Page page) {
        TmCustomerVo vo = new TmCustomerVo();
        String posId = OConvertUtils.getString((Object)param.get("posId"));
        String[] array = posId.split(",");
        ArrayList posList = new ArrayList(array.length);
        Collections.addAll(posList, array);
        vo.setPosId(OConvertUtils.getString((Object)param.get("posId")));
        vo.setCustomerCode(OConvertUtils.getString((Object)param.get("customerCode")));
        vo.setCustomerName(OConvertUtils.getString((Object)param.get("customerName")));
        vo.setExtChar16(OConvertUtils.getString((Object)param.get("custLevel")));
        vo.setExtChar4(OConvertUtils.getString((Object)param.get("custType")));
        return PageAutoHelperUtil.generatePage(() -> this.customerDao.getCustomerByPosPage(posList, vo), (Page)page);
    }

    @Override
    public TmCustomerVo getCustomerByIdOrCode(String id, String customerCode) {
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)customerCode)) {
            return null;
        }
        TmCustomerEntity entity = null;
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            entity = (TmCustomerEntity)this.customerDao.selectByPrimaryKey(id);
        } else {
            Example example = new Example(TmCustomerEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("customerCode", (Object)customerCode);
            List list = this.customerDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                entity = (TmCustomerEntity)list.get(0);
            } else {
                return null;
            }
        }
        TmCustomerVo tmCustomerVo = new TmCustomerVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)tmCustomerVo);
            return tmCustomerVo;
        }
        return null;
    }
}

