/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.productLevel.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.org.TreeGrid;
import com.biz.eisp.product.TmProductVo;
import com.biz.eisp.productLevel.entity.TmProductEntity;
import com.biz.eisp.productLevel.service.TmProductService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MDM-\u4ea7\u54c1"}, description="CRM-MDM \u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f")
@RestController
@RequestMapping(value={"/mdmApi/productLevelApiCotroller"})
public class ProductLevelApiCotroller {
    @Autowired
    private TmProductService tmProductService;

    @ApiOperation(value="\u67e5\u8be2\u4ea7\u54c1\u5c42\u7ea7\u6811", notes="\u67e5\u8be2\u6307\u5b9a\u4ea7\u54c1\u5c42\u7ea7\u53ca\u5176\u4e0b\u7ea7objList", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="productId", value="\u4ea7\u54c1\u5c42\u7ea7ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="productCode", value="\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getProductList"})
    public AjaxJson<TmProductEntity> getProductList(@RequestParam(value="productId", required=false) String productId, @RequestParam(value="productCode", required=false) String productCode) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmProductEntity> productEntities = this.tmProductService.getTmProductList(productId, productCode);
        ajaxJson.setObjList(productEntities);
        return ajaxJson;
    }

    @PostMapping(value={"getTmProductEntityTree"})
    public AjaxJson<TreeGrid> getTmProductEntityTree(@RequestBody TmProductVo tmProductVo) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TreeGrid> treeGrids = this.tmProductService.findTmProductVoList(tmProductVo);
        ajaxJson.setObjList(treeGrids);
        return ajaxJson;
    }
}

