/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.service.impl;

import com.biz.eisp.activiti.dao.TmActRoleDao;
import com.biz.eisp.activiti.dao.TmRPostionActRoleDao;
import com.biz.eisp.activiti.entity.TmActRoleEntity;
import com.biz.eisp.activiti.entity.TmRPostionActRoleEntity;
import com.biz.eisp.activiti.service.RoleActivitiService;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.position.service.PositionService;
import com.biz.eisp.role.TmActRoleVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class RoleActivitiServiceImpl
implements RoleActivitiService {
    @Autowired
    private TmActRoleDao tmActRoleDao;
    @Autowired
    private PositionService positionService;
    @Autowired
    private TmRPostionActRoleDao tmRPostionActRoleDao;

    @Override
    public PageInfo<TmActRoleVo> findRoleByPositionId(String posId, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tmActRoleDao.findByPositionId(posId), (Page)page);
    }

    @Override
    public PageInfo<TmActRoleVo> findRoleByCondition(String roleCode, String roleName, Page page) {
        Example example = new Example(TmActRoleEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)roleCode)) {
            criteria.andLike("roleCode", "%" + roleCode + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)roleName)) {
            criteria.andLike("roleName", "%" + roleName + "%");
        }
        example.setOrderByClause("role_code asc");
        return PageAutoHelperUtil.generatePage(() -> this.tmActRoleDao.selectByExample(example), (Page)page);
    }

    @Override
    public PageInfo<TmPositionVo> findPosByActRole(String roleCode, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tmActRoleDao.findPositionByActRole(roleCode), (Page)page);
    }

    @Override
    public TmPositionVo getPositionByRoleCodeAndPositionId(String roleCode, String posId) {
        return this.tmActRoleDao.getPositionByRoleCodeAndPositionId(roleCode, posId);
    }

    @Override
    public List<TmPositionVo> findParentPositionByRoleCodeAndPositionId(String roleCode, String posId) {
        return this.tmActRoleDao.findParentPositionByRoleCodeAndPositionId(roleCode, posId);
    }

    @Override
    public List<TmPositionVo> findPositionByRoleCodeAndOrgId(String roleCode, String orgId, Integer queryType) {
        if (queryType == 0) {
            return this.tmActRoleDao.findPositionByRoleCodeAndOrgId(roleCode, orgId);
        }
        if (queryType == 1) {
            return this.tmActRoleDao.findPositionByRoleCodeAndSubOrg(roleCode, orgId);
        }
        if (queryType == 2) {
            return this.tmActRoleDao.findPositionByRoleCodeAndSuperOrg(roleCode, orgId);
        }
        return null;
    }

    @Override
    public TmActRoleVo getTmActRoleById(String id) {
        TmActRoleEntity entity = (TmActRoleEntity)this.tmActRoleDao.selectByPrimaryKey(id);
        if (entity == null) {
            return null;
        }
        TmActRoleVo vo = new TmActRoleVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        return vo;
    }

    @Override
    public List<TmActRoleVo> getTmActRoleByUserId(String userId) {
        List<TmPositionVo> positionVos = this.positionService.getUserPositons(null, userId);
        List posId = positionVos.stream().map(TmPositionVo::getId).collect(Collectors.toList());
        Example exampleRolePos = new Example(TmRPostionActRoleEntity.class);
        Example.Criteria criteria1RolePos = exampleRolePos.createCriteria();
        criteria1RolePos.andIn("positionId", posId);
        List tmRPostionActRoleEntities = this.tmRPostionActRoleDao.selectByExample(exampleRolePos);
        List roleIds = tmRPostionActRoleEntities.stream().map(TmRPostionActRoleEntity::getRoleId).collect(Collectors.toList());
        if (!CollectionUtil.listNotEmptyNotSizeZero(roleIds)) {
            return new ArrayList<TmActRoleVo>();
        }
        Example example = new Example(TmActRoleEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("id", roleIds);
        List entities = this.tmActRoleDao.selectByExample(example);
        ArrayList<TmActRoleVo> vos = new ArrayList<TmActRoleVo>();
        entities.forEach(item -> {
            TmActRoleVo vo = new TmActRoleVo();
            BeanUtils.copyProperties((Object)item, (Object)vo);
            vos.add(vo);
        });
        return vos;
    }
}

