/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.productPrice.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.price.PriceParamVo;
import com.biz.eisp.price.PriceReturnVo;
import com.biz.eisp.productPrice.dao.TmProductPriceDao;
import com.biz.eisp.productPrice.entity.TmProductPriceEntity;
import com.biz.eisp.productPrice.service.TmProductPriceService;
import com.biz.eisp.tools.DictUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TmProductPriceServiceImpl
implements TmProductPriceService {
    @Autowired
    private TmProductPriceDao tmProductPriceDao;

    @Override
    public List<TmProductPriceEntity> findProductPriceList(Map<String, Object> param) {
        Example example = new Example(TmProductPriceEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((Object)param.get("priceDimension"))) {
            criteria.andEqualTo("priceDimension", (Object)param.get("priceDimension").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("productInfoCode"))) {
            criteria.andEqualTo("productInfoCode", (Object)param.get("productInfoCode").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("priceGroup"))) {
            criteria.andEqualTo("priceGroup", (Object)param.get("priceGroup").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("customerCode"))) {
            criteria.andEqualTo("customerCode", (Object)param.get("customerCode").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("pricePriority"))) {
            criteria.andEqualTo("pricePriority", (Object)param.get("pricePriority").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("priceDate"))) {
            criteria.andGreaterThan("endTime", (Object)param.get("priceDate").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("priceDate"))) {
            criteria.andLessThan("beginTime", (Object)param.get("priceDate").toString());
        }
        example.setOrderByClause("price_priority ASC,end_time DESC");
        return this.tmProductPriceDao.selectByExample(example);
    }

    @Override
    public List<PriceReturnVo> getPriceReturnVos(PriceParamVo priceParamVo) {
        ArrayList<PriceReturnVo> priceReturnVos = new ArrayList<PriceReturnVo>();
        List strings = priceParamVo.getProductCodes();
        ArrayList<String> newStrings = new ArrayList<String>();
        List list = DictUtil.getDictList((String)"price_dimension");
        list.sort(new Comparator<KnlDictDataEntity>(){

            @Override
            public int compare(KnlDictDataEntity o1, KnlDictDataEntity o2) {
                Integer o1sort = Integer.valueOf(String.valueOf(o1.getExtendMap().get("priority")));
                Integer o2sort = Integer.valueOf(String.valueOf(o2.getExtendMap().get("priority")));
                return o1sort.compareTo(o2sort);
            }
        });
        for (KnlDictDataEntity entity : list) {
            PriceReturnVo priceReturnVo;
            List<TmProductPriceEntity> tmProductPriceEntities;
            HashMap<String, Object> param;
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)strings)) break;
            if (StringUtil.equals((String)entity.getDictCode(), (String)ConstantEnum.PriceDimensionEnum.CUSTOMER.getValue())) {
                if (StringUtil.isEmpty((String)priceParamVo.getCustCode())) continue;
                newStrings = new ArrayList();
                for (String str : strings) {
                    param = new HashMap<String, Object>();
                    param.put("productInfoCode", str);
                    param.put("customerCode", priceParamVo.getCustCode());
                    param.put("priceDate", priceParamVo.getPriceDate());
                    param.put("priceDimension", entity.getDictCode());
                    tmProductPriceEntities = this.findProductPriceList(param);
                    if (!CollectionUtil.listNotEmptyNotSizeZero(tmProductPriceEntities)) continue;
                    newStrings.add(tmProductPriceEntities.get(0).getProductInfoCode());
                    priceReturnVo = new PriceReturnVo();
                    priceReturnVo.setPriceAmount(tmProductPriceEntities.get(0).getUnitPrice());
                    priceReturnVo.setProductInfoCode(tmProductPriceEntities.get(0).getProductInfoCode());
                    priceReturnVo.setProductInfoName(tmProductPriceEntities.get(0).getProductInfoName());
                    priceReturnVos.add(priceReturnVo);
                }
                this.getList(strings, newStrings);
                continue;
            }
            if (StringUtil.equals((String)entity.getDictCode(), (String)ConstantEnum.PriceDimensionEnum.PRICEGROUP.getValue())) {
                if (StringUtil.isEmpty((String)priceParamVo.getPriceGroup())) continue;
                newStrings = new ArrayList();
                for (String string : strings) {
                    param = new HashMap();
                    param.put("productInfoCode", string);
                    param.put("priceGroup", priceParamVo.getPriceGroup());
                    param.put("priceDate", priceParamVo.getPriceDate());
                    param.put("priceDimension", entity.getDictCode());
                    tmProductPriceEntities = this.findProductPriceList(param);
                    if (!CollectionUtil.listNotEmptyNotSizeZero(tmProductPriceEntities)) continue;
                    newStrings.add(tmProductPriceEntities.get(0).getProductInfoCode());
                    priceReturnVo = new PriceReturnVo();
                    priceReturnVo.setPriceAmount(tmProductPriceEntities.get(0).getUnitPrice());
                    priceReturnVo.setProductInfoCode(tmProductPriceEntities.get(0).getProductInfoCode());
                    priceReturnVo.setProductInfoName(tmProductPriceEntities.get(0).getProductInfoName());
                    priceReturnVos.add(priceReturnVo);
                }
                this.getList(strings, newStrings);
                continue;
            }
            if (!StringUtil.equals((String)entity.getDictCode(), (String)ConstantEnum.PriceDimensionEnum.PRODUCT.getValue())) continue;
            newStrings = new ArrayList();
            for (String string : strings) {
                param = new HashMap();
                param.put("productInfoCode", string);
                param.put("priceDate", priceParamVo.getPriceDate());
                param.put("priceDimension", entity.getDictCode());
                tmProductPriceEntities = this.findProductPriceList(param);
                if (!CollectionUtil.listNotEmptyNotSizeZero(tmProductPriceEntities)) continue;
                newStrings.add(tmProductPriceEntities.get(0).getProductInfoCode());
                priceReturnVo = new PriceReturnVo();
                priceReturnVo.setPriceAmount(tmProductPriceEntities.get(0).getUnitPrice());
                priceReturnVo.setProductInfoCode(tmProductPriceEntities.get(0).getProductInfoCode());
                priceReturnVo.setProductInfoName(tmProductPriceEntities.get(0).getProductInfoName());
                priceReturnVos.add(priceReturnVo);
            }
            this.getList(strings, newStrings);
        }
        return priceReturnVos;
    }

    private List<String> getList(List<String> mAllList, List<String> mSubList) {
        int i;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (i = 0; i < mAllList.size(); ++i) {
            map.put(mAllList.get(i), i);
        }
        for (i = 0; i < mSubList.size(); ++i) {
            Integer pos = (Integer)map.get(mSubList.get(i));
            if (pos == null) continue;
            mAllList.set(pos, null);
        }
        for (i = mAllList.size() - 1; i >= 0; --i) {
            if (mAllList.get(i) != null) continue;
            mAllList.remove(i);
        }
        return mAllList;
    }
}

