/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.product.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.price.PriceParamVo;
import com.biz.eisp.price.PriceReturnVo;
import com.biz.eisp.product.TmProductInfoVo;
import com.biz.eisp.product.dao.TmProductInfoDao;
import com.biz.eisp.product.entity.TmProductInfoEntity;
import com.biz.eisp.product.service.TmProductInfoService;
import com.biz.eisp.productPrice.service.TmProductPriceService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TmProductInfoServiceImpl
implements TmProductInfoService {
    @Autowired
    private TmProductInfoDao tmProductInfoDao;
    @Autowired
    private TmProductPriceService tmProductPriceService;

    @Override
    public PageInfo<TmProductInfoEntity> findProductInfoByPage(Map<String, Object> param, Page page) {
        Example example = new Example(TmProductInfoEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((Object)param.get("id"))) {
            criteria.andEqualTo("id", param.get("id"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("productCode"))) {
            criteria.andLike("productCode", "%" + param.get("productCode").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("productInfoCode"))) {
            criteria.andLike("productInfoCode", "%" + param.get("productInfoCode").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("productInfoName"))) {
            criteria.andLike("productInfoName", "%" + param.get("productInfoName").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("productInfoType"))) {
            criteria.andEqualTo("productInfoType", (Object)param.get("productInfoType").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("costPriceGreaterZero"))) {
            criteria.andGreaterThan("costPrice", (Object)0);
            example.setOrderByClause("cost_price desc");
        }
        return PageAutoHelperUtil.generatePage(() -> this.tmProductInfoDao.selectByExample(example), (Page)page);
    }

    @Override
    public PageInfo<TmProductInfoEntity> findProductInfoPriceByPage(Map<String, Object> param, Page page, List<String> notCodes) {
        Example example = new Example(TmProductInfoEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((Object)param.get("id"))) {
            criteria.andEqualTo("id", param.get("id"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("productCode"))) {
            criteria.andLike("productCode", "%" + param.get("productCode").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("productInfoCode"))) {
            criteria.andLike("productInfoCode", "%" + param.get("productInfoCode").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("productInfoName"))) {
            criteria.andLike("productInfoName", "%" + param.get("productInfoName").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("productInfoType"))) {
            criteria.andEqualTo("productInfoType", (Object)param.get("productInfoType").toString());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(notCodes)) {
            criteria.andNotIn("productInfoCode", notCodes);
        }
        return PageAutoHelperUtil.generatePage(() -> this.tmProductInfoDao.selectByExample(example), (Page)page);
    }

    @Override
    public TmProductInfoEntity getTmProductInfoEntityById(String id) {
        return (TmProductInfoEntity)this.tmProductInfoDao.selectByPrimaryKey(id);
    }

    @Override
    public TmProductInfoEntity getTmProductInfoEntityByAiCode(String aiCode) {
        List tmProductInfoEntities;
        TmProductInfoEntity entity = new TmProductInfoEntity();
        Example example = new Example(TmProductInfoEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)aiCode)) {
            criteria.andEqualTo("aiCode", (Object)aiCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(tmProductInfoEntities = this.tmProductInfoDao.selectByExample(example)))) {
            entity = (TmProductInfoEntity)tmProductInfoEntities.get(0);
        }
        return entity;
    }

    @Override
    public List<TmProductInfoEntity> getAllProduct(TmProductInfoVo tmProductInfoVo, List<PriceReturnVo> priceReturnVos) {
        List productInfoEntities = this.tmProductInfoDao.selectAll();
        List productCodes = productInfoEntities.stream().map(TmProductInfoEntity::getProductInfoCode).collect(Collectors.toList());
        PriceParamVo priceParamVo = new PriceParamVo(productCodes, tmProductInfoVo.getPriceGroup(), tmProductInfoVo.getCustCode());
        ArrayList priceReturnVos1 = this.tmProductPriceService.getPriceReturnVos(priceParamVo);
        priceReturnVos1 = priceReturnVos1 == null ? new ArrayList() : priceReturnVos1;
        priceReturnVos.addAll(priceReturnVos1);
        Map<String, String> mapPrice = priceReturnVos1.stream().collect(Collectors.toMap(PriceReturnVo::getProductInfoCode, PriceReturnVo::getProductInfoCode));
        for (int i = 0; i < productInfoEntities.size(); ++i) {
            if (!mapPrice.containsKey(((TmProductInfoEntity)productInfoEntities.get(i)).getProductInfoCode())) continue;
            productInfoEntities.remove(i);
            --i;
        }
        return productInfoEntities;
    }
}

