/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.ware.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.ware.dao.TmWareSalerangeDao;
import com.biz.eisp.ware.entity.TmWareSalerangeEntity;
import com.biz.eisp.ware.service.TmWareSalerangeService;
import com.biz.eisp.ware.vo.TmWareSalerangeVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TmWareSalerangeServiceImpl
implements TmWareSalerangeService {
    @Autowired
    private TmWareSalerangeDao tmWareSalerangeDao;

    @Override
    public List<TmWareSalerangeEntity> findTmWareSalerangeList(TmWareSalerangeVo vo) {
        Example example = new Example(TmWareSalerangeEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getWareCode())) {
            criteria.andEqualTo("wareCode", (Object)vo.getWareCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getWareName())) {
            criteria.andLike("wareName", "%" + vo.getWareName() + "%");
        }
        return this.tmWareSalerangeDao.selectByExample(example);
    }

    @Override
    public TmWareSalerangeEntity getTmWareSalerangeEntityById(String id) {
        return (TmWareSalerangeEntity)this.tmWareSalerangeDao.selectByPrimaryKey(id);
    }

    @Override
    public boolean delete(String id) {
        TmWareSalerangeEntity tmWareSalerangeEntity = (TmWareSalerangeEntity)this.tmWareSalerangeDao.selectByPrimaryKey(id);
        int i = this.tmWareSalerangeDao.delete(tmWareSalerangeEntity);
        return i > 0;
    }

    @Override
    public void save(TmWareSalerangeVo vo) {
        TmWareSalerangeEntity entity = new TmWareSalerangeEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            entity = this.getTmWareSalerangeEntity(vo);
            this.tmWareSalerangeDao.insertSelective(entity);
        }
    }

    @Override
    public void update(TmWareSalerangeVo vo) {
        TmWareSalerangeEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = this.getTmWareSalerangeEntity(vo);
            this.tmWareSalerangeDao.updateByPrimaryKeySelective(entity);
        }
    }

    private TmWareSalerangeEntity getTmWareSalerangeEntity(TmWareSalerangeVo vo) {
        TmWareSalerangeEntity entity = new TmWareSalerangeEntity();
        entity.setId(vo.getId());
        entity.setEnableStatus(vo.getEnableStatus());
        entity.setWareCode(vo.getWareCode());
        entity.setWareName(vo.getWareName());
        entity.setWareId(vo.getWareId());
        entity.setContainObjType(vo.getContainObjType());
        entity.setContainStatus(vo.getContainStatus());
        entity.setOrgCode(vo.getOrgCode());
        entity.setOrgName(vo.getOrgName());
        entity.setCustCode(vo.getCustCode());
        entity.setCustName(vo.getCustName());
        return entity;
    }
}

