/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.custOrg.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.custOrg.dao.CustOrgApiDao;
import com.biz.eisp.custOrg.entity.TmCustomerOrgEntity;
import com.biz.eisp.custOrg.service.CustOrgApiService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class CustOrgApiServiceImpl
implements CustOrgApiService {
    @Autowired
    private CustOrgApiDao custOrgApiDao;

    @Override
    public List<TmCustomerOrgEntity> getCustOrgList(TmCustomerOrgEntity entity) {
        List<TmCustomerOrgEntity> tmOrgEntities = this.custOrgApiDao.selectAll();
        if (StringUtil.isEmpty((String)entity.getCustOrgCode()) && StringUtil.isEmpty((String)entity.getId())) {
            tmOrgEntities = this.createOrgList(tmOrgEntities, null);
        } else if (StringUtil.isEmpty((String)entity.getId()) && StringUtil.isNotEmpty((CharSequence)entity.getCustOrgCode())) {
            Example example = new Example(TmCustomerOrgEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("custOrgCode", (Object)entity.getCustOrgCode());
            TmCustomerOrgEntity tmOrgEntity = (TmCustomerOrgEntity)this.custOrgApiDao.selectOneByExample(example);
            if (tmOrgEntity != null) {
                tmOrgEntities = this.createOrgList(tmOrgEntities, tmOrgEntity.getId());
            }
        } else {
            TmCustomerOrgEntity tmOrgEntity = (TmCustomerOrgEntity)this.custOrgApiDao.selectByPrimaryKey(entity.getId());
            if (tmOrgEntity != null) {
                tmOrgEntities = this.createOrgList(tmOrgEntities, tmOrgEntity.getId());
            }
        }
        return tmOrgEntities;
    }

    private List<TmCustomerOrgEntity> createOrgList(List<TmCustomerOrgEntity> tmOrgEntities, String targetId) {
        List<Object> orgVos = new ArrayList<TmCustomerOrgEntity>();
        HashMap<String, List<TmCustomerOrgEntity>> orgListMap = new HashMap<String, List<TmCustomerOrgEntity>>();
        tmOrgEntities.stream().collect(Collectors.groupingBy(TmCustomerOrgEntity::getParentId, Collectors.toList())).forEach((parentId, list) -> orgListMap.put((String)parentId, (List<TmCustomerOrgEntity>)list));
        if (StringUtil.isEmpty((String)targetId)) {
            List orgVosTemp = (List)orgListMap.get("0");
            orgVosTemp.forEach(item -> this.createchildList((Map<String, List<TmCustomerOrgEntity>>)orgListMap, (TmCustomerOrgEntity)item));
            orgVos = orgVosTemp;
        } else {
            TmCustomerOrgEntity tmOrgEntity = (TmCustomerOrgEntity)this.custOrgApiDao.selectByPrimaryKey(targetId);
            if (tmOrgEntity != null) {
                this.createchildList(orgListMap, tmOrgEntity);
                orgVos.add(tmOrgEntity);
            }
        }
        return orgVos;
    }

    private void createchildList(Map<String, List<TmCustomerOrgEntity>> orgListMap, TmCustomerOrgEntity entity) {
        List<TmCustomerOrgEntity> list = orgListMap.get(entity.getId());
        entity.setTmCustOrgs(list);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> this.createchildList(orgListMap, (TmCustomerOrgEntity)item));
        }
    }
}

