/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.custOrg.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.custOrg.dao.CustOrgApiDao;
import com.biz.eisp.custOrg.entity.TmCustomerOrgEntity;
import com.biz.eisp.custOrg.service.CustOrgApiService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class CustOrgApiServiceImpl
implements CustOrgApiService {
    @Autowired
    private CustOrgApiDao custOrgApiDao;

    @Override
    public PageInfo<TmCustomerOrgEntity> getCustOrgList(TmCustomerOrgEntity entity, Page page) {
        Example example = new Example(TmCustomerOrgEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotBlank((CharSequence)entity.getCustOrgCode())) {
            criteria.andLike("custOrgCode", "%" + entity.getCustOrgCode() + "%");
        }
        if (StringUtil.isNotBlank((CharSequence)entity.getCustomerOrgName())) {
            criteria.andLike("customerOrgName", "%" + entity.getCustomerOrgName() + "%");
        }
        return PageAutoHelperUtil.generatePage(() -> this.custOrgApiDao.selectByExample(example), (Page)page);
    }

    private List<TmCustomerOrgEntity> createOrgList(List<TmCustomerOrgEntity> tmOrgEntities, String targetId) {
        List<Object> orgVos = new ArrayList<TmCustomerOrgEntity>();
        HashMap<String, List<TmCustomerOrgEntity>> orgListMap = new HashMap<String, List<TmCustomerOrgEntity>>();
        tmOrgEntities.stream().collect(Collectors.groupingBy(TmCustomerOrgEntity::getParentId, Collectors.toList())).forEach((parentId, list) -> orgListMap.put((String)parentId, (List<TmCustomerOrgEntity>)list));
        if (StringUtil.isEmpty((String)targetId)) {
            List orgVosTemp = (List)orgListMap.get("0");
            orgVosTemp.forEach(item -> this.createchildList((Map<String, List<TmCustomerOrgEntity>>)orgListMap, (TmCustomerOrgEntity)item));
            orgVos = orgVosTemp;
        } else {
            TmCustomerOrgEntity tmOrgEntity = (TmCustomerOrgEntity)this.custOrgApiDao.selectByPrimaryKey(targetId);
            if (tmOrgEntity != null) {
                this.createchildList(orgListMap, tmOrgEntity);
                orgVos.add(tmOrgEntity);
            }
        }
        return orgVos;
    }

    private void createchildList(Map<String, List<TmCustomerOrgEntity>> orgListMap, TmCustomerOrgEntity entity) {
        List<TmCustomerOrgEntity> list = orgListMap.get(entity.getId());
        entity.setTmCustOrgs(list);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> this.createchildList(orgListMap, (TmCustomerOrgEntity)item));
        }
    }
}

