/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.ware.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.ware.dao.TmWarePicDao;
import com.biz.eisp.ware.entity.TmWarePicEntity;
import com.biz.eisp.ware.service.TmWarePicService;
import com.biz.eisp.ware.vo.TmWarePicVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TmWarePicServiceImpl
implements TmWarePicService {
    @Autowired
    private TmWarePicDao tmWarePicDao;

    @Override
    public List<TmWarePicEntity> findTmWarePicList(TmWarePicVo vo) {
        Example example = new Example(TmWarePicEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getWareCode())) {
            criteria.andEqualTo("wareCode", (Object)vo.getWareCode());
        }
        return this.tmWarePicDao.selectByExample(example);
    }

    @Override
    public TmWarePicEntity getTmWarePicEntityById(String id) {
        return (TmWarePicEntity)this.tmWarePicDao.selectByPrimaryKey(id);
    }

    @Override
    public boolean delete(String id) {
        TmWarePicEntity tmWarePicEntity = (TmWarePicEntity)this.tmWarePicDao.selectByPrimaryKey(id);
        int i = this.tmWarePicDao.delete(tmWarePicEntity);
        return i > 0;
    }

    @Override
    public void save(TmWarePicVo vo) {
        TmWarePicEntity entity = new TmWarePicEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            entity = this.getTmWarePicEntity(vo);
            this.tmWarePicDao.insertSelective(entity);
        }
    }

    @Override
    public void update(TmWarePicVo vo) {
        TmWarePicEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = this.getTmWarePicEntity(vo);
            this.tmWarePicDao.updateByPrimaryKeySelective(entity);
        }
    }

    private TmWarePicEntity getTmWarePicEntity(TmWarePicVo vo) {
        TmWarePicEntity entity = new TmWarePicEntity();
        entity.setId(vo.getId());
        entity.setEnableStatus(vo.getEnableStatus());
        entity.setWareCode(vo.getWareCode());
        entity.setWareId(vo.getWareId());
        entity.setFileName(vo.getFileName());
        entity.setPicType(vo.getPicType());
        entity.setUrlPath(vo.getUrlPath());
        entity.setRealPath(vo.getRealPath());
        return entity;
    }
}

