/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.custOrg.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.custOrg.dao.CustOrgApiDao;
import com.biz.eisp.custOrg.entity.TmCustomerOrgEntity;
import com.biz.eisp.custOrg.service.CustOrgApiService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class CustOrgApiServiceImpl
implements CustOrgApiService {
    @Autowired
    private CustOrgApiDao custOrgApiDao;

    @Override
    public PageInfo<TmCustomerOrgEntity> getCustOrgList(TmCustomerOrgEntity entity, Page page) {
        Example example = new Example(TmCustomerOrgEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotBlank((CharSequence)entity.getCustOrgCode())) {
            criteria.andLike("custOrgCode", "%" + entity.getCustOrgCode() + "%");
        }
        if (StringUtil.isNotBlank((CharSequence)entity.getCustomerOrgName())) {
            criteria.andLike("customerOrgName", "%" + entity.getCustomerOrgName() + "%");
        }
        return PageAutoHelperUtil.generatePage(() -> this.custOrgApiDao.selectByExample(example), (Page)page);
    }

    private List<TmCustomerOrgEntity> createOrgList(List<TmCustomerOrgEntity> tmOrgEntities, String targetId) {
        List<Object> orgVos = new ArrayList<TmCustomerOrgEntity>();
        HashMap<String, List<TmCustomerOrgEntity>> orgListMap = new HashMap<String, List<TmCustomerOrgEntity>>();
        tmOrgEntities.stream().collect(Collectors.groupingBy(TmCustomerOrgEntity::getParentId, Collectors.toList())).forEach((parentId, list) -> orgListMap.put((String)parentId, (List<TmCustomerOrgEntity>)list));
        if (StringUtil.isEmpty((String)targetId)) {
            List orgVosTemp = (List)orgListMap.get("0");
            orgVosTemp.forEach(item -> this.createchildList((Map<String, List<TmCustomerOrgEntity>>)orgListMap, (TmCustomerOrgEntity)item));
            orgVos = orgVosTemp;
        } else {
            TmCustomerOrgEntity tmOrgEntity = (TmCustomerOrgEntity)this.custOrgApiDao.selectByPrimaryKey(targetId);
            if (tmOrgEntity != null) {
                this.createchildList(orgListMap, tmOrgEntity);
                orgVos.add(tmOrgEntity);
            }
        }
        return orgVos;
    }

    private void createchildList(Map<String, List<TmCustomerOrgEntity>> orgListMap, TmCustomerOrgEntity entity) {
        List<TmCustomerOrgEntity> list = orgListMap.get(entity.getId());
        entity.setTmCustOrgs(list);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> this.createchildList(orgListMap, (TmCustomerOrgEntity)item));
        }
    }

    @Override
    public AjaxJson<TmCustomerOrgEntity> findCustOrgEntityByIdOrCode(TmCustomerOrgEntity tmCustomerOrgEntity) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)tmCustomerOrgEntity.getId()) && StringUtil.isEmpty((String)tmCustomerOrgEntity.getCustOrgCode())) {
            ajaxJson.setErrMsg("\u8bf7\u4f20\u9012id\u6216\u8005\u7f16\u7801\u53c2\u6570\u81f3\u5c11\u4e00\u4e2a");
            return ajaxJson;
        }
        if (StringUtil.isNotEmpty((CharSequence)tmCustomerOrgEntity.getId())) {
            TmCustomerOrgEntity tmcustOrg = (TmCustomerOrgEntity)this.custOrgApiDao.selectByPrimaryKey(tmCustomerOrgEntity.getId());
            ajaxJson.setObj((Object)tmcustOrg);
            return ajaxJson;
        }
        if (StringUtil.isNotEmpty((CharSequence)tmCustomerOrgEntity.getCustOrgCode())) {
            Example example = new Example(TmCustomerOrgEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("custOrgCode", (Object)tmCustomerOrgEntity.getCustOrgCode());
            List list = this.custOrgApiDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                ajaxJson.setObj(list.get(0));
                return ajaxJson;
            }
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson<TmCustomerOrgEntity> findListCustOrgAndChild(TmCustomerOrgEntity tmCustomerOrgEntity) {
        AjaxJson<TmCustomerOrgEntity> ajaxJson = new AjaxJson<TmCustomerOrgEntity>();
        ajaxJson = this.findCustOrgEntityByIdOrCode(tmCustomerOrgEntity);
        TmCustomerOrgEntity parent = (TmCustomerOrgEntity)ajaxJson.getObj();
        if (parent != null) {
            Example example = new Example(TmCustomerOrgEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("parentId", (Object)parent.getId());
            List list = this.custOrgApiDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                list.add(0, parent);
                ajaxJson.setObjList(list);
                return ajaxJson;
            }
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson<TmCustomerOrgEntity> findTreeCustOrgAndChild(TmCustomerOrgEntity tmCustomerOrgEntity) {
        AjaxJson ajaxJson = new AjaxJson();
        TmCustomerOrgEntity tmCustomerOrg = this.custOrgApiDao.findTreeCustOrgAndChild(tmCustomerOrgEntity);
        ajaxJson.setObj((Object)tmCustomerOrg);
        return ajaxJson;
    }
}

