/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.terminal.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.org.dao.OrgDao;
import com.biz.eisp.org.entity.TmOrgEntity;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.terminal.TmTermCustPostVo;
import com.biz.eisp.terminal.TmTerminalVo;
import com.biz.eisp.terminal.dao.TerminalDao;
import com.biz.eisp.terminal.entity.TmTerminalEntity;
import com.biz.eisp.terminal.service.TerminalService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TerminalServiceImpl
implements TerminalService {
    @Autowired
    private TerminalDao terminalDao;
    @Autowired
    private OrgDao orgDao;

    @Override
    public PageInfo<TmTerminalVo> getTerminalPage(Map<String, Object> param, Page page, List<String> custCodes) {
        return PageAutoHelperUtil.generatePage(() -> this.terminalDao.getTerminalPage(param, custCodes), (Page)page);
    }

    @Override
    public TmTerminalEntity getTerminalById(String clientId) {
        return (TmTerminalEntity)this.terminalDao.selectByPrimaryKey(clientId);
    }

    @Override
    public List<String> findTerminalsByOrgCodes(List<String> orgCodes) {
        return this.terminalDao.findTerminalsByOrgCodes(this.getOrgCodes(orgCodes));
    }

    private List<String> getOrgCodes(List<String> orgCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodes)) {
            Example example = new Example(TmOrgEntity.class);
            Example.Criteria criteria = example.createCriteria();
            orgCodes.forEach(item -> criteria.orLike("orgCode", item + "%"));
            List orgs = this.orgDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)orgs)) {
                return orgs.stream().map(TmOrgEntity::getOrgCode).collect(Collectors.toList());
            }
        }
        return new ArrayList<String>();
    }

    @Override
    public List<TmTermCustPostVo> findTermCustPostList(String terminalId) {
        return this.terminalDao.findTermCustPostList(terminalId);
    }

    @Override
    public TmTerminalVo getTerminalByCode(String terminalCode) {
        TmTerminalEntity entity = null;
        Example example = new Example(TmTerminalEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("terminalCode", (Object)terminalCode);
        List list = this.terminalDao.selectByExample(example);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return null;
        }
        entity = (TmTerminalEntity)list.get(0);
        TmTerminalVo tmTerminalVo = new TmTerminalVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)tmTerminalVo);
            return tmTerminalVo;
        }
        return null;
    }
}

