/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.productLevel.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.page.Page;
import com.biz.eisp.product.TmProductVo;
import com.biz.eisp.productLevel.entity.TmProductEntity;
import com.biz.eisp.productLevel.service.GetTmProductEntityTreeExtend;
import com.biz.eisp.productLevel.service.TmProductService;
import com.biz.eisp.tree.TreeGrid;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MDM-\u4ea7\u54c1"}, description="CRM-MDM \u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f")
@RestController
@RequestMapping(value={"/mdmApi/productLevelApiCotroller"})
public class ProductLevelApiCotroller {
    @Autowired
    private TmProductService tmProductService;
    @Autowired(required=false)
    private GetTmProductEntityTreeExtend getTmProductEntityTreeExtend;

    @ApiOperation(value="\u67e5\u8be2\u4ea7\u54c1\u5c42\u7ea7\u6811", notes="\u67e5\u8be2\u6307\u5b9a\u4ea7\u54c1\u5c42\u7ea7\u53ca\u5176\u4e0b\u7ea7objList", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="productId", value="\u4ea7\u54c1\u5c42\u7ea7ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="productCode", value="\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getProductList"})
    public AjaxJson<TmProductEntity> getProductList(@RequestParam(value="productId", required=false) String productId, @RequestParam(value="productCode", required=false) String productCode) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmProductEntity> productEntities = this.tmProductService.getTmProductList(productId, productCode);
        ajaxJson.setObjList(productEntities);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u4ea7\u54c1\u5c42\u7ea7\u6811", notes="\u67e5\u8be2\u6307\u5b9a\u4ea7\u54c1\u5c42\u7ea7\u53ca\u5176\u4e0b\u7ea7 \u5728\u4e00\u4e2aobjList", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="productId", value="\u4ea7\u54c1\u5c42\u7ea7ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="productCode", value="\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getProductLevelList"})
    public AjaxJson<TmProductEntity> getProductLevelList(@RequestParam(value="productId", required=false) String productId, @RequestParam(value="productCode", required=false) String productCode) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmProductEntity> productEntities = this.tmProductService.getTmProductLevelList(productId, productCode);
        ajaxJson.setObjList(productEntities);
        return ajaxJson;
    }

    @PostMapping(value={"getTmProductEntityTree"})
    public AjaxJson<TreeGrid> getTmProductEntityTree(@RequestBody TmProductVo tmProductVo) {
        AjaxJson ajaxJson = new AjaxJson();
        List<Object> treeGrids = new ArrayList();
        treeGrids = this.getTmProductEntityTreeExtend != null ? this.getTmProductEntityTreeExtend.findTmProductVoList(tmProductVo) : this.tmProductService.findTmProductVoList(tmProductVo);
        ajaxJson.setObjList(treeGrids);
        return ajaxJson;
    }

    @PostMapping(value={"getTmProductNameTree"})
    public AjaxJson<TreeGrid> getTmProductNameTree(@RequestBody TmProductVo tmProductVo) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TreeGrid> treeGrids = this.tmProductService.findTmProductVoNameList(tmProductVo);
        ajaxJson.setObjList(treeGrids);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u4ea7\u54c1\u5c42\u7ea7\u5217\u8868", notes="\u67e5\u8be2\u4ea7\u54c1\u5c42\u7ea7\u5217\u8868,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"findProductByPage"})
    public AjaxJson<TmProductEntity> findProductByPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmProductEntity> pageInfo = this.tmProductService.findProductByPage(param, page);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u552f\u4e00\u503c\u67e5\u8be2\u4ea7\u54c1\u5c42\u7ea7", notes="\u6839\u636e\u552f\u4e00\u503c\u67e5\u8be2\u4ea7\u54c1\u5c42\u7ea7,\u8fd4\u56de\u6570\u636e \u5728obj", httpMethod="POST")
    @GetMapping(value={"getTmProductEntity"})
    public AjaxJson<TmProductEntity> getTmProductEntity(@RequestParam(value="productId", required=false) String productId, @RequestParam(value="productCode", required=false) String productCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TmProductEntity tmProductEntity = this.tmProductService.getTmProductEntity(productId, productCode);
        ajaxJson.setObj((Object)tmProductEntity);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f")
    @RequestMapping(value={"list"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public AjaxJson<TmProductEntity> list() {
        AjaxJson ajaxJson = AjaxJson.ok();
        ajaxJson.setList(this.tmProductService.list());
        return ajaxJson;
    }
}

