/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.service.impl;

import com.biz.eisp.activiti.dao.TmActRoleDao;
import com.biz.eisp.activiti.dao.TmRPostionActRoleDao;
import com.biz.eisp.activiti.entity.TmActRoleEntity;
import com.biz.eisp.activiti.entity.TmRPostionActRoleEntity;
import com.biz.eisp.activiti.service.RoleActivitiService;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.org.entity.TmOrgEntity;
import com.biz.eisp.org.service.OrgService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.position.service.PositionService;
import com.biz.eisp.role.TmActRoleVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class RoleActivitiServiceImpl
implements RoleActivitiService {
    @Autowired
    private TmActRoleDao tmActRoleDao;
    @Autowired
    private PositionService positionService;
    @Autowired
    private TmRPostionActRoleDao tmRPostionActRoleDao;
    @Autowired
    private OrgService orgService;

    @Override
    public PageInfo<TmActRoleVo> findRoleByPositionId(String posId, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tmActRoleDao.findByPositionId(posId), (Page)page);
    }

    @Override
    public PageInfo<TmActRoleVo> findRoleByCondition(String roleCode, String roleName, Page page) {
        Example example = new Example(TmActRoleEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)roleCode)) {
            criteria.andLike("roleCode", "%" + roleCode + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)roleName)) {
            criteria.andLike("roleName", "%" + roleName + "%");
        }
        example.setOrderByClause("role_code asc");
        PageInfo pageinfoEntity = PageAutoHelperUtil.generatePage(() -> this.tmActRoleDao.selectByExample(example), (Page)page);
        PageInfo pageinfo = new PageInfo();
        BeanUtils.copyProperties((Object)pageinfoEntity, (Object)pageinfo);
        return pageinfo;
    }

    @Override
    public PageInfo<TmPositionVo> findPosByActRole(String roleCode, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tmActRoleDao.findPositionByActRole(roleCode), (Page)page);
    }

    @Override
    public TmPositionVo getPositionByRoleCodeAndPositionId(String roleCode, String posId) {
        return this.tmActRoleDao.getPositionByRoleCodeAndPositionId(roleCode, posId);
    }

    @Override
    public List<TmPositionVo> findParentPositionByRoleCodeAndPositionId(String roleCode, String posId) {
        return this.tmActRoleDao.findParentPositionByRoleCodeAndPositionId(roleCode, posId);
    }

    @Override
    public List<TmPositionVo> findPositionByRoleCodeAndOrgId(String roleCode, String orgId, Integer queryType) {
        List<TmOrgVo> orgVos;
        if (queryType == 0) {
            return this.tmActRoleDao.findPositionByRoleCodeAndOrgId(roleCode, orgId);
        }
        if (queryType == 1) {
            List<TmOrgEntity> orgEntities = this.orgService.getOrgListDown(orgId, null);
            if (CollectionUtil.listNotEmptyNotSizeZero(orgEntities)) {
                List<String> orgIds = orgEntities.stream().map(TmOrgEntity::getId).distinct().collect(Collectors.toList());
                return this.tmActRoleDao.findPositionByRoleCodeAndSubOrg(roleCode, orgIds);
            }
        } else if (queryType == 2 && CollectionUtil.listNotEmptyNotSizeZero(orgVos = this.orgService.getOrgUpById(orgId))) {
            List<String> orgIds = orgVos.stream().map(TmOrgVo::getId).distinct().collect(Collectors.toList());
            return this.tmActRoleDao.findPositionByRoleCodeAndSuperOrg(roleCode, orgIds);
        }
        return null;
    }

    @Override
    public List<TmPositionVo> findPositionAndOrgByRoleCode(String roleCode) {
        ArrayList<TmPositionVo> list = new ArrayList<TmPositionVo>();
        if (StringUtil.isEmpty((String)roleCode)) {
            return list;
        }
        List<TmPositionVo> posList = this.tmActRoleDao.findPositionByActRole(roleCode);
        if (!CollectionUtil.listNotEmptyNotSizeZero(posList)) {
            return list;
        }
        for (TmPositionVo pos : posList) {
            if (StringUtil.isEmpty((String)pos.getOrgId())) continue;
            ArrayList subOrgList = new ArrayList();
            HashMap subOrgCodeMap = new HashMap();
            HashMap subOrgIdMap = new HashMap();
            List<TmOrgEntity> orgEntities = this.orgService.getOrgListDown(pos.getOrgId(), null);
            if (!CollectionUtil.listNotEmptyNotSizeZero(orgEntities)) continue;
            orgEntities.forEach(org -> {
                TmOrgVo orgVo = new TmOrgVo();
                BeanUtils.copyProperties((Object)org, (Object)orgVo);
                subOrgList.add(orgVo);
                subOrgCodeMap.put(orgVo.getOrgCode(), orgVo);
                subOrgIdMap.put(orgVo.getId(), orgVo);
            });
            pos.setSubOrgList(subOrgList);
            pos.setSubOrgCodeMap(subOrgCodeMap);
            pos.setSubOrgIdMap(subOrgIdMap);
        }
        return list;
    }

    @Override
    public TmActRoleVo getTmActRoleById(String id) {
        TmActRoleEntity entity = (TmActRoleEntity)this.tmActRoleDao.selectByPrimaryKey(id);
        if (entity == null) {
            return null;
        }
        TmActRoleVo vo = new TmActRoleVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        return vo;
    }

    @Override
    public List<TmActRoleVo> getTmActRoleByUserId(String userId) {
        List<TmPositionVo> positionVos = this.positionService.getUserPositons(null, userId);
        List posId = positionVos.stream().map(TmPositionVo::getId).collect(Collectors.toList());
        Example exampleRolePos = new Example(TmRPostionActRoleEntity.class);
        Example.Criteria criteria1RolePos = exampleRolePos.createCriteria();
        criteria1RolePos.andIn("positionId", posId);
        List tmRPostionActRoleEntities = this.tmRPostionActRoleDao.selectByExample(exampleRolePos);
        List roleIds = tmRPostionActRoleEntities.stream().map(TmRPostionActRoleEntity::getRoleId).collect(Collectors.toList());
        if (!CollectionUtil.listNotEmptyNotSizeZero(roleIds)) {
            return new ArrayList<TmActRoleVo>();
        }
        Example example = new Example(TmActRoleEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("id", roleIds);
        List entities = this.tmActRoleDao.selectByExample(example);
        ArrayList<TmActRoleVo> vos = new ArrayList<TmActRoleVo>();
        entities.forEach(item -> {
            TmActRoleVo vo = new TmActRoleVo();
            BeanUtils.copyProperties((Object)item, (Object)vo);
            vos.add(vo);
        });
        return vos;
    }
}

