/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.customer.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.customer.CustomerFindVo;
import com.biz.eisp.customer.TmCustPostVo;
import com.biz.eisp.customer.TmCustomerResultVo;
import com.biz.eisp.customer.TmCustomerVo;
import com.biz.eisp.customer.TmRCustPosBgDetailVo;
import com.biz.eisp.customer.service.CustomerService;
import com.biz.eisp.mdm.customer.entity.TmAddressEntity;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MDM-\u5ba2\u6237"}, description="CRM-MDM MDM\u5ba2\u6237")
@RestController
@RequestMapping(value={"/mdmApi/customerController"})
public class CustomerController {
    @Autowired
    private CustomerService customerService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5ba2\u6237\u5217\u8868", notes="\u67e5\u8be2\u83dc\u5355\u6700\u5e95\u5c42\u5217\u8868,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\",\"customerCode\":\"\u5ba2\u6237\u7f16\u7801\",\"customerName\":\"\u5ba2\u6237\u6bcf\u6b21\",\"erpCode\":\"ERP\u7f16\u7801\",\"customerType\":\"\u5ba2\u6237\u7c7b\u578b\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"getCustomerPage"})
    public AjaxJson<TmCustomerEntity> getCustomerPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmCustomerEntity> customerEntityPageInfo = this.customerService.getCustomerPage(param, page);
        ajaxJson.setPageInfo(customerEntityPageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636eid\u6216\u8005\u5ba2\u6237\u7f16\u7801\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f", notes="\u6839\u636eid\u6216\u8005\u5ba2\u6237\u7f16\u7801\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\uff0c\u8fd4\u56deObj", httpMethod="GET")
    @GetMapping(value={"getCustomerByIdOrCode"})
    public AjaxJson<TmCustomerVo> getCustomerByIdOrCode(@RequestParam(value="id", required=false) String id, @RequestParam(value="customerCode", required=false) String customerCode) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setObj((Object)this.customerService.getCustomerByIdOrCode(id, customerCode));
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u5206\u9875\u67e5\u8be2\u5ba2\u6237/\u7ec8\u7aef\u5217\u8868", notes="\u6839\u636e\u804c\u4f4d\u5206\u9875\u67e5\u8be2\u5ba2\u6237/\u7ec8\u7aef\u5217\u8868,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\",\"posId\":\"\u804c\u4f4did\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"getCustomerByPosIdPage"})
    public AjaxJson<TmCustomerResultVo> getCustomerByPosIdPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmCustomerResultVo> pageInfo = this.customerService.getCustomerByPosIdPage(param, page);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u5206\u9875\u67e5\u8be2\u5ba2\u6237", notes="\u6839\u636e\u804c\u4f4d\u5206\u9875\u67e5\u8be2\u5ba2\u6237,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\",\"posId\":\"\u804c\u4f4did\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"getCustomerByPosPage"})
    public AjaxJson<TmCustomerResultVo> getCustomerByPosPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmCustomerResultVo> pageInfo = this.customerService.getCustomerByPosPage(param, page);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @PostMapping(value={"getCustomerComSelectPage"})
    public AjaxJson<TmCustomerEntity> getCustomerComSelectPage(@RequestBody CustomerFindVo customerFindVo) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page();
        page.setRows(customerFindVo.getRows());
        page.setPage(customerFindVo.getPage());
        PageInfo<TmCustomerEntity> pageInfo = this.customerService.getCustomerComSelectPage(customerFindVo, page);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237Code\u67e5\u8be2\u5ba2\u6237\u5197\u4f59\u4fe1\u606f", notes="\u6839\u636e\u5ba2\u6237code\u67e5\u8be2\u5ba2\u6237\u5197\u4f59\u4fe1\u606f\uff0c\u5197\u4f59\u4fe1\u606f\u5728list", httpMethod="GET")
    @GetMapping(value={"getCustomerDetailByCode"})
    public AjaxJson<TmCustPostVo> getCustomerDetailByCode(@RequestParam(value="customerCode", required=false) String customerCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TmCustomerVo tmCustomerVo = this.customerService.getCustomerByIdOrCode(null, customerCode);
        if (tmCustomerVo != null) {
            List<TmCustPostVo> tmCustPostVos = this.customerService.findTmCustPostDetailList(tmCustomerVo.getId());
            ajaxJson.setObjList(tmCustPostVos);
        }
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u5ba2\u6237\u5217\u8868", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u5ba2\u6237\u5217\u8868\uff0c\u4fe1\u606f\u5728list", httpMethod="GET")
    @GetMapping(value={"getCustListByOrgCodes"})
    public AjaxJson<TmCustomerEntity> getCustListByOrgCodes(@RequestParam(value="orgCodes", required=false) List<String> orgCodes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmCustomerEntity> customerEntities = this.customerService.getCustListByOrgCodes(orgCodes);
        ajaxJson.setList(customerEntities);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u7528\u6237id\u6216\u8005\u8d26\u53f7\u67e5\u8be2\u5ba2\u6237\u5217\u8868", notes="\u6839\u636e\u5f53\u524d\u7528\u6237id\u6216\u8005\u8d26\u53f7\u67e5\u8be2\u5ba2\u6237\u5217\u8868\uff0c\u4fe1\u606f\u5728list", httpMethod="GET")
    @GetMapping(value={"getCustListByCurrentUser"})
    public AjaxJson<TmCustomerEntity> getCustListByCurrentUser(@RequestParam(value="userId", required=false) String userId, @RequestParam(value="userName", required=false) String userName) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmCustomerEntity> customerEntities = this.customerService.getCustListByCurrentUser(userId, userName);
        ajaxJson.setList(customerEntities);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u6216\u8005\u5ba2\u6237ID\u67e5\u8be2\u5ba2\u6237\u5730\u5740\u5217\u8868", notes="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u6216\u8005\u5ba2\u6237ID\u67e5\u8be2\u5ba2\u6237\u5730\u5740\u5217\u8868\uff0c\u4fe1\u606f\u5728list", httpMethod="GET")
    @GetMapping(value={"getCustAddressListByCustomerCodeOrId"})
    public AjaxJson<TmAddressEntity> getCustAddressListByCustomerCodeOrId(@RequestParam(value="customerCode", required=false) String customerCode, @RequestParam(value="customerId", required=false) String customerId) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmAddressEntity> addressEntities = this.customerService.getCustAddressListByCustomerCodeOrId(customerCode, customerId);
        ajaxJson.setList(addressEntities);
        return ajaxJson;
    }

    @ApiOperation(value="\u516c\u53f8\u7f16\u7801\u3001\u804c\u4f4did\u6216\u8005code\uff0c\u5ba2\u6237\u8d26\u53f7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5206\u9875\u67e5\u8be2\u5ba2\u6237", notes="\u516c\u53f8\u7f16\u7801\u67e5\u8be2\u5206\u9875\u67e5\u8be2\u5ba2\u6237,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\",\"companyCodes\":\"\u53ef\u9009\u53c2\u6570\uff0c\u516c\u53f8\u7f16\u7801 \u591a\u4e2a\u4ee5\u9017\u53f7\u9694\u5f00\"\"posIds\":\"\u53ef\u9009\u53c2\u6570\uff0c\u804c\u4f4dID \u591a\u4e2a\u4ee5\u9017\u53f7\u9694\u5f00\"\"posCodes\":\"\u53ef\u9009\u53c2\u6570\uff0c\u804c\u4f4d\u7f16\u7801 \u591a\u4e2a\u4ee5\u9017\u53f7\u9694\u5f00\"\"userIds\":\"\u53ef\u9009\u53c2\u6570\uff0c\u5ba2\u6237\u8d26\u53f7ID \u591a\u4e2a\u4ee5\u9017\u53f7\u9694\u5f00\"\"userNames\":\"\u53ef\u9009\u53c2\u6570\uff0c\u5ba2\u6237\u8d26\u53f7 \u591a\u4e2a\u4ee5\u9017\u53f7\u9694\u5f00\"\"customerCode\":\"\u53ef\u9009\u53c2\u6570\uff0c\u5ba2\u6237\u7f16\u7801\"\"customerName\":\"\u53ef\u9009\u53c2\u6570\uff0c\u5ba2\u6237\u540d\u79f0\"\"custLevel\":\"\u53ef\u9009\u53c2\u6570\uff0c\u5ba2\u6237\u7ea7\u522b\"\"custType\":\"\u53ef\u9009\u53c2\u6570\uff0c\u5ba2\u6237\u7c7b\u578b\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"getCustomerByCompanyCodes"})
    public AjaxJson<TmCustomerEntity> getCustomerByCompanyCodes(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmCustomerEntity> pageInfo = this.customerService.getCustomerByCompanyCodes(param, page);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5206\u9875\u67e5\u8be2\u5ba2\u6237\u6240\u5c5e\u516c\u53f8\u5217\u8868", notes="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u6216\u8005\u5ba2\u6237ID\u67e5\u8be2\u516c\u53f8\u5206\u9875\u5217\u8868\u4fe1\u606f,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\",\"customerId\":\"\u5ba2\u6237ID\"\"customerCode\":\"\u5ba2\u6237\u7f16\u7801\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"getCustomerBusinesGroup"})
    public AjaxJson<TmRCustPosBgDetailVo> getCustomerBusinesGroup(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmRCustPosBgDetailVo> pageInfo = this.customerService.getCustomerBusinesGroup(param, page);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u5ba2\u6237\u96c6\u5408", notes="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u5ba2\u6237\u96c6\u5408", httpMethod="POST")
    @PostMapping(value={"getCustListByPosCodes"})
    public AjaxJson<TmCustomerEntity> getCustListByPosCodes(@RequestBody List<String> posCodes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmCustomerEntity> customerEntities = this.customerService.getCustListByPosCodes(posCodes);
        ajaxJson.setList(customerEntities);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u5bf9\u5e94\u5ba2\u6237\u96c6\u5408", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u5bf9\u5e94\u5ba2\u6237\u96c6\u5408", httpMethod="GET")
    @GetMapping(value={"getCustListByOrgDown"})
    public AjaxJson<TmCustomerEntity> getCustListByOrgDown(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="orgCode", required=false) String orgCode) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmCustomerEntity> list = this.customerService.getCustListByOrgDown(orgId, orgCode);
        ajaxJson.setList(list);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u5bf9\u5e94\u5ba2\u6237\u96c6\u5408", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u5bf9\u5e94\u5ba2\u6237\u96c6\u5408", httpMethod="GET")
    @GetMapping(value={"getCustListByOrg"})
    public AjaxJson<TmCustomerEntity> getCustListByOrg(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="orgCode", required=false) String orgCode) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmCustomerEntity> list = this.customerService.getCustListByOrg(orgId, orgCode);
        ajaxJson.setList(list);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u67e5\u8be2\u804c\u4f4d\u53ca\u5176\u4e0b\u7ea7\u804c\u4f4d\u5bf9\u5e94\u5ba2\u6237\u96c6\u5408", notes="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u67e5\u8be2\u804c\u4f4d\u53ca\u5176\u4e0b\u7ea7\u804c\u4f4d\u5bf9\u5e94\u5ba2\u6237\u96c6\u5408", httpMethod="GET")
    @GetMapping(value={"getCustListByPosDown"})
    public AjaxJson<TmCustomerEntity> getCustListByPosDown(@RequestParam(value="posId", required=false) String posId, @RequestParam(value="posCode", required=false) String posCode) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmCustomerEntity> list = this.customerService.getCustListByPosDown(posId, posCode);
        ajaxJson.setList(list);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u67e5\u8be2\u804c\u4f4d\u5bf9\u5e94\u5ba2\u6237\u96c6\u5408", notes="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u67e5\u8be2\u804c\u4f4d\u5bf9\u5e94\u5ba2\u6237\u96c6\u5408", httpMethod="GET")
    @GetMapping(value={"getCustListByPos"})
    public AjaxJson<TmCustomerEntity> getCustListByPos(@RequestParam(value="posId", required=false) String posId, @RequestParam(value="posCode", required=false) String posCode) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmCustomerEntity> list = this.customerService.getCustListByPos(posId, posCode);
        ajaxJson.setList(list);
        return ajaxJson;
    }
}

